/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.scratchpad;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPEditManager;
import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPWindowActionListener;
import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPWindowData;
import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPWindowWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SPWindow
extends JFrame {
    private static final String TITLE = Resource.getString("SP_WINDOW_TITLE");
    private static final int windowWidth = 490;
    private static final int windowHeight = 465;
    private int rowLength;
    private int rowNumberLen;
    private int nowRow;
    private static final int BYTE_PER_ROW = 16;
    private final int VIEW_COLUMN = 16;
    private final int LINE_COL = 5;
    private static final String ENCODING = "8859_1";
    private SPWindowData spData;
    private File spLocationDir;
    private JTextArea spTextArea;
    private MainWindow parent = null;
    private File spFile;
    JScrollPane spScrollPane;
    private JPanel pagePanel = null;
    private JPanel pageButtonPanel = null;
    private JPanel dialogButtonPanel = null;
    private JButton setButton = null;
    private JButton previousButton;
    private JButton nextButton;
    private JButton updateButton;
    private JButton replaceButton;
    private JButton reloadButton;
    private JComboBox jumpList;
    private JButton deleteButton;
    private JButton closeButton;
    private JButton exitButton;
    private StringBuffer[] spViewLines;
    private int activeIndex = -1;
    private SPEditManager manager;
    private int totalChannel;
    final int FORWARD = 0;
    final int BACK = 1;

    private void makeSPWindow(File file) throws FileNotFoundException, IOException {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.spTextArea = new JTextArea(16, 56);
        this.spTextArea.setFont(new Font("monospaced", 0, 15));
        JScrollPane jScrollPane = new JScrollPane(this.spTextArea);
        this.previousButton = new JButton(Resource.getString("SP_PREVIOUS"));
        this.nextButton = new JButton(Resource.getString("SP_NEXT"));
        this.reloadButton = new JButton(Resource.getString("SP_RELOAD"));
        String[] stringArray = new String[this.manager.getTotalChannel() + 1];
        for (int i = 0; i < this.manager.getTotalChannel() + 1; ++i) {
            stringArray[i] = String.valueOf(i + 1);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        this.jumpList = new JComboBox<String>(defaultComboBoxModel);
        this.updateButton = new JButton(Resource.getString("SP_UPDATE"));
        this.replaceButton = new JButton(Resource.getString("SP_REPLACE"));
        this.deleteButton = new JButton(Resource.getString("SP_REMOVE"));
        this.exitButton = new JButton(Resource.getString("SP_CLOSE"));
        this.setButton = new JButton(Resource.getString("SP_SET_CLOSE"));
        this.previousButton.setActionCommand("previous");
        this.nextButton.setActionCommand("next");
        this.reloadButton.setActionCommand("reload");
        this.jumpList.setActionCommand("jump");
        this.updateButton.setActionCommand("update");
        this.replaceButton.setActionCommand("read");
        this.deleteButton.setActionCommand("initialize");
        this.exitButton.setActionCommand("exit");
        this.setButton.setActionCommand("set");
        this.spTextArea.addFocusListener(new FocusAdapter(){

            public synchronized void focusGained(FocusEvent focusEvent) {
                SPWindow.this.onFocusEvent(focusEvent);
            }
        });
        this.spTextArea.addKeyListener(new KeyAdapter(){

            public synchronized void keyPressed(KeyEvent keyEvent) {
                SPWindow.this.onKeyEvent(keyEvent);
            }
        });
        this.spTextArea.addMouseListener(new MouseAdapter(){

            public synchronized void mouseClicked(MouseEvent mouseEvent) {
                SPWindow.this.onMouseEvent(mouseEvent);
            }
        });
        this.addWindowListener(new SPWindowWindowAdapter(this));
        SPWindowActionListener sPWindowActionListener = new SPWindowActionListener(this);
        this.previousButton.addActionListener(sPWindowActionListener);
        this.nextButton.addActionListener(sPWindowActionListener);
        this.reloadButton.addActionListener(sPWindowActionListener);
        this.jumpList.addActionListener(sPWindowActionListener);
        this.updateButton.addActionListener(sPWindowActionListener);
        this.replaceButton.addActionListener(sPWindowActionListener);
        this.deleteButton.addActionListener(sPWindowActionListener);
        this.exitButton.addActionListener(sPWindowActionListener);
        this.setButton.addActionListener(sPWindowActionListener);
        this.pageButtonPanel = new JPanel();
        this.pageButtonPanel.add(this.previousButton);
        this.pageButtonPanel.add(this.nextButton);
        this.pageButtonPanel.add(this.jumpList);
        this.pageButtonPanel.add(this.updateButton);
        this.pageButtonPanel.add(this.replaceButton);
        this.pageButtonPanel.add(this.deleteButton);
        this.dialogButtonPanel = new JPanel();
        this.dialogButtonPanel.add(this.reloadButton);
        this.dialogButtonPanel.add(this.setButton);
        this.dialogButtonPanel.add(this.exitButton);
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(new BorderLayout());
        this.pagePanel.setName("pagePanel");
        this.pagePanel.add("Center", jScrollPane);
        this.pagePanel.add("South", this.pageButtonPanel);
        container.add("Center", this.pagePanel);
        container.add("South", this.dialogButtonPanel);
        this.view();
        this.pack();
        this.setSize(490, 465);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        SPWindow sPWindow = new SPWindow();
    }

    private SPWindow() {
        try {
            this.spLocationDir = new File(System.getProperty("emu.home") + File.separator + "apps");
        }
        catch (NullPointerException nullPointerException) {
            this.spLocationDir = null;
        }
        String string = this.showFileChooser(0);
        if (string.equals("")) {
            System.exit(0);
        } else {
            try {
                this.makeSPWindow(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("SP_NOT_FOUND_ERR", string));
                System.exit(0);
            }
            catch (IOException iOException) {
                System.out.println(Resource.format("SP_READ_ERR", string));
                System.exit(0);
            }
            this.setVisible(true);
        }
    }

    public SPWindow(MainWindow mainWindow, File file) throws FileNotFoundException, IOException {
        try {
            this.spLocationDir = new File(System.getProperty("emu.home") + File.separator + "apps");
        }
        catch (NullPointerException nullPointerException) {
            this.spLocationDir = null;
        }
        this.parent = mainWindow;
        this.spFile = file;
        this.activeIndex = 0;
        try {
            this.manager = new SPEditManager(file);
            this.manager.setCurrentChannel(this.activeIndex);
            this.totalChannel = this.manager.getTotalChannel() + 1;
            this.makeSPWindow(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private String getWindowTitle() {
        String string = this.spFile.getName();
        String string2 = TITLE + " " + string;
        return string2;
    }

    private void setBorderTitle(int n) {
        Object[] objectArray = new String[]{String.valueOf(n + 1), String.valueOf(this.totalChannel)};
        this.pagePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), Resource.format("SP_BORDER_TITLE", objectArray), 0, 0, new Font("Dialog", 0, 10), Color.black));
    }

    public void view() {
        this.spTextArea.setText("");
        this.setTitle(TITLE);
        if (this.manager.exists()) {
            this.spData = new SPWindowData(this.getSPEditManager());
            this.activeIndex = 0;
            this.initViewLines();
            this.setDataToView();
            this.setRowPosition(0);
            if (this.manager.existData()) {
                this.spTextArea.setCaretPosition(this.rowNumberLen + 1);
                this.spTextArea.setVisible(true);
            } else {
                this.spTextArea.setText("");
                this.spTextArea.setVisible(false);
            }
            this.setTitle(this.getWindowTitle());
            this.setBorderTitle(this.activeIndex);
            this.spLocationDir = this.spFile;
        }
        this.setBtnState();
        this.spTextArea.setEditable(false);
        this.spTextArea.getCaret().setVisible(true);
    }

    public void previous() {
        this.jumpList.setSelectedIndex(this.activeIndex - 1);
    }

    public void next() {
        this.jumpList.setSelectedIndex(this.activeIndex + 1);
    }

    public void jump() {
        this.storeInMemory();
        this.spTextArea.setText("");
        int n = this.jumpList.getSelectedIndex();
        this.manager.setCurrentChannel(n);
        if (this.manager.exists()) {
            this.spData = new SPWindowData(this.manager);
            this.activeIndex = n;
            this.initViewLines();
            this.setDataToView();
            this.setRowPosition(0);
            if (this.manager.existData()) {
                this.spTextArea.setCaretPosition(this.rowNumberLen + 1);
                this.spTextArea.setVisible(true);
            } else {
                this.spTextArea.setText("");
                this.spTextArea.setVisible(false);
            }
            this.setBorderTitle(this.activeIndex);
        } else {
            System.out.println("this page doen not exists");
        }
        this.setBtnState();
        this.spTextArea.requestFocus();
    }

    public void reload() {
        this.activeIndex = 0;
        this.spTextArea.setText("");
        this.setTitle(TITLE);
        try {
            this.manager = new SPEditManager(this.spFile);
            this.manager.setCurrentChannel(this.activeIndex);
            this.totalChannel = this.manager.getTotalChannel() + 1;
            this.spData = new SPWindowData(this.manager);
            this.initViewLines();
            this.setDataToView();
            this.setRowPosition(0);
            if (this.manager.existData()) {
                this.spTextArea.setCaretPosition(this.rowNumberLen + 1);
                this.spTextArea.setVisible(true);
            } else {
                this.spTextArea.setText("");
                this.spTextArea.setVisible(false);
            }
            this.setTitle(this.getWindowTitle());
            this.setBorderTitle(this.activeIndex);
            this.jumpList.setSelectedIndex(this.activeIndex);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = Resource.format("SP_NOT_FOUND_ERR", this.spFile.getName());
            this.showDialog(string, this, 0);
            return;
        }
        catch (IOException iOException) {
            String string = Resource.format("SP_READ_ERR", this.spFile.getName());
            this.showDialog(string, this, 0);
            return;
        }
        this.spTextArea.requestFocus();
    }

    private void storeInMemory() {
        this.spData.update(this.viewStrToHexStr());
    }

    public void update() {
        int n = this.spTextArea.getCaretPosition();
        this.spData.update(this.viewStrToHexStr());
        try {
            this.spData.save();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setTitle(TITLE + " - " + this.spFile.getName());
            String string = Resource.format("SP_WRITE_ERR", this.spFile.getName());
            this.showDialog(string, this, 0);
            return;
        }
        catch (IOException iOException) {
            this.setTitle(TITLE + " - " + this.spFile.getName());
            String string = Resource.format("SP_WRITE_ERR", this.spFile.getName());
            this.showDialog(string, this, 0);
            return;
        }
        this.initViewLines();
        this.setDataToView();
        this.spTextArea.setCaretPosition(n);
        this.setBtnState();
        this.spTextArea.requestFocus();
    }

    public void allSave() {
        this.storeInMemory();
        try {
            this.getSPEditManager().storeAllToFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setTitle(TITLE + " - " + this.spFile.getName());
            String string = Resource.format("SP_WRITE_ERR", this.spFile.getName());
            this.showDialog(string, this, 0);
            return;
        }
        catch (IOException iOException) {
            this.setTitle(TITLE + " - " + this.spFile.getName());
            String string = Resource.format("SP_WRITE_ERR", this.spFile.getName());
            this.showDialog(string, this, 0);
            return;
        }
        this.exit();
    }

    public void read() {
        int n = this.spTextArea.getCaretPosition();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.rowNumberLen + 1;
        String string = null;
        boolean bl = false;
        String string2 = this.viewStrToHexStr();
        int n7 = string2.length();
        File file = null;
        String string3 = this.showFileChooser(1);
        if (string3 != null && !string3.equals("")) {
            Object object;
            file = new File(string3);
            if (!file.exists()) {
                return;
            }
            this.spData.update(string2);
            if (n > 0) {
                n3 = n / this.rowLength;
                n4 = (n % this.rowLength - this.rowNumberLen) / 3;
            }
            n5 = n3 * 32 + n4 * 2;
            try {
                object = new SPWindowData(file);
                if (((SPWindowData)object).getOriginData().length <= (n7 - n5) / 2) {
                    string = ((SPWindowData)object).getHexString(0, ((SPWindowData)object).getOriginData().length);
                    bl = true;
                } else {
                    string = ((SPWindowData)object).getHexString(0, (n7 - n5) / 2);
                }
                if (((SPWindowData)object).getOriginData() != null) {
                    n2 = ((SPWindowData)object).getOriginData().length;
                }
                this.spData.dataReplace(n5, string);
                this.spData.updateSaveData();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.setTitle(TITLE + " - " + this.spFile.getName());
                String string4 = Resource.format("READ_ERR", file.getName());
                this.showDialog(string4, this, 0);
                return;
            }
            catch (IOException iOException) {
                this.setTitle(TITLE + " - " + this.spFile.getName());
                String string5 = Resource.format("READ_ERR", file.getName());
                this.showDialog(string5, this, 0);
                return;
            }
            this.initViewLines();
            this.setDataToView();
            if (!bl) {
                object = Resource.getString("SP_REPLACE_WNG");
                this.showDialog((String)object, this, 2);
            }
            try {
                this.spTextArea.setCaretPosition(this.getCaretPositionAt(n3, n4, n2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int n8 = this.spTextArea.getText().length();
                this.spTextArea.setCaretPosition(n8);
            }
        }
        this.spTextArea.requestFocus();
    }

    public void initialize() {
        SPEditManager sPEditManager = this.getSPEditManager();
        if (sPEditManager.exists()) {
            String string = Resource.format("SP_DELETE_WNG", this.spFile.getName());
            JOptionPane jOptionPane = new JOptionPane(string, 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("WNG"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                sPEditManager.initialize();
                this.spData = new SPWindowData(sPEditManager);
                this.initViewLines();
                this.setDataToView();
                this.setRowPosition(0);
                this.spTextArea.setCaretPosition(this.rowNumberLen + 1);
                this.setTitle(this.getWindowTitle());
            }
            this.spTextArea.requestFocus();
        }
    }

    public void exit() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.parent.closeWindow(this);
        }
    }

    private void setBtnState() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.totalChannel;
        for (int i = 0; i < n3; ++i) {
            if (!this.manager.exists(i)) continue;
            if (!bl) {
                n = i;
                n2 = i;
            } else {
                n2 = i;
            }
            bl = true;
        }
        if (!bl) {
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.updateButton.setEnabled(false);
            this.replaceButton.setEnabled(false);
            this.reloadButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.spTextArea.setText("");
            this.setTitle(TITLE);
        } else {
            if (this.manager.existData()) {
                this.updateButton.setEnabled(true);
                this.replaceButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
            } else {
                this.updateButton.setEnabled(false);
                this.replaceButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            }
            this.reloadButton.setEnabled(true);
            if (n < this.activeIndex) {
                this.previousButton.setEnabled(true);
            } else {
                this.previousButton.setEnabled(false);
            }
            if (n2 > this.activeIndex) {
                this.nextButton.setEnabled(true);
            } else {
                this.nextButton.setEnabled(false);
            }
        }
    }

    private void readBtnState() {
        this.previousButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.deleteButton.setEnabled(true);
        this.updateButton.setEnabled(true);
        this.replaceButton.setEnabled(true);
    }

    private String showFileChooser(int n) {
        JFileChooser jFileChooser = this.spLocationDir == null ? new JFileChooser(".") : new JFileChooser(this.spLocationDir);
        int n2 = 0;
        if (n == 0) {
            jFileChooser.setFileFilter(new SPFileFilter());
        }
        n2 = jFileChooser.showOpenDialog(this);
        switch (n2) {
            case 0: {
                this.spLocationDir = jFileChooser.getCurrentDirectory();
                if (!jFileChooser.getSelectedFile().isFile()) break;
                return jFileChooser.getSelectedFile().getPath();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHexString(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        ByteArrayInputStream byteArrayInputStream;
        block10: {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            byteArrayOutputStream.write(byArray, n, n2);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n3;
                while ((n3 = byteArrayInputStream.read()) != -1) {
                    object = Integer.toHexString(n3).getBytes(ENCODING);
                    byte[] byArray2 = " ".getBytes(ENCODING);
                    byteArrayOutputStream.write(byArray2, 0, byArray2.length);
                    if (((Object)object).length == 1) {
                        byte[] byArray3 = "0".getBytes(ENCODING);
                        byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                    }
                    byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
                }
                object = byteArrayOutputStream.toString(ENCODING);
                Object var11_12 = null;
                if (byteArrayOutputStream == null) break block10;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string;
                block11: {
                    try {
                        string = new String("");
                        Object var11_13 = null;
                        if (byteArrayOutputStream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        block12: {
                            Object var11_14 = null;
                            if (byteArrayOutputStream != null) {
                                byteArrayOutputStream.close();
                            }
                            if (byteArrayInputStream == null) break block12;
                            byteArrayInputStream.close();
                        }
                        throw throwable;
                    }
                    byteArrayOutputStream.close();
                }
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                return string;
            }
            byteArrayOutputStream.close();
        }
        if (byteArrayInputStream != null) {
            byteArrayInputStream.close();
        }
        return object;
    }

    private void onFocusEvent(FocusEvent focusEvent) {
        int n = this.spTextArea.getCaretPosition();
        this.spTextArea.setCaretPosition(n);
        this.spTextArea.getCaret().setVisible(true);
    }

    private void onKeyEvent(KeyEvent keyEvent) {
        int n = this.spTextArea.getCaretPosition();
        int n2 = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        int n3 = keyEvent.getModifiers();
        int n4 = 0;
        if (n > this.rowNumberLen) {
            if (n2 == 86 && n3 == 2 || n2 == 155 && n3 == 1 || n2 == 88 && n3 == 2) {
                keyEvent.consume();
            } else if (n2 == 37) {
                n = this.spTextArea.getCaretPosition();
                int n5 = n % this.rowLength;
                try {
                    if (n == this.rowNumberLen + 1) {
                        this.spTextArea.setCaretPosition(n + 1);
                    } else if (this.spTextArea.getText().substring(n - 1).startsWith(" ")) {
                        if (n5 == this.rowNumberLen + 1) {
                            this.spTextArea.setCaretPosition(n - this.rowNumberLen - 2);
                        } else {
                            this.spTextArea.setCaretPosition(n - 1);
                        }
                    } else if (this.spTextArea.getText().substring(n - 1).startsWith("\n")) {
                        this.spTextArea.setCaretPosition(n - 1);
                    }
                }
                catch (Exception exception) {}
            } else if (n2 == 39) {
                n = this.spTextArea.getCaretPosition();
                try {
                    if (n > this.spTextArea.getDocument().getLength() - 2) {
                        this.spTextArea.setCaretPosition(n - 1);
                    } else if (n == this.spTextArea.getDocument().getLength() - 2) {
                        this.spTextArea.setCaretPosition(n);
                    } else if (this.spTextArea.getText().substring(n + 1).startsWith(" ")) {
                        this.spTextArea.setCaretPosition(n + 1);
                    } else if (this.spTextArea.getText().substring(n + 1).startsWith("\n")) {
                        this.spTextArea.setCaretPosition(n + this.rowNumberLen + 2);
                    }
                }
                catch (Exception exception) {}
            } else if (n2 == 38 || n2 == 33 || n2 == 35 || n2 == 40 || n2 == 34 || n2 == 36) {
                n = this.spTextArea.getCaretPosition();
                try {
                    if (n < this.rowNumberLen + 1) {
                        this.spTextArea.setCaretPosition(this.rowNumberLen + 1);
                    }
                }
                catch (Exception exception) {}
            } else if (n2 == 9) {
                n = this.spTextArea.getCaretPosition();
                this.spTextArea.setCaretPosition(n);
            } else if (n2 == 10) {
                n = this.spTextArea.getCaretPosition();
                n4 = this.spTextArea.getText().lastIndexOf(" ", n);
                if (n3 == 1) {
                    if (n4 < this.rowNumberLen + 1) {
                        n4 = this.spTextArea.getText().length();
                    }
                    this.spTextArea.setCaretPosition(n4 - 2);
                    this.skipSpace(1);
                    this.skipRowNumber(1);
                    n = this.spTextArea.getCaretPosition();
                    int n6 = n % this.rowLength;
                    if (n6 == this.rowLength - 2) {
                        this.spTextArea.setCaretPosition(n);
                    }
                } else {
                    n = this.spTextArea.getCaretPosition();
                    if (n >= this.spTextArea.getDocument().getLength() - 3) {
                        this.setRowPosition(0);
                        this.spTextArea.setCaretPosition(this.rowNumberLen + 1);
                    } else {
                        this.spTextArea.setCaretPosition(n + 3);
                    }
                    this.skipSpace(0);
                    this.skipRowNumber(0);
                }
            } else if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                n = this.spTextArea.getCaretPosition();
                if (n <= this.spTextArea.getDocument().getLength() - 1 && !this.spTextArea.getText().substring(n).startsWith(" ") && !this.spTextArea.getText().substring(n).startsWith("\n")) {
                    switch (c) {
                        case 'a': {
                            this.spTextArea.replaceRange("A", n, n + 1);
                            break;
                        }
                        case 'b': {
                            this.spTextArea.replaceRange("B", n, n + 1);
                            break;
                        }
                        case 'c': {
                            this.spTextArea.replaceRange("C", n, n + 1);
                            break;
                        }
                        case 'd': {
                            this.spTextArea.replaceRange("D", n, n + 1);
                            break;
                        }
                        case 'e': {
                            this.spTextArea.replaceRange("E", n, n + 1);
                            break;
                        }
                        case 'f': {
                            this.spTextArea.replaceRange("F", n, n + 1);
                            break;
                        }
                        default: {
                            this.spTextArea.replaceRange(String.valueOf(c), n, n + 1);
                        }
                    }
                }
                if ((n = this.spTextArea.getCaretPosition()) > this.spTextArea.getDocument().getLength() - 1) {
                    this.spTextArea.setCaretPosition(n - 1);
                } else if (n == this.spTextArea.getDocument().getLength() - 1) {
                    this.spTextArea.setCaretPosition(n);
                } else if (this.spTextArea.getText().substring(n).startsWith(" ")) {
                    this.spTextArea.setCaretPosition(n + 1);
                } else if (this.spTextArea.getText().substring(n).startsWith("\n")) {
                    this.spTextArea.setCaretPosition(n + this.rowNumberLen + 2);
                }
            } else if (c < '0' || c > '9' || c < 'a' || c > 'f' || c < 'A' || c > 'F') {
                // empty if block
            }
        }
        this.spTextArea.getCaret().setVisible(true);
    }

    private void onMouseEvent(MouseEvent mouseEvent) {
        int n = this.spTextArea.getCaretPosition();
        int n2 = n % this.rowLength;
        int n3 = n / this.rowLength;
        try {
            if (n2 < this.rowNumberLen + 1) {
                this.spTextArea.setCaretPosition(this.rowLength * n3 + this.rowNumberLen + 1);
            } else if (n < this.spTextArea.getDocument().getLength() - 1) {
                if (this.spTextArea.getText().substring(n).startsWith(" ")) {
                    this.spTextArea.setCaretPosition(n - 1);
                } else if (this.spTextArea.getText().substring(n).startsWith("\n")) {
                    this.spTextArea.setCaretPosition(n + this.rowNumberLen + 2);
                }
            } else {
                this.spTextArea.setCaretPosition(n - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.spTextArea.getCaret().setVisible(true);
    }

    private void showDialog(String string, JFrame jFrame, int n) {
        JOptionPane jOptionPane = new JOptionPane(string, n);
        JDialog jDialog = jOptionPane.createDialog(jFrame, n == 0 ? Resource.getString("ERR") : Resource.getString("WNG"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    public void skipRowNumber(int n) {
        int n2 = this.spTextArea.getCaretPosition();
        int n3 = n2 % this.rowLength;
        int n4 = n2;
        try {
            if (n3 < this.rowNumberLen) {
                n4 = n == 0 ? n2 + this.rowNumberLen - n3 + 1 : (n2 <= this.rowNumberLen ? this.rowNumberLen + 2 : n2 - n3 - 1);
                this.spTextArea.setCaretPosition(n4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void skipSpace(int n) {
        int n2 = 0;
        try {
            n2 = this.spTextArea.getCaretPosition();
            while (this.spTextArea.getSelectedText().trim().length() == 0) {
                n2 = this.spTextArea.getCaretPosition();
                if (n == 0) {
                    if (n2 == this.spTextArea.getDocument().getLength() - 1) continue;
                    this.spTextArea.setCaretPosition(n2 + 1);
                    continue;
                }
                this.spTextArea.setCaretPosition(n2 - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void initViewLines() {
        int n = 0;
        int n2 = this.spData.getOriginData().length;
        int n3 = n2 % 16 == 0 ? n2 / 16 : n2 / 16 + 1;
        if (n3 == 0) {
            ++n3;
        }
        this.spViewLines = new StringBuffer[n3];
        for (int i = 0; i < this.spViewLines.length; ++i) {
            this.spViewLines[i] = new StringBuffer();
            this.spViewLines[i].append(this.getRowNumberString(i * 16));
            n = i * 16;
            for (int j = 0; j < 16; ++j) {
                String string = this.spData.getHexString(n + j, 1);
                if (string.equals("")) {
                    this.spViewLines[i].append("\n");
                    break;
                }
                this.spViewLines[i].append(" ");
                this.spViewLines[i].append(string);
            }
            if (i >= this.spViewLines.length - 1) continue;
            this.spViewLines[i].append("\n");
        }
        this.rowLength = this.spViewLines[0].length();
        this.rowNumberLen = this.getRowNumberString(0).length();
    }

    private String getRowNumberString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toHexString(n);
        stringBuffer.append("0x");
        for (int i = 0; i < 5 - string.length(); ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string + " ");
        return stringBuffer.toString();
    }

    private void setDataToView() {
        try {
            this.spTextArea.setText("");
            for (int i = 0; i < this.spViewLines.length; ++i) {
                if (i != this.spViewLines.length - 1) {
                    this.spTextArea.append(this.spViewLines[i].toString());
                    continue;
                }
                this.spTextArea.append(this.spViewLines[i].toString().trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String viewStrToHexStr() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.spTextArea.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                this.spViewLines[n].delete(0, this.spViewLines[n].length());
                this.spViewLines[n].append(stringTokenizer.nextToken().trim());
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        for (n = 0; n < this.spViewLines.length; ++n) {
            String string2 = this.spViewLines[n].substring(7);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            while (stringTokenizer2.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer2.nextToken().trim());
            }
        }
        return stringBuffer.toString();
    }

    private int getCaretPositionAt(int n, int n2, int n3) {
        int n4 = n * 16 + n2;
        int n5 = n4 + n3;
        int n6 = 8;
        int n7 = 1;
        int n8 = 3;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        n = n5 / 16;
        n13 = n5 % 16;
        n9 = (n + 1) * n6;
        n10 = n5 * n8;
        n11 = n * n7;
        n12 = n9 + n10 + n11;
        if (n13 == 0) {
            n12 -= n6 + n7;
        }
        return n12;
    }

    public int getRowPosition() {
        return this.nowRow;
    }

    public void setRowPosition(int n) {
        this.nowRow = n;
    }

    private SPEditManager getSPEditManager() {
        return this.manager;
    }
}

