/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.AppPropSetupWindow;
import com.nttdocomo.dojaemu.ktoolbar.AppPropTabPanel;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;

class AppPropDeviceSetupTab
extends AppPropTabPanel
implements DocumentListener,
ItemListener {
    private static final int DEFAULT_CAMERA_DEVICE_NUM = 1;
    private static final int DEFAULT_CAMERA_FRAME_RATE = 15;
    private static final int DEFAULT_3D_RESOURCE = 4;
    private static final int MAX_3D_RESOURCE = 8;
    private static final int DEFAULT_ACCELERATION_MAX = 20;
    public static final int DEFAULT_COMPASS_MAX = 3000;
    private static final int MAX_ENTRY_COMPASS = 4;
    public static final int DEFAULT_COMPASS_INTERVAL = 100;
    public static final int DEFAULT_PEDOMETER_MAX = 30;
    private static final int MAX_ENTRY_PEDOMETER = 2;
    public static final int DEFAULT_GYROSENSOR_MAX = 3000;
    private static final int MAX_ENTRY_GYRO_SENSOR = 4;
    private static final int DEFAULT_GYROSENSOR_INTERVAL = 100;
    public static final int DEFAULT_GYROSENSOR_CALIBRATE = 10000;
    private static final int MAX_ENTRY = 6;
    private static final int MAX_PARAM = 36;
    private static final int MAX_GRID_X = 5;
    public static final String[] ACCELERATION_DEVICE = new String[]{"1", "2"};
    public static final int DEFAULT_MAX_BYTE = 128;
    public static final int DEFAULT_MAX_RUBY = 16;
    public static final int DEFAULT_READ_SPEED = 200;
    private JTextField cameraDeviceNum;
    private JTextField cameraDeviceRate;
    private JRadioButton cameraHdModeSelect;
    private JRadioButton cameraSwModeSelect;
    private JTextField sound3dResourceNum;
    private JComboBox accelerationDevice;
    private JTextField maxAccelerationSensorEntry;
    private JTextField maxCompassEntry;
    private JTextField compassMeasurementIntervalResolution;
    private JTextField maxPedometerEntry;
    private JTextField maxGyroSensorEntry;
    private JTextField measurementIntervalResolution;

    AppPropDeviceSetupTab(AbstractWindow abstractWindow, Setting setting, boolean bl) {
        super(abstractWindow, setting, bl);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("CAMERA_DEVICE_NUM"));
        this.cameraDeviceNum = new JTextField(6);
        this.cameraDeviceNum.setDocument(new HalfNumberDocument(6));
        JLabel jLabel2 = new JLabel(Resource.getString("CAMERA_FRAME_RATE"));
        this.cameraDeviceRate = new JTextField(6);
        this.cameraDeviceRate.setDocument(new HalfNumberDocument(2));
        JLabel jLabel3 = new JLabel(Resource.getString("SOUND3D_RESOURCE_NUM"));
        this.sound3dResourceNum = new JTextField(6);
        this.sound3dResourceNum.setDocument(new HalfNumberDocument(6));
        JLabel jLabel4 = new JLabel(Resource.getString("MAX_ACCELERATION_DEVICE"));
        this.accelerationDevice = new JComboBox<String>(ACCELERATION_DEVICE);
        this.accelerationDevice.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        JLabel jLabel5 = new JLabel(Resource.getString("MAX_ACCELERATION_DATA"));
        this.maxAccelerationSensorEntry = new JTextField(6);
        this.maxAccelerationSensorEntry.setDocument(new HalfNumberDocument(3));
        JLabel jLabel6 = new JLabel(Resource.getString("MAX_COMPASS_DATA"));
        JLabel jLabel7 = new JLabel(Resource.getString("MEASUREMENT_INTERVAL"));
        JLabel jLabel8 = new JLabel(Resource.getString("INTERVAL_UNIT"));
        this.maxCompassEntry = new JTextField(6);
        this.compassMeasurementIntervalResolution = new JTextField(6);
        this.maxCompassEntry.setDocument(new HalfNumberDocument(4));
        this.compassMeasurementIntervalResolution.setDocument(new HalfNumberDocument(6));
        JLabel jLabel9 = new JLabel(Resource.getString("MAX_PEDOMETER_DAYS"));
        this.maxPedometerEntry = new JTextField(6);
        this.maxPedometerEntry.setDocument(new HalfNumberDocument(2));
        JLabel jLabel10 = new JLabel(Resource.getString("MAX_GYROSENSOR_DATA"));
        JLabel jLabel11 = new JLabel(Resource.getString("MEASUREMENT_INTERVAL"));
        JLabel jLabel12 = new JLabel(Resource.getString("INTERVAL_UNIT"));
        this.maxGyroSensorEntry = new JTextField(6);
        this.measurementIntervalResolution = new JTextField(6);
        this.maxGyroSensorEntry.setDocument(new HalfNumberDocument(4));
        this.measurementIntervalResolution.setDocument(new HalfNumberDocument(6));
        this.cameraDeviceNum.getDocument().addDocumentListener(this);
        this.cameraDeviceRate.getDocument().addDocumentListener(this);
        this.sound3dResourceNum.getDocument().addDocumentListener(this);
        this.maxAccelerationSensorEntry.getDocument().addDocumentListener(this);
        this.maxCompassEntry.getDocument().addDocumentListener(this);
        this.compassMeasurementIntervalResolution.getDocument().addDocumentListener(this);
        this.maxPedometerEntry.getDocument().addDocumentListener(this);
        this.maxGyroSensorEntry.getDocument().addDocumentListener(this);
        this.measurementIntervalResolution.getDocument().addDocumentListener(this);
        this.accelerationDevice.addItemListener(this);
        String string = "";
        string = this.projectSetting.getProperty("cameraDevice");
        if (string != null) {
            this.cameraDeviceNum.setText(string);
        } else {
            this.cameraDeviceNum.setText(String.valueOf(1));
        }
        string = this.projectSetting.getProperty("cameraFrameRate");
        if (string != null) {
            this.cameraDeviceRate.setText(string);
        } else {
            this.cameraDeviceRate.setText(String.valueOf(15));
        }
        string = this.projectSetting.getProperty("sound3dResource");
        if (string != null) {
            this.sound3dResourceNum.setText(this.fitting3DResource(string));
        } else {
            this.sound3dResourceNum.setText(String.valueOf(4));
        }
        string = this.projectSetting.getProperty("accelerationDevice");
        if (string != null) {
            this.accelerationDevice.setSelectedItem(string);
        } else {
            this.accelerationDevice.setSelectedItem(String.valueOf(ACCELERATION_DEVICE[1]));
        }
        string = this.projectSetting.getProperty("accelerationDataMax");
        if (string != null) {
            this.maxAccelerationSensorEntry.setText(string);
        } else {
            this.maxAccelerationSensorEntry.setText(String.valueOf(20));
        }
        this.setReadSetting(this.projectSetting, this.maxCompassEntry, "compassMaxDataSize", String.valueOf(3000));
        this.setReadSetting(this.projectSetting, this.compassMeasurementIntervalResolution, "compassIntervalResolution", String.valueOf(100));
        this.setReadSetting(this.projectSetting, this.maxPedometerEntry, "daysForSavingPedometerDataMax", String.valueOf(30));
        string = this.projectSetting.getProperty("gyroSensorMaxDataSize");
        if (string != null) {
            this.maxGyroSensorEntry.setText(string);
        } else {
            this.maxGyroSensorEntry.setText(String.valueOf(3000));
        }
        string = this.projectSetting.getProperty("gyroSensorIntervalResolution");
        if (string != null) {
            this.measurementIntervalResolution.setText(string);
        } else {
            this.measurementIntervalResolution.setText(String.valueOf(100));
        }
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("CAMERA_INFO_SET")));
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("3D_SOUND_SET")));
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("ACCELERATION_SENSOR_SET")));
        jPanel5.setLayout(new GridBagLayout());
        jPanel5.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("COMPASS_SET")));
        jPanel6.setLayout(new GridBagLayout());
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("PEDOMETER_SET")));
        jPanel7.setLayout(new GridBagLayout());
        jPanel7.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("GYRO_SENSOR_SET")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.cameraDeviceNum, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel2.add((Component)this.cameraDeviceRate, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        JLabel jLabel13 = new JLabel(Resource.getString("CAMERA_MODE_TITLE"));
        this.cameraHdModeSelect = new JRadioButton();
        this.cameraSwModeSelect = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.cameraHdModeSelect);
        buttonGroup.add(this.cameraSwModeSelect);
        this.cameraHdModeSelect.setText(Resource.getString("CAMERA_HD_MODE_RADIO"));
        this.cameraSwModeSelect.setText(Resource.getString("CAMERA_SW_MODE_RADIO"));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        jPanel8.add(jLabel13);
        jPanel8.add(this.cameraHdModeSelect);
        jPanel8.add(this.cameraSwModeSelect);
        jPanel2.add((Component)jPanel8, gridBagConstraints);
        string = this.projectSetting.getProperty("cameraFocusMode");
        try {
            if (string.equals("1")) {
                this.cameraHdModeSelect.setSelected(true);
            } else {
                this.cameraSwModeSelect.setSelected(true);
            }
        }
        catch (Exception exception) {
            this.cameraSwModeSelect.setSelected(true);
        }
        this.cameraHdModeSelect.addItemListener(this);
        this.cameraSwModeSelect.addItemListener(this);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel3.add((Component)this.sound3dResourceNum, gridBagConstraints);
        int n = gridBagConstraints.gridx;
        while (n < 5) {
            gridBagConstraints.gridx = n++;
            jPanel3.add(Box.createHorizontalStrut(36), gridBagConstraints);
        }
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel4.add((Component)this.accelerationDevice, gridBagConstraints);
        n = gridBagConstraints.gridx;
        while (n < 5) {
            gridBagConstraints.gridx = n++;
            jPanel4.add(Box.createHorizontalStrut(36), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)jLabel5, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel4.add((Component)this.maxAccelerationSensorEntry, gridBagConstraints);
        n = gridBagConstraints.gridx;
        while (n < 5) {
            gridBagConstraints.gridx = n++;
            jPanel4.add(Box.createHorizontalStrut(36), gridBagConstraints);
        }
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel5.add((Component)jLabel6, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel5.add((Component)this.maxCompassEntry, gridBagConstraints);
        n = gridBagConstraints.gridx;
        while (n < 5) {
            gridBagConstraints.gridx = n++;
            jPanel5.add(Box.createHorizontalStrut(36), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel5.add((Component)jLabel7, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel5.add((Component)this.compassMeasurementIntervalResolution, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel5.add((Component)jLabel8, gridBagConstraints);
        n = gridBagConstraints.gridx;
        while (n < 5) {
            gridBagConstraints.gridx = n++;
            jPanel5.add(Box.createHorizontalStrut(36), gridBagConstraints);
        }
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel6.add((Component)jLabel9, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel6.add((Component)this.maxPedometerEntry, gridBagConstraints);
        n = gridBagConstraints.gridx;
        while (n < 5) {
            gridBagConstraints.gridx = n++;
            jPanel6.add(Box.createHorizontalStrut(36), gridBagConstraints);
        }
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel7.add((Component)jLabel10, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel7.add((Component)this.maxGyroSensorEntry, gridBagConstraints);
        n = gridBagConstraints.gridx;
        while (n < 5) {
            gridBagConstraints.gridx = n++;
            jPanel7.add(Box.createHorizontalStrut(36), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel7.add((Component)jLabel11, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel7.add((Component)this.measurementIntervalResolution, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel7.add((Component)jLabel12, gridBagConstraints);
        n = gridBagConstraints.gridx;
        while (n < 5) {
            gridBagConstraints.gridx = n++;
            jPanel7.add(Box.createHorizontalStrut(36), gridBagConstraints);
        }
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        jPanel.add(jPanel7);
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
    }

    @Override
    boolean check() {
        return this.checkAndSet(false);
    }

    @Override
    boolean set() {
        return this.checkAndSet(true);
    }

    @Override
    void cancel() {
    }

    private void setReadSetting(Setting setting, JTextField jTextField, String string, String string2) {
        String string3 = setting.getProperty(string);
        if (string3.equals("")) {
            jTextField.setText(string2);
            this.isChange = true;
        } else if (string3 != null) {
            jTextField.setText(string3);
        } else {
            jTextField.setText(string2);
        }
    }

    @Override
    protected void init() {
        this.projectSetting.setProperty("cameraDevice", String.valueOf(1));
        this.projectSetting.setProperty("cameraFrameRate", String.valueOf(15));
        this.projectSetting.setProperty("cameraFocusMode", "0");
        this.projectSetting.setProperty("sound3dResource", String.valueOf(4));
        this.projectSetting.setProperty("accelerationDevice", String.valueOf(ACCELERATION_DEVICE[1]));
        this.projectSetting.setProperty("accelerationDataMax", String.valueOf(20));
        this.projectSetting.setProperty("compassMaxDataSize", String.valueOf(3000));
        this.projectSetting.setProperty("compassIntervalResolution", String.valueOf(100));
        this.projectSetting.setProperty("daysForSavingPedometerDataMax", String.valueOf(30));
        this.projectSetting.setProperty("gyroSensorMaxDataSize", String.valueOf(3000));
        this.projectSetting.setProperty("gyroSensorIntervalResolution", String.valueOf(100));
    }

    private boolean checkAndSet(boolean bl) {
        String string = this.cameraDeviceNum.getText();
        String string2 = this.cameraDeviceRate.getText();
        String string3 = this.sound3dResourceNum.getText();
        String string4 = (String)this.accelerationDevice.getSelectedItem();
        String string5 = this.maxAccelerationSensorEntry.getText();
        String string6 = this.maxCompassEntry.getText();
        String string7 = this.compassMeasurementIntervalResolution.getText();
        String string8 = this.maxPedometerEntry.getText();
        String string9 = this.maxGyroSensorEntry.getText();
        String string10 = this.measurementIntervalResolution.getText();
        String string11 = null;
        string11 = this.cameraHdModeSelect.isSelected() ? "1" : "0";
        if ((string = this.checkNumStr(string)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.cameraDeviceNum.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("CAMERA_DEVICE_NUM")));
            return false;
        }
        if ((string2 = this.checkNumStr(string2)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.cameraDeviceRate.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("CAMERA_FRAME_RATE")));
            return false;
        }
        string2 = this.fittingCameraRate(string2);
        if ((string3 = this.checkNumStr(string3)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.sound3dResourceNum.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("SOUND3D_RESOURCE_NUM")));
            return false;
        }
        string3 = this.fitting3DResource(string3);
        if ((string4 = this.checkNumStr(string4)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.accelerationDevice.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("ACCELERATION_SENSOR_SET") + " - " + Resource.getString("MAX_ACCELERATION_DEVICE")));
            return false;
        }
        if ((string5 = this.checkNumStr(string5)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.maxAccelerationSensorEntry.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("ACCELERATION_SENSOR_SET") + " - " + Resource.getString("MAX_ACCELERATION_DATA")));
            return false;
        }
        if ((string6 = this.checkNumStr(string6)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.maxCompassEntry.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("COMPASS_SET") + " - " + Resource.getString("MAX_COMPASS_DATA")));
            return false;
        }
        if ((string7 = this.checkNumStr(string7)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.compassMeasurementIntervalResolution.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("COMPASS_SET") + " - " + Resource.getString("MEASUREMENT_INTERVAL")));
            return false;
        }
        if (!this.checkNumValue(string7)) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.compassMeasurementIntervalResolution.requestFocus();
            this.showDialog(Resource.format("SET_VALUE_WNG", Resource.getString("COMPASS_SET") + " - " + Resource.getString("MEASUREMENT_INTERVAL")));
            return false;
        }
        if ((string8 = this.checkNumStr(string8)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.maxPedometerEntry.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("PEDOMETER_SET") + " - " + Resource.getString("MAX_PEDOMETER_DAYS")));
            return false;
        }
        if ((string9 = this.checkNumStr(string9)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.maxGyroSensorEntry.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("GYRO_SENSOR_SET") + " - " + Resource.getString("MAX_GYROSENSOR_DATA")));
            return false;
        }
        if ((string10 = this.checkNumStr(string10)) == null) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.measurementIntervalResolution.requestFocus();
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("GYRO_SENSOR_SET") + " - " + Resource.getString("MEASUREMENT_INTERVAL")));
            return false;
        }
        if (!this.checkNumValue(string10)) {
            ((AppPropSetupWindow)this.tabwin).selectTab(this);
            this.measurementIntervalResolution.requestFocus();
            this.showDialog(Resource.format("SET_VALUE_WNG", Resource.getString("GYRO_SENSOR_SET") + " - " + Resource.getString("MEASUREMENT_INTERVAL")));
            return false;
        }
        if (bl) {
            this.projectSetting.setProperty("cameraDevice", string);
            this.projectSetting.setProperty("cameraFrameRate", string2);
            this.projectSetting.setProperty("cameraFocusMode", string11);
            this.projectSetting.setProperty("sound3dResource", string3);
            this.projectSetting.setProperty("accelerationDevice", string4);
            this.projectSetting.setProperty("accelerationDataMax", string5);
            this.projectSetting.setProperty("compassMaxDataSize", string6);
            this.projectSetting.setProperty("compassIntervalResolution", string7);
            this.projectSetting.setProperty("daysForSavingPedometerDataMax", string8);
            this.projectSetting.setProperty("gyroSensorMaxDataSize", string9);
            this.projectSetting.setProperty("gyroSensorIntervalResolution", string10);
        }
        return true;
    }

    private String checkNumStr(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
            if (n < 0) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return String.valueOf(n);
    }

    private boolean checkNumValue(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void showDialog(String string) {
        Object[] objectArray = new Object[]{Resource.getString("OK")};
        JOptionPane jOptionPane = new JOptionPane(string, 2, 0, null, objectArray);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("WNG"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    private String fitting3DResource(String string) {
        int n = 4;
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                n = n2 > 8 ? 8 : (n2 < 0 ? 0 : n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.valueOf(n);
    }

    private String fittingCameraRate(String string) {
        int n = 15;
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                n = n2 > 15 ? 15 : (n2 < 1 ? 15 : n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.valueOf(n);
    }
}

