/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class AtfDataEntry {
    public static final String SECTION_KEY_PROPERTY = "ATFDATAPROPERTY";
    public static final String SECTION_KEY_DATA = "ATFDATA_";
    public static final String S_KEY_PROPERTY_COUNT = "COUNT";
    public static final String S_KEY_DATA_PROJECT = "PROJECT_NAME";
    public static final String S_KEY_DATA_APP = "APP_NAME";
    public static final String S_KEY_DATA_URL = "URL";
    public static final String S_KEY_DATA_STOPTIME = "STOP_TIME";
    public static final String S_KEY_DATA_DESCRIPTION = "DESCRIPTION";
    public static final String S_KEY_DATA_STATUS = "STATUS";
    public static final String ATF_DATA_DAT = "atfdata.dat";
    private static final String ATF_DATA_PATH = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "atfdata.dat";
    private static final int ATF_DATA_COUNT = 0;
    private int count = 0;
    private ArrayList data = null;

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public ArrayList getData() {
        return this.data;
    }

    public void load() throws IOException {
        IniFileEntity iniFileEntity = new IniFileEntity(ATF_DATA_PATH);
        iniFileEntity.read();
        this.count = iniFileEntity.getSectionAttributeInt(SECTION_KEY_PROPERTY, S_KEY_PROPERTY_COUNT, 0);
        if (this.count <= 0) {
            return;
        }
        this.data = new ArrayList();
        for (int i = 0; i < this.count; ++i) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                String string = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_PROJECT);
                hashtable.put(S_KEY_DATA_PROJECT, string);
                String string2 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_APP);
                hashtable.put(S_KEY_DATA_APP, string2);
                String string3 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_URL);
                hashtable.put(S_KEY_DATA_URL, string3);
                String string4 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_STOPTIME);
                hashtable.put(S_KEY_DATA_STOPTIME, string4);
                String string5 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_DESCRIPTION);
                hashtable.put(S_KEY_DATA_DESCRIPTION, string5);
                String string6 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_STATUS);
                hashtable.put(S_KEY_DATA_STATUS, string6);
                this.data.add(hashtable);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() throws IOException {
        IniFileEntity iniFileEntity = new IniFileEntity(ATF_DATA_PATH);
        for (int i = 0; i < this.count; ++i) {
            Hashtable hashtable = (Hashtable)this.data.get(i);
            String string = (String)hashtable.get(S_KEY_DATA_PROJECT);
            String string2 = (String)hashtable.get(S_KEY_DATA_APP);
            String string3 = (String)hashtable.get(S_KEY_DATA_URL);
            String string4 = (String)hashtable.get(S_KEY_DATA_STOPTIME);
            String string5 = (String)hashtable.get(S_KEY_DATA_DESCRIPTION);
            String string6 = (String)hashtable.get(S_KEY_DATA_STATUS);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_PROJECT, string);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_APP, string2);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_URL, string3);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_STOPTIME, string4);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_DESCRIPTION, string5);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_STATUS, string6);
        }
        iniFileEntity.setSectionAttribute(SECTION_KEY_PROPERTY, S_KEY_PROPERTY_COUNT, Integer.toString(this.count));
        iniFileEntity.save();
    }

    public void delete(int n) throws IOException {
        this.data.remove(n);
        int n2 = this.getCount();
        this.setCount(--n2);
        this.save();
    }
}

