/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AtfDataEntry;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class AtfDataWindows
extends TabPanel {
    private JTable atfDataTable;
    private JScrollPane scrollpane;
    private JButton deleteButton;
    private AtfDataEntry ade = null;
    public static final String NOTIFICATION_NEVER = "-1";
    public static final String NOTIFICATION_PERMANENTLY = "0";

    AtfDataWindows(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.ade = new AtfDataEntry();
        try {
            this.ade.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel.add(this.deleteButton);
        this.atfDataTable = this.createAtfDataTable();
        this.scrollpane = new JScrollPane(this.atfDataTable);
        this.changeButtonEnabled();
        this.add("Center", this.scrollpane);
        this.add("South", jPanel);
    }

    private JTable createAtfDataTable() {
        JTable jTable = null;
        AtfTableModel atfTableModel = null;
        String[] stringArray = new String[]{Resource.getString("ATF_LBL_APP_NAME"), Resource.getString("ATF_LBL_URL"), Resource.getString("ATF_LBL_STOP_TIME"), Resource.getString("ATF_LBL_DESCRIPTION")};
        atfTableModel = new AtfTableModel(stringArray, 0);
        int n = this.ade.getCount();
        if (n > 0) {
            ArrayList arrayList = this.ade.getData();
            for (int i = 0; i < arrayList.size(); ++i) {
                Vector<Object> vector = new Vector<Object>();
                Hashtable hashtable = (Hashtable)arrayList.get(i);
                vector.addElement(hashtable.get("APP_NAME"));
                vector.addElement(hashtable.get("URL"));
                String string = (String)hashtable.get("STOP_TIME");
                if (NOTIFICATION_NEVER.equals(string)) {
                    vector.addElement(Resource.getString("ATF_STOP_NEVER"));
                } else if (NOTIFICATION_PERMANENTLY.equals(string)) {
                    vector.addElement(Resource.getString("ATF_STOP_PERMANENTLY"));
                } else {
                    vector.addElement(string);
                }
                vector.addElement(hashtable.get("DESCRIPTION"));
                atfTableModel.addRow(vector);
            }
        }
        jTable = new JTable(atfTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new AtfTableCellRenderer());
        jTable.setSelectionMode(0);
        return jTable;
    }

    public void delete() {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        if (this.atfDataTable.getSelectedRowCount() == 1) {
            int n = this.atfDataTable.getSelectedRow();
            int n2 = JOptionPane.showConfirmDialog(this, Resource.getString("ATF_DELETE_WNG"), Resource.getString("CONFIRM"), 0);
            if (n2 == 0) {
                try {
                    this.ade.delete(n);
                }
                catch (IOException iOException) {
                    this.parent.showDialog(Resource.format("WRITE_ERR", "atfdata.dat"), this, 2);
                }
                this.ade = new AtfDataEntry();
                try {
                    this.ade.load();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.atfDataTable = null;
                this.atfDataTable = this.createAtfDataTable();
                this.scrollpane = new JScrollPane(this.atfDataTable);
                this.add("Center", this.scrollpane);
                this.changeButtonEnabled();
                this.setVisible(true);
            }
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.atfDataTable.getRowCount() == 0) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
    }

    class AtfTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        AtfTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class AtfTableModel
    extends DefaultTableModel {
        AtfTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

