/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceDataBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothHostSetupWindow;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothManager;
import com.nttdocomo.dojaemu.ktoolbar.CheckUtil;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.bluetoothsettingwindow.OwnDevicePanel;
import com.nttdocomo.dojaemu.ktoolbar.bluetoothsettingwindow.OwnDevicePanelCaptionBean;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicListCellRenderer;
import com.nttdocomo.dojaemu.ktoolbar.swing.EditWindowInterface;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JComboBoxUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTableUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTextFieldUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.WidthBean;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.HalfLetterAndNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.HexDocument;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.LimitedHexDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class BluetoothSettingWindow
extends TabPanel
implements DocumentListener,
EditWindowInterface {
    private BluetoothBean bluetoothBean;
    public static final int SIZE_TEXTFIELD_LONG = 20;
    public static final int MAXBYTES_DEVICE_NAME = 32;
    public static final int SIZE_TEXTFIELD_SHORT = 4;
    private JButton buttonDeleteRemoteLauncherData;
    private JScrollPane scrollPaneRemoteLauncherData;
    private JTable tableRemoteLauncherData;
    private JTableUtil jtuRemoteLauncherData;
    private ActionDispatcher2 actionListener;
    private JButton buttonDeleteRegisterDevices;
    private static final int DIMENSION_WIDTH = 350;
    private static final int DIMENSION_HEIGHT = 95;
    private JTableUtil jtuRegisterDevices;
    private JTable tableRegisterDevices;
    private JScrollPane scrollPaneRegisterDevices;
    private static final int COLUMN_WIDTH = 150;
    private static final int COLUMN_WIDTH_SHORT = 120;
    private static final int COLUMN_WIDTH_LONG = 180;
    private DefaultListModel hostListModel = new DefaultListModel();
    private JList listHost = new JList(this.hostListModel);
    private JScrollPane scrollPaneListHost = null;
    private JButton buttonAdd = null;
    private JPanel panelButtonAdd = null;
    private JButton buttonEdit = null;
    private JPanel panelButtonEdit = null;
    private JButton buttonHostDelete = null;
    private JPanel panelButtonHostDelete = null;
    private JPanel panelButtonHost = null;
    private int maxConnection = 3;
    private OwnDevicePanel panelOwnBuluetoothDevice = null;
    private List<String> labelList = new ArrayList<String>();
    private JPanel panelDevices = null;
    private JPanel panelRemoteLauncher = null;
    private JPanel panelRegisterDevices = null;
    private JPanel panelHostlist = null;
    private JPanel panelHostlistList = null;
    private JLabel hostLabel = null;
    private JPanel panelMain = null;

    public BluetoothSettingWindow() {
    }

    public BluetoothSettingWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        this.actionListener = new ActionDispatcher2(this);
        this.labelList.add(Resource.getString("Bluetooth.common.caption.cod.mobile"));
        this.labelList.add(Resource.getString("Bluetooth.common.caption.cod.pc"));
        this.labelList.add(Resource.getString("Bluetooth.common.caption.cod.bloodPressureMonitor"));
        this.labelList.add(Resource.getString("Bluetooth.common.caption.cod.bodyThermometer"));
        this.bluetoothBean = BluetoothManager.read();
        this.maxConnection = this.bluetoothBean.getMaxConnection();
        this.panelMain = new JPanel();
        this.panelMain.setLayout(new BorderLayout());
        OwnDevicePanelCaptionBean ownDevicePanelCaptionBean = new OwnDevicePanelCaptionBean();
        ownDevicePanelCaptionBean.setTitle(Resource.getString("Bluetooth.common.caption.ownDeviceSetting"));
        ownDevicePanelCaptionBean.setDeviceName(Resource.getString("Bluetooth.common.caption.deviceName"));
        ownDevicePanelCaptionBean.setDeviceAddress(Resource.getString("Bluetooth.common.caption.bluetoothAddress"));
        ownDevicePanelCaptionBean.setCod(Resource.getString("Bluetooth.common.caption.cod"));
        ownDevicePanelCaptionBean.setSpecData(Resource.getString("Bluetooth.common.caption.specData"));
        ownDevicePanelCaptionBean.setLocalName(Resource.getString("Bluetooth.common.caption.localName"));
        ownDevicePanelCaptionBean.setUuid(Resource.getString("Bluetooth.common.caption.uuid"));
        this.panelOwnBuluetoothDevice = new OwnDevicePanel(ownDevicePanelCaptionBean);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtDeviceName(), 20, (Document)new HalfLetterAndNumberDocument(32), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtDeviceAddress1(), 2, (Document)new LimitedHexDocument(2), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtDeviceAddress2(), 2, (Document)new LimitedHexDocument(2), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtDeviceAddress3(), 2, (Document)new LimitedHexDocument(2), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtDeviceAddress4(), 2, (Document)new LimitedHexDocument(2), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtDeviceAddress5(), 2, (Document)new LimitedHexDocument(2), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtDeviceAddress6(), 2, (Document)new LimitedHexDocument(2), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtSpecData(), 20, (Document)new HexDocument(), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtLocalName(), 20, (Document)new PlainDocument(), this);
        JTextFieldUtil.settingBasicTextField(this.panelOwnBuluetoothDevice.getTxtUuid(), 4, (Document)new HalfNumberDocument(4), this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.buttonDeleteRegisterDevices = JButtonUtil.createBasicButton(Resource.getString("DELETE"), "registerDevicesDelete", this.actionListener);
        jPanel.add(new JLabel("  "));
        jPanel.add(this.buttonDeleteRegisterDevices);
        this.createRegisterDevicesTable();
        this.panelRegisterDevices = new JPanel();
        this.panelRegisterDevices.setLayout(new BorderLayout());
        this.panelRegisterDevices.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("Bluetooth.common.caption.registeredDevices")));
        this.panelRegisterDevices.add((Component)this.scrollPaneRegisterDevices, "West");
        this.panelRegisterDevices.add((Component)jPanel, "East");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.buttonDeleteRemoteLauncherData = JButtonUtil.createBasicButton(Resource.getString("DELETE"), "remoteLauncherDataDelete", this.actionListener);
        jPanel2.add(new JLabel("  "));
        jPanel2.add(this.buttonDeleteRemoteLauncherData);
        this.createRemoteLauncherDataTable();
        this.panelRemoteLauncher = new JPanel();
        this.panelRemoteLauncher.setLayout(new BorderLayout());
        this.panelRemoteLauncher.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("Bluetooth.common.caption.remoteLauncherData")));
        this.panelRemoteLauncher.add((Component)this.scrollPaneRemoteLauncherData, "West");
        this.panelRemoteLauncher.add((Component)jPanel2, "East");
        this.panelDevices = new JPanel();
        this.panelDevices.setLayout(new BoxLayout(this.panelDevices, 1));
        this.panelDevices.add(this.panelRegisterDevices);
        this.panelDevices.add(this.panelRemoteLauncher);
        this.panelHostlist = new JPanel();
        this.panelHostlist.setLayout(new BorderLayout());
        this.panelHostlist.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("Bluetooth.common.caption.scanDeviceData")));
        this.panelHostlist.add((Component)this.getPanelHostlistList(), "Center");
        this.panelHostlist.add((Component)this.getHostButtonPanel(), "East");
        this.panelMain.add((Component)this.panelOwnBuluetoothDevice, "North");
        this.panelMain.add((Component)this.panelDevices, "Center");
        this.panelMain.add((Component)this.panelHostlist, "South");
        this.add((Component)this.panelMain, "North");
        BluetoothDeviceDataBean bluetoothDeviceDataBean = this.bluetoothBean.getOwnBluetoothDeviceData();
        if (bluetoothDeviceDataBean != null) {
            this.panelOwnBuluetoothDevice.getTxtDeviceName().setText(bluetoothDeviceDataBean.getDeviceName());
            this.panelOwnBuluetoothDevice.getTxtDeviceAddress1().setText(bluetoothDeviceDataBean.getBluetoothAddress1());
            this.panelOwnBuluetoothDevice.getTxtDeviceAddress2().setText(bluetoothDeviceDataBean.getBluetoothAddress2());
            this.panelOwnBuluetoothDevice.getTxtDeviceAddress3().setText(bluetoothDeviceDataBean.getBluetoothAddress3());
            this.panelOwnBuluetoothDevice.getTxtDeviceAddress4().setText(bluetoothDeviceDataBean.getBluetoothAddress4());
            this.panelOwnBuluetoothDevice.getTxtDeviceAddress5().setText(bluetoothDeviceDataBean.getBluetoothAddress5());
            this.panelOwnBuluetoothDevice.getTxtDeviceAddress6().setText(bluetoothDeviceDataBean.getBluetoothAddress6());
            JComboBox jComboBox = this.panelOwnBuluetoothDevice.getComboCod();
            JComboBoxUtil.settingBasicComboBox(jComboBox, this.labelList, "deviceTypeChanged", this.actionListener);
            jComboBox.setSelectedIndex(bluetoothDeviceDataBean.getDeviceTypeComboboxIndex());
            this.panelOwnBuluetoothDevice.getTxtSpecData().setText(bluetoothDeviceDataBean.getSpecData());
            this.panelOwnBuluetoothDevice.getTxtLocalName().setText(bluetoothDeviceDataBean.getLocalname());
            this.panelOwnBuluetoothDevice.getTxtUuid().setText(bluetoothDeviceDataBean.getUuid());
        }
        this.updateRegisterDevicesTable();
        this.updateRemoteLauncherDataTable();
        for (int i = 0; i < this.bluetoothBean.getHostList().size(); ++i) {
            this.hostListModel.addElement(this.bluetoothBean.getHostList().get(i));
        }
        this.changeButtonState();
    }

    private void changeButtonState() {
        if (this.hostListModel.getSize() >= this.maxConnection) {
            this.buttonAdd.setEnabled(false);
        } else {
            this.buttonAdd.setEnabled(true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        try {
            this.checkInput();
            this.checkFormat();
            BluetoothDeviceDataBean bluetoothDeviceDataBean = this.bluetoothBean.getOwnBluetoothDeviceData();
            bluetoothDeviceDataBean.setDeviceName(this.panelOwnBuluetoothDevice.getTxtDeviceName().getText());
            bluetoothDeviceDataBean.setBluetoothAddress(this.panelOwnBuluetoothDevice.getTxtDeviceAddress1().getText(), this.panelOwnBuluetoothDevice.getTxtDeviceAddress2().getText(), this.panelOwnBuluetoothDevice.getTxtDeviceAddress3().getText(), this.panelOwnBuluetoothDevice.getTxtDeviceAddress4().getText(), this.panelOwnBuluetoothDevice.getTxtDeviceAddress5().getText(), this.panelOwnBuluetoothDevice.getTxtDeviceAddress6().getText());
            bluetoothDeviceDataBean.setDeviceTypeComboboxIndex(this.panelOwnBuluetoothDevice.getComboCod().getSelectedIndex());
            bluetoothDeviceDataBean.setSpecData(this.panelOwnBuluetoothDevice.getTxtSpecData().getText());
            bluetoothDeviceDataBean.setLocalname(this.panelOwnBuluetoothDevice.getTxtLocalName().getText());
            bluetoothDeviceDataBean.setUuid(this.panelOwnBuluetoothDevice.getTxtUuid().getText());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.hostListModel.size(); ++i) {
                arrayList.add((String)this.hostListModel.get(i));
            }
            this.bluetoothBean.setHostList(arrayList);
            try {
                BluetoothManager.write(this.bluetoothBean);
            }
            catch (Exception exception) {
                System.err.println(Resource.format("WRITE_ERR", exception.getMessage()));
                return false;
            }
        }
        catch (Exception exception) {
            this.parent.showDialog(exception.getMessage(), this, 2);
            return false;
        }
        return true;
    }

    public void registerDevicesDelete() {
        int[] nArray = this.tableRegisterDevices.getSelectedRows();
        if (this.tableRegisterDevices.getSelectedRowCount() == 1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("Bluetooth.common.message.delete.warn.registerDevice", String.valueOf(this.tableRegisterDevices.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                int n = 0;
                BluetoothDeviceBean bluetoothDeviceBean = null;
                for (BluetoothDeviceBean bluetoothDeviceBean2 : this.bluetoothBean.getBdbList()) {
                    if (!bluetoothDeviceBean2.isRegistered()) continue;
                    if (n == nArray[0]) {
                        bluetoothDeviceBean = bluetoothDeviceBean2;
                        break;
                    }
                    ++n;
                }
                bluetoothDeviceBean.setRegistered(false);
                bluetoothDeviceBean.setProjectName("");
                this.updateRegisterDevicesTable();
                this.updateRemoteLauncherDataTable();
                if (this.listener != null) {
                    this.listener.tabPanelEvent(this, 1, 0);
                }
            }
        }
    }

    public void remoteLauncherDataDelete() {
        int[] nArray = this.tableRemoteLauncherData.getSelectedRows();
        if (this.tableRemoteLauncherData.getSelectedRowCount() == 1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("Bluetooth.common.message.delete.remoteLauncher", String.valueOf(this.tableRemoteLauncherData.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                int n = 0;
                BluetoothDeviceBean bluetoothDeviceBean = null;
                for (BluetoothDeviceBean bluetoothDeviceBean2 : this.bluetoothBean.getBdbList()) {
                    if (!bluetoothDeviceBean2.isRemoteLaunch()) continue;
                    if (n == nArray[0]) {
                        bluetoothDeviceBean = bluetoothDeviceBean2;
                        break;
                    }
                    ++n;
                }
                bluetoothDeviceBean.setProjectName("");
                this.updateRemoteLauncherDataTable();
                if (this.listener != null) {
                    this.listener.tabPanelEvent(this, 1, 0);
                }
            }
        }
    }

    void add() {
        BluetoothHostSetupWindow bluetoothHostSetupWindow = new BluetoothHostSetupWindow(this.parent, "");
        bluetoothHostSetupWindow.setLocation(this.parent.getShowLocation(bluetoothHostSetupWindow.getWidth(), bluetoothHostSetupWindow.getHeight(), this.tabwin));
        bluetoothHostSetupWindow.setVisible(true);
        if (!bluetoothHostSetupWindow.isCanceled()) {
            this.hostListModel.addElement(bluetoothHostSetupWindow.getHost());
            this.changeButtonState();
            if (this.listener != null) {
                this.listener.tabPanelEvent(this, 1, 0);
            }
        }
    }

    void edit() {
        if (this.listHost.getSelectedIndex() != -1) {
            BluetoothHostSetupWindow bluetoothHostSetupWindow = new BluetoothHostSetupWindow(this.parent, (String)this.listHost.getSelectedValue());
            bluetoothHostSetupWindow.setLocation(this.parent.getShowLocation(bluetoothHostSetupWindow.getWidth(), bluetoothHostSetupWindow.getHeight(), this.tabwin));
            bluetoothHostSetupWindow.setVisible(true);
            if (!bluetoothHostSetupWindow.isCanceled()) {
                this.hostListModel.set(this.listHost.getSelectedIndex(), bluetoothHostSetupWindow.getHost());
                if (this.listener != null) {
                    this.listener.tabPanelEvent(this, 1, 0);
                }
            }
        }
    }

    void hostDelete() {
        int n;
        if (this.listHost.getSelectedIndex() != -1 && (n = JOptionPane.showConfirmDialog(this, Resource.getString("Bluetooth.common.message.delete.info.host"), Resource.getString("CONFIRM"), 0)) == 0) {
            this.hostListModel.remove(this.listHost.getSelectedIndex());
            this.changeButtonState();
            if (this.listener != null) {
                this.listener.tabPanelEvent(this, 1, 0);
            }
        }
    }

    void deviceTypeChanged() {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    private JScrollPane getHostList() {
        this.listHost.setSelectionMode(0);
        this.listHost.setCellRenderer(new BasicListCellRenderer());
        this.scrollPaneListHost = new JScrollPane(this.listHost);
        this.scrollPaneListHost.setPreferredSize(new Dimension(250, 70));
        this.listHost.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    BluetoothSettingWindow.this.edit();
                }
            }
        });
        this.listHost.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    BluetoothSettingWindow.this.edit();
                }
            }
        });
        return this.scrollPaneListHost;
    }

    private JPanel getPanelHostlistList() {
        if (this.panelHostlistList == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 3, 5, 5);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(7, 28, 7, 28);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            this.hostLabel = new JLabel();
            this.hostLabel.setText(Resource.getString("Bluetooth.common.caption.scanDevice"));
            this.panelHostlistList = new JPanel();
            this.panelHostlistList.setLayout(new GridBagLayout());
            this.panelHostlistList.add((Component)this.hostLabel, gridBagConstraints2);
            this.panelHostlistList.add((Component)this.getHostList(), gridBagConstraints);
        }
        return this.panelHostlistList;
    }

    private JButton getAddButton() {
        if (this.buttonAdd == null) {
            this.buttonAdd = new JButton();
            this.buttonAdd.setText(Resource.getString("ADD"));
            this.buttonAdd.setActionCommand("add");
            this.buttonAdd.addActionListener(this.actionListener);
        }
        return this.buttonAdd;
    }

    private JPanel getAddButtonPanel() {
        if (this.panelButtonAdd == null) {
            this.panelButtonAdd = new JPanel();
            this.panelButtonAdd.add((Component)this.getAddButton(), null);
        }
        return this.panelButtonAdd;
    }

    private JButton getEditButton() {
        if (this.buttonEdit == null) {
            this.buttonEdit = new JButton();
            this.buttonEdit.setText(Resource.getString("EDIT"));
            this.buttonEdit.setActionCommand("edit");
            this.buttonEdit.addActionListener(this.actionListener);
        }
        return this.buttonEdit;
    }

    private JPanel getEditButtonPanel() {
        if (this.panelButtonEdit == null) {
            this.panelButtonEdit = new JPanel();
            this.panelButtonEdit.add((Component)this.getEditButton(), null);
        }
        return this.panelButtonEdit;
    }

    private JButton getHostDeleteButton() {
        if (this.buttonHostDelete == null) {
            this.buttonHostDelete = new JButton();
            this.buttonHostDelete.setText(Resource.getString("REMOVE"));
            this.buttonHostDelete.setActionCommand("hostDelete");
            this.buttonHostDelete.addActionListener(this.actionListener);
        }
        return this.buttonHostDelete;
    }

    private JPanel getHostDeleteButtonPanel() {
        if (this.panelButtonHostDelete == null) {
            this.panelButtonHostDelete = new JPanel();
            this.panelButtonHostDelete.add((Component)this.getHostDeleteButton(), null);
        }
        return this.panelButtonHostDelete;
    }

    private JPanel getHostButtonPanel() {
        if (this.panelButtonHost == null) {
            this.panelButtonHost = new JPanel();
            this.panelButtonHost.setLayout(new BoxLayout(this.panelButtonHost, 1));
            this.panelButtonHost.add(this.getAddButtonPanel());
            this.panelButtonHost.add(this.getEditButtonPanel());
            this.panelButtonHost.add(this.getHostDeleteButtonPanel());
        }
        return this.panelButtonHost;
    }

    private List<Vector<String>> convertAndFilterData(List<BluetoothDeviceBean> list) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isRegistered()) continue;
            Vector<String> vector = new Vector<String>();
            vector.addElement(list.get(i).getBluetoothDeviceData().getDeviceName());
            vector.addElement(list.get(i).getBluetoothDeviceData().getBluetoothAddress());
            String string = this.labelList.get(list.get(i).getBluetoothDeviceData().getDeviceTypeComboboxIndex());
            vector.addElement(string);
            arrayList.add(vector);
        }
        return arrayList;
    }

    private List<Vector<String>> convertAndFilterDataRemoteLaunch(List<BluetoothDeviceBean> list) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isRemoteLaunch() || !list.get(i).isRegistered()) continue;
            Vector<String> vector = new Vector<String>();
            vector.addElement(list.get(i).getProjectName());
            vector.addElement(list.get(i).getBluetoothDeviceData().getDeviceName());
            vector.addElement(list.get(i).getBluetoothDeviceData().getBluetoothAddress());
            String string = this.labelList.get(list.get(i).getBluetoothDeviceData().getDeviceTypeComboboxIndex());
            vector.addElement(string);
            arrayList.add(vector);
        }
        return arrayList;
    }

    private void createRegisterDevicesTable() {
        String[] stringArray = new String[]{Resource.getString("Bluetooth.common.caption.deviceName"), Resource.getString("Bluetooth.common.caption.bluetoothAddress"), Resource.getString("Bluetooth.common.caption.cod")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(150, 150));
        arrayList.add(new WidthBean(150, 150));
        arrayList.add(new WidthBean(150, 150));
        this.jtuRegisterDevices = new JTableUtil();
        this.tableRegisterDevices = this.jtuRegisterDevices.createBasicTable(stringArray, arrayList, 2, this.convertAndFilterData(this.bluetoothBean.getBdbList()));
        this.scrollPaneRegisterDevices = JTableUtil.createBasicScrollPane(this.tableRegisterDevices, 350, 95);
    }

    private void updateRegisterDevicesTable() {
        this.setVisible(false);
        this.panelRegisterDevices.remove(this.scrollPaneRegisterDevices);
        this.tableRegisterDevices = this.jtuRegisterDevices.updateBasicTable(this.convertAndFilterData(this.bluetoothBean.getBdbList()));
        this.scrollPaneRegisterDevices = JTableUtil.createBasicScrollPane(this.tableRegisterDevices, 350, 95);
        this.panelRegisterDevices.add((Component)this.scrollPaneRegisterDevices, "Center");
        this.setVisible(true);
    }

    private void createRemoteLauncherDataTable() {
        String[] stringArray = new String[]{Resource.getString("Bluetooth.common.caption.appName"), Resource.getString("Bluetooth.common.caption.deviceName"), Resource.getString("Bluetooth.common.caption.bluetoothAddress"), Resource.getString("Bluetooth.common.caption.cod")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(120, 120));
        arrayList.add(new WidthBean(150, 150));
        arrayList.add(new WidthBean(180, 180));
        arrayList.add(new WidthBean(150, 150));
        this.jtuRemoteLauncherData = new JTableUtil();
        this.tableRemoteLauncherData = this.jtuRemoteLauncherData.createBasicTable(stringArray, arrayList, 2, this.convertAndFilterDataRemoteLaunch(this.bluetoothBean.getBdbList()));
        this.scrollPaneRemoteLauncherData = JTableUtil.createBasicScrollPane(this.tableRemoteLauncherData, 350, 95);
    }

    private void updateRemoteLauncherDataTable() {
        this.setVisible(false);
        this.panelRemoteLauncher.remove(this.scrollPaneRemoteLauncherData);
        this.tableRemoteLauncherData = this.jtuRemoteLauncherData.updateBasicTable(this.convertAndFilterDataRemoteLaunch(this.bluetoothBean.getBdbList()));
        this.scrollPaneRemoteLauncherData = JTableUtil.createBasicScrollPane(this.tableRemoteLauncherData, 350, 95);
        this.panelRemoteLauncher.add((Component)this.scrollPaneRemoteLauncherData, "Center");
        this.setVisible(true);
    }

    @Override
    public void checkInput() throws Exception {
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtDeviceName().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.deviceName")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtDeviceAddress1().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtDeviceAddress2().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtDeviceAddress3().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtDeviceAddress4().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtDeviceAddress5().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtDeviceAddress6().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtSpecData().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.specData")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtLocalName().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.localName")));
        }
        if ("".equals(this.panelOwnBuluetoothDevice.getTxtUuid().getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("Bluetooth.common.caption.uuid")));
        }
    }

    @Override
    public void checkFormat() throws Exception {
        if (this.panelOwnBuluetoothDevice.getTxtDeviceName().getText().getBytes().length > 32) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.deviceName")));
        }
        if (this.panelOwnBuluetoothDevice.getTxtDeviceAddress1().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelOwnBuluetoothDevice.getTxtDeviceAddress1().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelOwnBuluetoothDevice.getTxtDeviceAddress2().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelOwnBuluetoothDevice.getTxtDeviceAddress2().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelOwnBuluetoothDevice.getTxtDeviceAddress3().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelOwnBuluetoothDevice.getTxtDeviceAddress3().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelOwnBuluetoothDevice.getTxtDeviceAddress4().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelOwnBuluetoothDevice.getTxtDeviceAddress4().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelOwnBuluetoothDevice.getTxtDeviceAddress5().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelOwnBuluetoothDevice.getTxtDeviceAddress5().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        if (this.panelOwnBuluetoothDevice.getTxtDeviceAddress6().getText().getBytes().length != 2) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            Integer.parseInt(this.panelOwnBuluetoothDevice.getTxtDeviceAddress6().getText(), 16);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.bluetoothAddress")));
        }
        try {
            if (!CheckUtil.checkHex(this.panelOwnBuluetoothDevice.getTxtSpecData().getText())) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.specData")));
        }
        if (this.panelOwnBuluetoothDevice.getTxtUuid().getText().getBytes().length > 4) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.uuid")));
        }
        try {
            Integer.parseInt(this.panelOwnBuluetoothDevice.getTxtUuid().getText(), 10);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("Bluetooth.common.caption.uuid")));
        }
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    public List<BluetoothDeviceBean> getBluetoothDeviceBean() {
        return this.bluetoothBean.getBdbList();
    }

    public BluetoothBean getBluetoothBean() {
        return this.bluetoothBean;
    }
}

