/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.BookmarkEntry;
import com.nttdocomo.dojaemu.ktoolbar.BookmarkEntryWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class BookmarkWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 500;
    private static final int FRAME_HEIGHT = 200;
    private static String[] bookmarkFiles;
    private JTable bookmarkTable;
    private Hashtable bookmarkHash;
    private int[] idList;
    private int next;
    private JScrollPane scrollpane;
    private JButton deleteButton;
    private static final File bookmarkDir;
    private static final String EXTENSION_BOOKMARK = ".bmk";

    BookmarkWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel2.add(this.deleteButton);
        this.bookmarkTable = this.createBookmarkTable();
        this.scrollpane = new JScrollPane(this.bookmarkTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 200);
    }

    @Override
    boolean set() {
        return true;
    }

    private JTable createBookmarkTable() {
        String string = "";
        bookmarkFiles = bookmarkDir.list(new BookmarkFilter());
        String[] stringArray = new String[bookmarkFiles.length];
        this.bookmarkHash = new Hashtable();
        int n = 0;
        while (true) {
            block8: {
                int n2;
                if (n >= bookmarkFiles.length) break;
                String string2 = bookmarkDir.getPath() + File.separator + bookmarkFiles[n];
                int n3 = bookmarkFiles[n].indexOf(46);
                try {
                    n2 = Integer.parseInt(bookmarkFiles[n].substring(0, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    break block8;
                }
                try {
                    BookmarkEntry bookmarkEntry = new BookmarkEntry();
                    bookmarkEntry.setNo(n2);
                    if (bookmarkEntry.load(string2) == 0) {
                        this.bookmarkHash.put(new Integer(n2), bookmarkEntry);
                    }
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("NOT_FOUND_ERR", string2));
                }
            }
            ++n;
        }
        this.idList = new int[this.bookmarkHash.size()];
        Enumeration enumeration = this.bookmarkHash.keys();
        for (int i = 0; i < this.idList.length; ++i) {
            this.idList[i] = (Integer)enumeration.nextElement();
        }
        Arrays.sort(this.idList);
        this.next = this.idList.length > 0 ? this.idList[this.idList.length - 1] + 1 : 1;
        String[] stringArray2 = new String[]{Resource.getString("BOOKMARK_NAME"), Resource.getString("BOOKMARK_URL")};
        BookmarkTableModel bookmarkTableModel = new BookmarkTableModel(stringArray2, 0);
        for (int i = 0; i < this.idList.length; ++i) {
            BookmarkEntry bookmarkEntry = null;
            Object v = this.bookmarkHash.get(new Integer(this.idList[i]));
            if (v == null || !(v instanceof BookmarkEntry)) continue;
            bookmarkEntry = (BookmarkEntry)v;
            Vector<String> vector = new Vector<String>();
            vector.addElement(bookmarkEntry.getBookmarkName());
            vector.addElement(bookmarkEntry.getUrl());
            bookmarkTableModel.addRow(vector);
        }
        JTable jTable = new JTable(bookmarkTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new BookmarkTableCellRenderer());
        jTable.setSelectionMode(0);
        jTable.getColumnModel().getColumn(0).setMinWidth(200);
        jTable.getColumnModel().getColumn(0).setMaxWidth(200);
        this.changeButtonEnabled();
        return jTable;
    }

    void add() {
        BookmarkEntry bookmarkEntry = new BookmarkEntry();
        bookmarkEntry.setNo(this.next);
        BookmarkEntryWindow bookmarkEntryWindow = new BookmarkEntryWindow(this.parent, bookmarkEntry);
        bookmarkEntryWindow.setLocation(this.parent.getShowLocation(bookmarkEntryWindow.getWidth(), bookmarkEntryWindow.getHeight(), this.tabwin));
        bookmarkEntryWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.bookmarkTable = null;
        this.bookmarkTable = this.createBookmarkTable();
        this.scrollpane = new JScrollPane(this.bookmarkTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void delete() {
        int n = this.bookmarkTable.getSelectedRow();
        if (n != -1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("BOOKMARK_DELETE_WNG"), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                File file = new File(bookmarkDir, String.valueOf(this.idList[n]) + EXTENSION_BOOKMARK);
                file.delete();
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.bookmarkTable = null;
                this.bookmarkTable = this.createBookmarkTable();
                this.scrollpane = new JScrollPane(this.bookmarkTable);
                this.add("Center", this.scrollpane);
                this.setVisible(true);
            }
        }
    }

    @Override
    void cancel() {
    }

    private void changeButtonEnabled() {
        if (this.idList != null && this.idList.length > 0) {
            this.deleteButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    static {
        bookmarkDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "bookmark");
    }

    class BookmarkTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        BookmarkTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class BookmarkFilter
    implements FilenameFilter {
        BookmarkFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(bookmarkDir)) {
                return string.endsWith(BookmarkWindow.EXTENSION_BOOKMARK);
            }
            return false;
        }
    }

    class BookmarkTableModel
    extends DefaultTableModel {
        BookmarkTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

