/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CompassCsvReader;
import com.nttdocomo.dojaemu.ktoolbar.CompassCsvRecord;
import com.nttdocomo.dojaemu.ktoolbar.CompassCsvWriter;
import com.nttdocomo.dojaemu.ktoolbar.CompassDataEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.CompassDataUtil;
import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTableUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.WidthBean;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

class CompassDataWindow
extends TabPanel {
    private JTableUtil jtu;
    private static final String COMPASS_FILE = "compass.dat";
    private JTable tableCompass;
    private List<CompassCsvRecord> listRecord = new ArrayList<CompassCsvRecord>();
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private static final int ENABLED_WIDTH = 300;

    CompassDataWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel.add(this.addButton);
        jPanel.add(this.editButton);
        jPanel.add(this.deleteButton);
        this.createCompassTable();
        this.changeButtonEnabled();
        this.add("Center", this.scrollpane);
        this.add("South", jPanel);
    }

    private List<Vector<String>> convertData(List<CompassCsvRecord> list) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (CompassCsvRecord compassCsvRecord : list) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(compassCsvRecord.getYAxis().toString());
            vector.addElement(compassCsvRecord.getXAxis().toString());
            arrayList.add(vector);
        }
        return arrayList;
    }

    private void createCompassTable() {
        String[] stringArray = new String[]{Resource.getString("Compass.table.yAxis"), Resource.getString("Compass.table.xAxis")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(300, 300));
        this.readCsv();
        this.jtu = new JTableUtil();
        this.tableCompass = this.jtu.createBasicTable(stringArray, arrayList, 0, this.convertData(this.listRecord));
        this.tableCompass.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    CompassDataWindow.this.edit();
                }
            }
        });
        this.tableCompass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CompassDataWindow.this.edit();
                }
            }
        });
        this.scrollpane = new JScrollPane(this.tableCompass);
        this.changeButtonEnabled();
    }

    void add() {
        CompassCsvRecord compassCsvRecord = new CompassCsvRecord();
        CompassDataEditWindow compassDataEditWindow = new CompassDataEditWindow(this.parent, compassCsvRecord, -1);
        compassDataEditWindow.setLocation(this.parent.getShowLocation(compassDataEditWindow.getWidth(), compassDataEditWindow.getHeight(), this.tabwin));
        compassDataEditWindow.setVisible(true);
        if (!compassDataEditWindow.isCanceled()) {
            this.listRecord.add(compassCsvRecord);
            this.writeCsvAndUpdateTable();
        }
    }

    void edit() {
        int n = this.tableCompass.getSelectedRow();
        if (this.tableCompass.getSelectedRowCount() == 1) {
            CompassCsvRecord compassCsvRecord = this.listRecord.get(n);
            CompassDataEditWindow compassDataEditWindow = new CompassDataEditWindow(this.parent, compassCsvRecord, n);
            compassDataEditWindow.setLocation(this.parent.getShowLocation(compassDataEditWindow.getWidth(), compassDataEditWindow.getHeight(), this.tabwin));
            compassDataEditWindow.setVisible(true);
            if (!compassDataEditWindow.isCanceled()) {
                this.writeCsvAndUpdateTable();
            }
        }
    }

    void delete() {
        int n = this.tableCompass.getSelectedRow();
        if (this.tableCompass.getSelectedRowCount() != 0) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("Compass.delete.wng", String.valueOf(this.tableCompass.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                this.listRecord.remove(n);
                this.writeCsvAndUpdateTable();
            }
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private String getFilePath() {
        return Const.PATH_LIB_LOCATION + COMPASS_FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCsv() {
        block21: {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            CompassCsvReader compassCsvReader = null;
            try {
                CompassCsvRecord compassCsvRecord;
                fileReader = new FileReader(this.getFilePath());
                bufferedReader = new BufferedReader(fileReader);
                compassCsvReader = new CompassCsvReader(bufferedReader);
                this.listRecord = new ArrayList<CompassCsvRecord>();
                while ((compassCsvRecord = compassCsvReader.readRecord()) != null) {
                    this.listRecord.add(compassCsvRecord);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.listRecord.clear();
                this.writeCsv();
            }
            catch (IOException iOException) {
                if (!iOException.getMessage().equals("\u884c\u306e\u7d42\u7aef\u3067\u306a\u3044\u306e\u306b\u3082\u95a2\u308f\u3089\u305a\u30c7\u30ea\u30df\u30bf\u304c\u73fe\u308c\u305a\u306b\u884c\u304c\u7d42\u4e86\u3057\u3066\u3057\u307e\u3044\u307e\u3057\u305f\u3002")) break block21;
                CompassCsvRecord compassCsvRecord = new CompassCsvRecord();
                try {
                    compassCsvRecord.setYAxis(CompassDataUtil.toBigDecimal("000.000000"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    compassCsvRecord.setXAxis(CompassDataUtil.toBigDecimal("0.0"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.listRecord.add(compassCsvRecord);
            }
            finally {
                try {
                    compassCsvReader.close();
                    bufferedReader.close();
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCsv() {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        CompassCsvWriter compassCsvWriter = null;
        try {
            fileWriter = new FileWriter(this.getFilePath());
            bufferedWriter = new BufferedWriter(fileWriter);
            compassCsvWriter = new CompassCsvWriter(bufferedWriter);
            for (CompassCsvRecord compassCsvRecord : this.listRecord) {
                compassCsvWriter.writeRecord(compassCsvRecord);
            }
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", this.getFilePath()));
        }
        finally {
            try {
                compassCsvWriter.close();
                bufferedWriter.close();
                fileWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createTable() {
        this.createCompassTable();
        this.add("Center", this.scrollpane);
    }

    private void updateTable() {
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.tableCompass = null;
        this.createTable();
        this.setVisible(true);
    }

    private void writeCsvAndUpdateTable() {
        this.writeCsv();
        this.updateTable();
    }

    private void changeButtonEnabled() {
        if (this.listRecord != null && this.listRecord.size() > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }
}

