/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.JarAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

class ComponentListManager {
    private boolean isReqClass = true;
    private ArrayList jarPathList = new ArrayList();
    private ArrayList itemList = new ArrayList();
    private ArrayList useInfoList = new ArrayList();
    private int listNum = 0;
    static final int NAME = 0;
    static final int VER = 1;
    static final int AUTHOR = 2;
    static final int PROFILE = 3;
    static final int DATE = 4;
    private static final String JAR_EXTENSION = ".jar";

    ComponentListManager(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            this.loadListFile(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadListFile(File file) throws FileNotFoundException, IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string = "";
            int n = 0;
            String string2 = "";
            this.isReqClass = true;
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string.trim();
                if (n == 0) {
                    if (string2.length() == 0) continue;
                    if (string2.equals("true")) {
                        this.isReqClass = true;
                    } else if (string2.equals("false")) {
                        this.isReqClass = false;
                    } else if (!this.setInfo(string2)) continue;
                    ++n;
                    continue;
                }
                if (!this.setInfo(string2)) continue;
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean setInfo(String string) {
        int n = string.lastIndexOf(32);
        if (n != -1) {
            String string2 = string.substring(0, n).trim();
            File file = new File(string2);
            if (file.isDirectory()) {
                return false;
            }
            if (file.isFile() && !file.exists()) {
                return false;
            }
            JarAccess jarAccess = new JarAccess(string2);
            String string3 = string.substring(n + 1);
            if (string3.length() == 1) {
                char c = string3.charAt(0);
                boolean bl = false;
                bl = c == '1' ? true : (c == '0' ? false : false);
                if (!this.addItem(jarAccess, bl)) {
                    return false;
                }
            } else if (!this.addItem(jarAccess, false)) {
                return false;
            }
        }
        return true;
    }

    boolean addItem(String string, boolean bl) {
        int n = this.listNum;
        JarAccess jarAccess = new JarAccess(string);
        return this.addItem(n, jarAccess, bl);
    }

    boolean addItem(JarAccess jarAccess, boolean bl) {
        int n = this.listNum;
        return this.addItem(n, jarAccess, bl);
    }

    boolean addItem(int n, String string, boolean bl) {
        JarAccess jarAccess = new JarAccess(string);
        return this.addItem(n, jarAccess, bl);
    }

    boolean pushItem(String string, boolean bl) {
        int n = 0;
        JarAccess jarAccess = new JarAccess(string);
        return this.addItem(n, jarAccess, bl);
    }

    private boolean addItem(int n, JarAccess jarAccess, boolean bl) {
        try {
            if (!ComponentListManager.checkCompJar(jarAccess)) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        String string = jarAccess.getPath();
        boolean bl2 = this.jarPathList.contains(string);
        if (!bl2) {
            this.setItem(n, jarAccess);
            this.jarPathList.add(n, string);
            String string2 = bl ? "1" : "0";
            this.useInfoList.add(n, string2);
            ++this.listNum;
            return true;
        }
        return false;
    }

    private void setItem(int n, JarAccess jarAccess) {
        String[] stringArray = new String[]{"", "", "", "", ""};
        try {
            String[] stringArray2 = jarAccess.getRowItems();
            stringArray[0] = stringArray2[0];
            stringArray[1] = stringArray2[1];
            stringArray[2] = stringArray2[3];
            stringArray[3] = stringArray2[4];
            stringArray[4] = jarAccess.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.itemList.add(n, stringArray);
    }

    private void setItem(int n, String string) {
        JarAccess jarAccess = new JarAccess(string);
        this.setItem(n, jarAccess);
    }

    String[] getItem(int n) {
        return (String[])this.itemList.get(n);
    }

    String getJarPath(int n) {
        return (String)this.jarPathList.get(n);
    }

    String getUse(int n) {
        return (String)this.useInfoList.get(n);
    }

    String setUse(int n, String string) {
        return this.useInfoList.set(n, string);
    }

    boolean isUse(int n) {
        String string = (String)this.useInfoList.get(n);
        boolean bl = string == "1";
        return bl;
    }

    boolean isAllInclude() {
        return this.isReqClass;
    }

    void setAllInclude(boolean bl) {
        this.isReqClass = bl;
    }

    int itemUp(int n) {
        if (n < 0 || n >= this.listNum) {
            return n;
        }
        if (n + 1 >= this.listNum) {
            return n;
        }
        String string = (String)this.jarPathList.remove(n);
        this.jarPathList.add(n + 1, string);
        string = (String)this.useInfoList.remove(n);
        this.useInfoList.add(n + 1, string);
        return n + 1;
    }

    int itemDown(int n) {
        if (n <= 0 || n >= this.listNum) {
            return n;
        }
        String string = (String)this.jarPathList.remove(n);
        this.jarPathList.add(n - 1, string);
        string = (String)this.useInfoList.remove(n);
        this.useInfoList.add(n - 1, string);
        return n - 1;
    }

    boolean remove(int n) {
        if (n < 0 || n >= this.listNum) {
            return false;
        }
        this.jarPathList.remove(n);
        this.useInfoList.remove(n);
        this.itemList.remove(n);
        --this.listNum;
        return true;
    }

    int size() {
        return this.listNum;
    }

    boolean contains(String string) {
        return this.jarPathList.contains(string);
    }

    boolean isAdjustment() {
        return this.listNum == this.jarPathList.size() && this.listNum == this.useInfoList.size() && this.listNum == this.itemList.size();
    }

    static boolean checkCompJar(String string) throws IOException {
        Object object;
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            return false;
        }
        if (file.isFile()) {
            if (!file.exists()) {
                return false;
            }
            object = file.getPath().toLowerCase();
            if (!((String)object).endsWith(JAR_EXTENSION)) {
                return false;
            }
        }
        object = new JarAccess(string);
        return ComponentListManager.checkCompJar((JarAccess)object);
    }

    static boolean checkCompJar(JarAccess jarAccess) throws IOException {
        if (!jarAccess.isManifest()) {
            return false;
        }
        try {
            String[] stringArray = jarAccess.getRowItems();
            String string = stringArray[0];
            if (string == null || string.length() == 0) {
                return false;
            }
            String string2 = stringArray[4];
            if (string2 == null || string2.length() == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

