/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.ExternalDeviceParamWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindowDoButtonControl;
import com.nttdocomo.dojaemu.ktoolbar.ParamCheckUtil;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ContentsPackageParamWindow
extends AbstractWindow {
    private static final int DISP_SIZE_HEIGHT = 150;
    private static final int DISP_SIZE_WIDTH = 650;
    private static final int TXT_COLUMNS_MAX = 50;
    private JLabel paramLabel = null;
    private JTextField paramTextField;
    private JButton execButton = null;
    private JButton cancelButton = null;
    private MainWindow parent;
    private String params;

    public ContentsPackageParamWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("ContentsPackage.ktoolbar.caption.contentsPackage.windowTitle"));
        this.parent = mainWindow;
        this.initialize();
        this.getContentsPackageParam();
        this.setResizable(true);
        this.pack();
    }

    void exec() {
        Object object;
        this.params = this.paramTextField.getText();
        String[] stringArray = new String[]{};
        if (!this.params.equals("")) {
            object = this.params.replace("=", ",");
            stringArray = ParamCheckUtil.convertArray((String)object);
            try {
                ParamCheckUtil.checkParams(stringArray);
            }
            catch (Exception exception) {
                this.parent.showDialog(exception.getMessage(), this, 2);
                return;
            }
        }
        if (!ParamCheckUtil.check(this.params)) {
            this.parent.showDialog(Resource.getString("ContentsPackage.ktoolbar.message.setting.error.param"), this, 2);
            return;
        }
        object = ExternalDeviceParamWindow.parse(stringArray);
        if (this.setContentsPackageParam(this.params) != 0) {
            this.parent.showDialog(Resource.getString("ContentsPackage.ktoolbar.message.paramSaveError"), this, 2);
        }
        try {
            JAMManager.invokeApplication(this.parent.getAppType(), this.parent.getAdfPath(), this.parent.getJarPath(), 31, JAMManager.getParams((Hashtable)object), this.parent.getDeviceName(), this.parent.getAdfUrl(), this.parent.getProjectNameForBytes(), DebugTraceWindow.getDebugParam());
            this.parent.setEnabledDeviceMenu(false);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
        }
        MainWindowDoButtonControl.start(this.parent);
        this.parent.closeWindow(this);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private void initialize() {
        this.setSize(650, 150);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getParameterPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        return jPanel;
    }

    private JPanel getParameterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.paramLabel = new JLabel(Resource.getString("ContentsPackage.ktoolbar.caption.packageParamLabel"));
        this.paramLabel.setPreferredSize(new Dimension(80, 30));
        this.paramLabel.setHorizontalAlignment(2);
        this.paramLabel.setVerticalAlignment(3);
        jPanel2.add(this.paramLabel);
        jPanel3.add(this.getParamTextField());
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        jPanel.add((Component)this.getExecButton(), null);
        jPanel.add((Component)this.getCancelButton(), null);
        return jPanel;
    }

    private JTextField getParamTextField() {
        this.paramTextField = new JTextField();
        this.paramTextField.setPreferredSize(new Dimension(500, 25));
        this.paramTextField.setColumns(50);
        this.paramTextField.setHorizontalAlignment(2);
        return this.paramTextField;
    }

    private JButton getExecButton() {
        this.execButton = new JButton(Resource.getString("ContentsPackage.ktoolbar.caption.invokeButton"));
        this.execButton.setActionCommand("exec");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.execButton.addActionListener(actionDispatcher);
        return this.execButton;
    }

    private JButton getCancelButton() {
        this.cancelButton = new JButton(Resource.getString("ContentsPackage.ktoolbar.caption.cancelButton"));
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.cancelButton.addActionListener(actionDispatcher);
        return this.cancelButton;
    }

    private void getContentsPackageParam() {
        this.params = this.parent.projectSetting.getProperty("contentsPackageParam");
        this.paramTextField.setText(this.params);
    }

    private int setContentsPackageParam(String string) {
        Setting setting = this.parent.getProjectSetting();
        setting.setProperty("contentsPackageParam", this.params);
        return this.parent.saveProjectSetting(setting);
    }
}

