/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

class DTVParameter {
    static final int FREQUENCY_MIN = 13;
    static final int FREQUENCY_MAX = 62;
    static final int SERVICE_ID_MIN = 0;
    static final int SERVICE_ID_MAX = (int)Math.pow(2.0, 16.0) - 1;
    static final int AFFILIATION_ID_MIN = 0;
    static final int AFFILIATION_ID_MAX = 11;
    static final int VALUE_NONE = -1;
    private int serviceId = -1;
    private int frequency = -1;
    private int affiliationId = -1;
    private String adfFileName = null;

    public void setFrequency(int n) {
        if (n != -1 && (n < 13 || 62 < n)) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        this.frequency = n;
    }

    public void setServiceId(int n) {
        if (n != -1 && (n < 0 || SERVICE_ID_MAX < n)) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        this.serviceId = n;
    }

    public void setAffiliationId(int n) {
        if (n != -1 && (n < 0 || 11 < n)) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        this.affiliationId = n;
    }

    public void setADFFileName(String string) {
        this.adfFileName = string;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public int getAffiliationId() {
        return this.affiliationId;
    }

    public String getADFFileName() {
        return this.adfFileName;
    }
}

