/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.DTVParameter;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

class DTVProperty {
    private static final String PARAM_FREQUENCY = "frequency";
    private static final String PARAM_SERVICE_ID = "service_id";
    private static final String PARAM_AFFILIATION_ID = "affiliation_id";
    private static final String PARAM_ADF = "ADF";
    private static final String DTVPropertyPath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "DTV.properties";
    private DTVParameter parameter = new DTVParameter();
    private Properties props = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTVProperty() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(DTVPropertyPath);
            this.props.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", DTVPropertyPath));
        }
        catch (Exception exception) {
            System.err.println(Resource.format("READ_ERR", DTVPropertyPath));
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            this.parameter.setFrequency(this.getPropertyInt(PARAM_FREQUENCY, -1));
        }
        catch (Exception exception) {
            this.parameter.setFrequency(-1);
        }
        try {
            this.parameter.setServiceId(this.getPropertyInt(PARAM_SERVICE_ID, -1));
        }
        catch (Exception exception) {
            this.parameter.setServiceId(-1);
        }
        try {
            this.parameter.setAffiliationId(this.getPropertyInt(PARAM_AFFILIATION_ID, -1));
        }
        catch (Exception exception) {
            this.parameter.setAffiliationId(-1);
        }
        this.parameter.setADFFileName(this.props.getProperty(PARAM_ADF, ""));
    }

    private int getPropertyInt(String string, int n) {
        int n2 = n;
        try {
            String string2 = this.props.getProperty(string);
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public DTVParameter getProperty() {
        return this.parameter;
    }

    public void setProperty(DTVParameter dTVParameter) {
        this.parameter = dTVParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        this.props.setProperty(PARAM_FREQUENCY, Integer.toString(this.parameter.getFrequency()));
        this.props.setProperty(PARAM_SERVICE_ID, Integer.toString(this.parameter.getServiceId()));
        this.props.setProperty(PARAM_AFFILIATION_ID, Integer.toString(this.parameter.getAffiliationId()));
        this.props.setProperty(PARAM_ADF, this.parameter.getADFFileName());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(DTVPropertyPath);
            this.props.store(fileOutputStream, null);
        }
        catch (Exception exception) {
            System.err.println(Resource.format("WRITE_ERR", DTVPropertyPath));
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

