/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.DTVParameter;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.ComboBoxUI;

class DTVSelectWindow
extends JDialog {
    private JTextField tfdServiceId;
    private JTextField tfdFrequency;
    private JComboBox cmbAffiliationId;
    private DTVParameter parameter;
    private boolean saveFlag;

    DTVSelectWindow(JFrame jFrame, DTVParameter dTVParameter) {
        super(jFrame, Resource.getString("DTV_LBL_SELECT_PROGRAM"), true);
        this.parameter = dTVParameter;
        this.saveFlag = false;
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("DTV_LBL_SERVICE_ID"));
        JLabel jLabel2 = new JLabel(Resource.getString("DTV_LBL_FREQUENCY"));
        JLabel jLabel3 = new JLabel(Resource.getString("DTV_LBL_AFFILIATION_ID"));
        jLabel.setHorizontalAlignment(4);
        jLabel2.setHorizontalAlignment(4);
        jLabel3.setHorizontalAlignment(4);
        this.tfdServiceId = new JTextField(6);
        this.tfdFrequency = new JTextField(3);
        this.tfdServiceId.setDocument(new HalfNumberDocument(5));
        this.tfdFrequency.setDocument(new HalfNumberDocument(2));
        int n = this.parameter.getServiceId();
        if (n == -1) {
            this.tfdServiceId.setText("");
        } else {
            this.tfdServiceId.setText(Integer.toString(n));
        }
        int n2 = this.parameter.getFrequency();
        if (n2 == -1) {
            this.tfdFrequency.setText("");
        } else {
            this.tfdFrequency.setText(Integer.toString(n2));
        }
        String[] stringArray = new String[13];
        int n3 = this.parameter.getAffiliationId();
        stringArray[0] = "--";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringArray[i + 1] = Integer.toString(i);
        }
        this.cmbAffiliationId = new JComboBox<String>(stringArray);
        this.cmbAffiliationId.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        if (n3 < 0) {
            this.cmbAffiliationId.setSelectedIndex(0);
        } else {
            this.cmbAffiliationId.setSelectedIndex(n3 + 1);
        }
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2, 10, 5));
        jPanel.add(jLabel);
        jPanel.add(this.tfdServiceId);
        jPanel.add(jLabel2);
        jPanel.add(this.tfdFrequency);
        jPanel.add(jLabel3);
        jPanel.add(this.cmbAffiliationId);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        container.add("North", new JPanel());
        container.add("West", new JPanel());
        container.add("Center", jPanel);
        container.add("East", new JPanel());
        container.add("South", jPanel2);
        this.pack();
        this.setSize(new Dimension(jFrame.getWidth(), this.getHeight()));
        this.setResizable(false);
    }

    void set() {
        int n;
        try {
            n = this.getInputValue(this.tfdServiceId, 0, DTVParameter.SERVICE_ID_MAX);
            this.parameter.setServiceId(n);
        }
        catch (Exception exception) {
            JOptionPane jOptionPane = new JOptionPane(exception.getMessage(), 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("DTV_LBL_SERVICE_ID"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            return;
        }
        try {
            n = this.getInputValue(this.tfdFrequency, 13, 62);
            this.parameter.setFrequency(n);
        }
        catch (Exception exception) {
            JOptionPane jOptionPane = new JOptionPane(exception.getMessage(), 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("DTV_LBL_FREQUENCY"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            return;
        }
        n = this.cmbAffiliationId.getSelectedIndex();
        if (n <= 0) {
            this.parameter.setAffiliationId(-1);
        } else {
            this.parameter.setAffiliationId(n - 1);
        }
        this.saveFlag = true;
        this.dispose();
    }

    private int getInputValue(JTextField jTextField, int n, int n2) throws Exception {
        int n3 = -1;
        String string = jTextField.getText();
        if (string != null && !string.equals("")) {
            try {
                n3 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new Exception(Resource.getString("DTV_WNG_INVALID_INPUT_VALUE"));
            }
            if (n3 < n || n2 < n3) {
                Object[] objectArray = new String[]{String.valueOf(n), String.valueOf(n2)};
                throw new Exception(Resource.format("DTV_WNG_OVER_RANGE", objectArray));
            }
        }
        return n3;
    }

    void cancel() {
        this.dispose();
    }

    public boolean showWindow() {
        this.setVisible(true);
        this.dispose();
        return this.saveFlag;
    }
}

