/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DataBoxImageEntryUtil;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.ImageFileChooser;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindowDoButtonControl;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataBoxImageEntryWindow
extends AbstractWindow {
    private static final String ENTRY_ID_KEY = "entry-id";
    private static final int DISP_SIZE_HEIGHT = 150;
    private static final int DISP_SIZE_WIDTH = 550;
    private static final int TXT_COLUMNS_MAX = 40;
    private JLabel paramLabel = null;
    private JTextField paramTextField;
    private JButton execButton;
    private JButton cancelButton;
    private JButton referenceButton;
    private int entryId = 0;
    private String dataBoxPath = null;
    private MainWindow parent = null;
    private String params;

    public DataBoxImageEntryWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("DATABOX_PARAM_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.dataBoxPath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "multimedia" + File.separator + "mypicture";
        this.initialize();
        this.getDataBoxImageParam();
        this.setResizable(true);
        this.pack();
    }

    public void exec() {
        this.params = this.paramTextField.getText();
        String string = this.params = this.params == null ? "" : this.params.trim();
        if (this.params == null || this.params.equals("")) {
            this.parent.showDialog(Resource.getString("DATABOX_PARAM_NOT_INPUT_MSG"), this, 2);
            return;
        }
        try {
            this.entryId = DataBoxImageEntryUtil.check(this.params, this.dataBoxPath);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("DATABOX_PARAM_ERROR_MSG"), this, 2);
            return;
        }
        if (this.setDataBoxImageParam(this.params) != 0) {
            this.parent.showDialog(Resource.getString("SCHEDULER_PARAM_SAVE_ERR_WNG"), this, 2);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(ENTRY_ID_KEY, String.valueOf(this.entryId));
        try {
            JAMManager.invokeApplication(this.parent.getAppType(), this.parent.getAdfPath(), this.parent.getJarPath(), 29, JAMManager.getParams(hashtable), this.parent.getDeviceName(), this.parent.getAdfUrl(), this.parent.getProjectNameForBytes(), DebugTraceWindow.getDebugParam());
            this.parent.setEnabledDeviceMenu(false);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
        }
        MainWindowDoButtonControl.start(this.parent);
        this.parent.closeWindow(this);
    }

    public void reference() {
        String string = null;
        try {
            ImageFileChooser imageFileChooser = new ImageFileChooser();
            string = imageFileChooser.showImageDialog(this.dataBoxPath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null && !string.equals("")) {
            this.paramTextField.setText(string);
        }
    }

    public void cancel() {
        this.parent.closeWindow(this);
    }

    private void initialize() {
        this.setSize(550, 150);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getParameterPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        return jPanel;
    }

    private JPanel getParameterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.paramLabel = new JLabel(Resource.getString("DATABOX_PARAM_LABEL"));
        this.paramLabel.setPreferredSize(new Dimension(80, 30));
        this.paramLabel.setHorizontalAlignment(2);
        this.paramLabel.setVerticalAlignment(3);
        jPanel2.add(this.paramLabel);
        jPanel3.add(this.getParamTextField());
        jPanel3.add(this.getRefButton());
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        jPanel.add((Component)this.getExecButton(), null);
        jPanel.add((Component)this.getCancelButton(), null);
        return jPanel;
    }

    private JTextField getParamTextField() {
        this.paramTextField = new JTextField();
        this.paramTextField.setPreferredSize(new Dimension(400, 25));
        this.paramTextField.setColumns(40);
        this.paramTextField.setHorizontalAlignment(2);
        return this.paramTextField;
    }

    private JButton getRefButton() {
        this.referenceButton = new JButton(Resource.getString("DATABOX_PARAM_BUTTON_REFERENCE"));
        this.referenceButton.setActionCommand("reference");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.referenceButton.addActionListener(actionDispatcher);
        return this.referenceButton;
    }

    private JButton getExecButton() {
        this.execButton = new JButton(Resource.getString("DATABOX_PARAM_BUTTON_INVOKE"));
        this.execButton.setActionCommand("exec");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.execButton.addActionListener(actionDispatcher);
        return this.execButton;
    }

    private JButton getCancelButton() {
        this.cancelButton = new JButton(Resource.getString("DATABOX_PARAM_BUTTON_CANCEL"));
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.cancelButton.addActionListener(actionDispatcher);
        return this.cancelButton;
    }

    private void getDataBoxImageParam() {
        this.params = this.parent.projectSetting.getProperty("DataBoxParam");
        this.paramTextField.setText(this.params);
    }

    private int setDataBoxImageParam(String string) {
        Setting setting = this.parent.getProjectSetting();
        setting.setProperty("DataBoxParam", this.params);
        return this.parent.saveProjectSetting(setting);
    }
}

