/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DecomailTempEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringDocument;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class DecomailTempEntryWindow
extends AbstractWindow {
    static final int MESSAGE_BYTE_NUM = 10000;
    static DecomailTempEntry entryData = null;
    private static final int TEXT_FIELD_WIDTH = 10;
    private static final int TEXT_AREA_WIDTH = 60;
    private static final String DECOMAIL_TEMPLATE = "Decomail-Template";
    private static final String DECOMAIL_MIME = "MIME-Version: ";
    private static final String DECOMAIL_CONTENT_TYPE = "Content-Type";
    private JTextArea messageArea;
    private JTextField titleField;
    private JScrollPane messageScroll;
    private MainWindow parent = null;

    DecomailTempEntryWindow(MainWindow mainWindow, DecomailTempEntry decomailTempEntry, String string) {
        super(mainWindow, string, true);
        this.parent = mainWindow;
        this.addWindowListener();
        entryData = decomailTempEntry;
        this.titleField = new JTextField(20);
        this.titleField.setDocument(new StringDocument(10));
        this.titleField.setText(decomailTempEntry.getTitle());
        JLabel jLabel = new JLabel(Resource.getString("MESSAGE"));
        JLabel jLabel2 = new JLabel(Resource.getString("TITLE") + " : ");
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        this.messageArea = new JTextArea(12, 60);
        this.messageArea.setFont(new Font("Monospaced", this.messageArea.getFont().getStyle(), 12));
        this.messageArea.setText(decomailTempEntry.getTemplate());
        this.messageScroll = new JScrollPane();
        this.messageScroll.getViewport().add(this.messageArea);
        this.messageScroll.setSize(12, 60);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 10, 10));
        jPanel.add(jLabel2);
        jPanel.add(this.titleField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", this.getFlowPanel(jLabel, 0));
        jPanel2.add("Center", this.messageScroll);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        jPanel4.add(jPanel3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("North", jPanel);
        container.add("Center", jPanel2);
        container.add("South", jPanel4);
        this.pack();
        this.messageArea.setCaretPosition(0);
        jButton2.setActionCommand("cancel");
        jButton.setActionCommand("save");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton2.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    void save() {
        String string;
        String string2 = this.titleField.getText();
        String string3 = this.messageArea.getText();
        if (string3 == null) {
            string3 = "";
        }
        if ((string = string3.toUpperCase()).indexOf(DECOMAIL_TEMPLATE.toUpperCase()) == -1 || string.indexOf(DECOMAIL_MIME.toUpperCase()) == -1 || string.indexOf(DECOMAIL_CONTENT_TYPE.toUpperCase()) == -1) {
            this.parent.showDialog(Resource.getString("DECOMAIL_TEMPLATE_ERROR"), this, 2);
            this.messageArea.requestFocus();
            return;
        }
        entryData.setTitle(string2);
        entryData.setTemplate(string3);
        try {
            char[] cArray = new char[8];
            String string4 = Integer.toHexString(entryData.getEntryID());
            Arrays.fill(cArray, '0');
            System.arraycopy(string4.toCharArray(), 0, cArray, 8 - string4.length(), string4.length());
            entryData.save("Decom" + new String(cArray) + ".dmt");
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.format("WRITE_ERR", Resource.getString("DECOMAIL_FILE")), this, 2);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    static boolean checkASCIICharacters(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] <= '~') continue;
            return false;
        }
        return true;
    }
}

