/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.DeviceDisplayInfo;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComboBoxUI;

class DeviceDisplayEditWindow
extends AbstractWindow {
    private int minMainDisplayWidth = 96;
    private int minMainDisplayHeight = 72;
    private int maxMainDisplayWidth = 1024;
    private int maxMainDisplayHeight = 1024;
    private int minSubDisplayWidth = 96;
    private int minSubDisplayHeight = 72;
    private int maxSubDisplayWidth = 240;
    private int maxSubDisplayHeight = 320;
    private MainWindow parent;
    private DeviceDisplayInfo editedEntry;
    private Vector entryList;
    private boolean edited;
    private JTextField dispNameField;
    private JTextField mainHeightField;
    private JTextField mainWidthField;
    private JTextField subHeightField;
    private JTextField subWidthField;
    private JComboBox keyboardComboBox = null;
    private JComboBox resolutionComboBox = null;
    private JTextField parallaxField;
    private JTextField parallaxChangeField;
    private JComboBox intensityLevelComboBox = null;
    static final String[] KEYBOARD_TYPE = new String[]{Resource.getString("DISPLAY_DEVICE_12_KEYBOARD"), Resource.getString("DISPLAY_DEVICE_FULL_KEYBOARD")};
    private static final String[] SELECT_RESOLUTION = new String[]{"1", "2"};
    private static final String[] SELECT_INTENSITY_LEVEL = new String[]{Resource.getString("StereoVision.common.caption.IntensityLevel3"), Resource.getString("StereoVision.common.caption.IntensityLevel2"), Resource.getString("StereoVision.common.caption.IntensityLevel1"), Resource.getString("StereoVision.common.caption.IntensityLevel0")};
    private static final String[] SELECT_INTENSITY_LEVEL_LIST = new String[]{"0", "1", "2"};
    public static final String FULL_KEYBOARD = "1";
    private boolean funcAdd = true;
    public static final int PARALLAX_MAX_INPUT = 5;

    DeviceDisplayEditWindow(MainWindow mainWindow, DeviceDisplayInfo deviceDisplayInfo, Vector vector) {
        super(mainWindow, Resource.getString("SET_DISPLAY_TITLE"), true);
        this.parent = mainWindow;
        this.editedEntry = deviceDisplayInfo;
        this.entryList = vector;
        this.edited = false;
        this.addWindowListener();
        this.loadLimitDisplaySize();
        JLabel jLabel = new JLabel(Resource.getString("DISPLAY_DEVICE_NAME"));
        JLabel jLabel2 = new JLabel(Resource.getString("DISPLAY_DEVICE_HIGHT"));
        JLabel jLabel3 = new JLabel(Resource.getString("DISPLAY_DEVICE_WIDTH"));
        JLabel jLabel4 = new JLabel(Resource.getString("DISPLAY_DEVICE_HIGHT"));
        JLabel jLabel5 = new JLabel(Resource.getString("DISPLAY_DEVICE_WIDTH"));
        JLabel jLabel6 = new JLabel(Resource.getString("StereoVision.common.caption.Resolution"));
        JLabel jLabel7 = new JLabel(Resource.getString("StereoVision.common.caption.Parallax"));
        JLabel jLabel8 = new JLabel("<html>" + Resource.getString("StereoVision.ktoolbar.caption.ParallaxChange"));
        JLabel jLabel9 = new JLabel(Resource.getString("StereoVision.common.caption.IntensityLevel"));
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        this.dispNameField = new JTextField(15);
        this.mainHeightField = new JTextField(10);
        this.mainHeightField.setDocument(new HalfNumberDocument(4));
        this.mainWidthField = new JTextField(10);
        this.mainWidthField.setDocument(new HalfNumberDocument(4));
        this.subHeightField = new JTextField(10);
        this.subHeightField.setDocument(new HalfNumberDocument(3));
        this.subWidthField = new JTextField(10);
        this.subWidthField.setDocument(new HalfNumberDocument(3));
        this.parallaxField = new JTextField(8);
        this.parallaxField.setDocument(new HalfNumberDocument(5));
        this.parallaxChangeField = new JTextField(8);
        this.parallaxChangeField.setDocument(new HalfNumberDocument(5));
        this.dispNameField.setText(this.editedEntry.getDeviceName());
        if (this.isEditPushed()) {
            this.dispNameField.setEnabled(false);
            this.parallaxField.setText(this.editedEntry.getParallax());
            this.parallaxChangeField.setText(this.editedEntry.getParallaxChange());
            this.funcAdd = false;
        } else {
            this.parallaxField.setText("0");
            this.parallaxChangeField.setText(FULL_KEYBOARD);
        }
        this.mainHeightField.setText(this.editedEntry.getMainHeight());
        this.mainWidthField.setText(this.editedEntry.getMainWidth());
        this.subHeightField.setText(this.editedEntry.getSubHeight());
        this.subWidthField.setText(this.editedEntry.getSubWidth());
        this.keyboardComboBox = new JComboBox<String>(KEYBOARD_TYPE);
        this.keyboardComboBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        if (FULL_KEYBOARD.equals(this.editedEntry.getKeyboardType())) {
            this.keyboardComboBox.setSelectedIndex(1);
        }
        this.resolutionComboBox = new JComboBox<String>(SELECT_RESOLUTION);
        this.resolutionComboBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        if (this.editedEntry.getResolution().equals(SELECT_RESOLUTION[0])) {
            this.resolutionComboBox.setSelectedIndex(0);
        } else {
            this.resolutionComboBox.setSelectedIndex(1);
        }
        this.intensityLevelComboBox = new JComboBox<String>(SELECT_INTENSITY_LEVEL);
        this.intensityLevelComboBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        if (this.editedEntry.getIntensityLevel().equals(SELECT_INTENSITY_LEVEL_LIST[0])) {
            this.intensityLevelComboBox.setSelectedIndex(3);
        } else if (this.editedEntry.getIntensityLevel().equals(SELECT_INTENSITY_LEVEL_LIST[1])) {
            this.intensityLevelComboBox.setSelectedIndex(2);
        } else if (this.editedEntry.getIntensityLevel().equals(SELECT_INTENSITY_LEVEL_LIST[2])) {
            this.intensityLevelComboBox.setSelectedIndex(1);
        } else {
            this.intensityLevelComboBox.setSelectedIndex(0);
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jLabel);
        jPanel.add(this.dispNameField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("DISPLAY_MAIN")));
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        jPanel3.add(jLabel3);
        jPanel3.add(this.mainWidthField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        jPanel4.add(jLabel2);
        jPanel4.add(this.mainHeightField);
        jPanel2.add("North", jPanel3);
        jPanel2.add("South", jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("DISPLAY_SUB")));
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1));
        jPanel6.add(jLabel5);
        jPanel6.add(this.subWidthField);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(1));
        jPanel7.add(jLabel4);
        jPanel7.add(this.subHeightField);
        jPanel5.add("North", jPanel6);
        jPanel5.add("South", jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("DISPLAY_DEVICE_KEYBOARD")));
        jPanel8.setLayout(new BorderLayout());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(1));
        jPanel9.add(this.keyboardComboBox);
        jPanel8.add("North", jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("StereoVision.common.caption.StereoVision")));
        jPanel10.setLayout(new BorderLayout());
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new FlowLayout(1));
        jPanel11.add(jLabel6);
        jPanel11.add(this.resolutionComboBox);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new FlowLayout(1));
        jPanel13.add(jLabel7);
        jPanel13.add(this.parallaxField);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new FlowLayout(1));
        jPanel14.add(jLabel8);
        jPanel14.add(this.parallaxChangeField);
        jPanel12.add("North", jPanel13);
        jPanel12.add("South", jPanel14);
        JPanel jPanel15 = new JPanel();
        jPanel14.setLayout(new FlowLayout(1));
        jPanel15.add(jLabel9);
        jPanel15.add(this.intensityLevelComboBox);
        jPanel10.add("North", jPanel11);
        jPanel10.add("Center", jPanel12);
        jPanel10.add("South", jPanel15);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new BorderLayout());
        jPanel16.add("North", jPanel8);
        jPanel16.add("South", jPanel10);
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BorderLayout());
        jPanel17.add("North", jPanel2);
        jPanel17.add("Center", jPanel5);
        jPanel17.add("South", jPanel16);
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new FlowLayout(1));
        jPanel18.add(jButton);
        jPanel18.add(jButton2);
        container.add("North", jPanel);
        container.add("Center", jPanel17);
        container.add("South", jPanel18);
        jButton2.setActionCommand("cancel");
        jButton.setActionCommand("save");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton2.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.pack();
    }

    void save() {
        Object[] objectArray = new String[3];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.keyboardComboBox.getSelectedIndex();
        String string = this.dispNameField.getText().trim();
        this.dispNameField.setText(string);
        try {
            n = Integer.parseInt(this.mainWidthField.getText());
            n2 = Integer.parseInt(this.mainHeightField.getText());
            n3 = Integer.parseInt(this.subWidthField.getText());
            n4 = Integer.parseInt(this.subHeightField.getText());
            Integer.parseInt(this.parallaxField.getText());
            Integer.parseInt(this.parallaxChangeField.getText());
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("DISPLAY_NOINPUT_WNG"), this, 2);
            return;
        }
        if (string.length() == 0) {
            this.parent.showDialog(Resource.format("SPECIFIED_VAL_WNG", Resource.getString("DISPLAY_DEVICE_NAME")), this, 2);
            return;
        }
        if (this.funcAdd) {
            for (int i = 0; i < this.entryList.size(); ++i) {
                DeviceDisplayInfo deviceDisplayInfo = (DeviceDisplayInfo)this.entryList.get(i);
                if (!string.equals(deviceDisplayInfo.getDeviceName())) continue;
                this.parent.showDialog(Resource.getString("DISPLAY_NAME_WNG"), this, 2);
                return;
            }
        }
        objectArray[0] = Resource.getString("DISPLAY_CLM_MAIN_W");
        objectArray[1] = String.valueOf(this.minMainDisplayWidth);
        objectArray[2] = String.valueOf(this.maxMainDisplayWidth);
        if (n < this.minMainDisplayWidth || n > this.maxMainDisplayWidth) {
            this.parent.showDialog(Resource.format("DISPLAY_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        objectArray[0] = Resource.getString("DISPLAY_CLM_MAIN_H");
        objectArray[1] = String.valueOf(this.minMainDisplayHeight);
        objectArray[2] = String.valueOf(this.maxMainDisplayHeight);
        if (n2 < this.minMainDisplayHeight || n2 > this.maxMainDisplayHeight) {
            this.parent.showDialog(Resource.format("DISPLAY_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        objectArray[0] = Resource.getString("DISPLAY_CLM_SUB_W");
        objectArray[1] = String.valueOf(this.minSubDisplayWidth);
        objectArray[2] = String.valueOf(this.maxSubDisplayWidth);
        if (n3 < this.minSubDisplayWidth || n3 > this.maxSubDisplayWidth) {
            this.parent.showDialog(Resource.format("DISPLAY_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        objectArray[0] = Resource.getString("DISPLAY_CLM_SUB_H");
        objectArray[1] = String.valueOf(this.minSubDisplayHeight);
        objectArray[2] = String.valueOf(this.maxSubDisplayHeight);
        if (n4 < this.minSubDisplayHeight || n4 > this.maxSubDisplayHeight) {
            this.parent.showDialog(Resource.format("DISPLAY_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        this.editedEntry.setDeviceName(this.dispNameField.getText());
        this.editedEntry.setMainWidth(this.mainWidthField.getText());
        this.editedEntry.setMainHeight(this.mainHeightField.getText());
        this.editedEntry.setSubWidth(this.subWidthField.getText());
        this.editedEntry.setSubHeight(this.subHeightField.getText());
        this.editedEntry.setKeyboardType(Integer.toString(n5));
        this.editedEntry.setResolution(this.resolutionComboBox.getSelectedItem().toString());
        this.editedEntry.setParallax(this.parallaxField.getText());
        this.editedEntry.setParallaxChange(this.parallaxChangeField.getText());
        if (this.intensityLevelComboBox.getSelectedItem().toString().equals(Resource.getString("StereoVision.common.caption.IntensityLevel0"))) {
            this.editedEntry.setIntensityLevel(SELECT_INTENSITY_LEVEL_LIST[0]);
        } else if (this.intensityLevelComboBox.getSelectedItem().toString().equals(Resource.getString("StereoVision.common.caption.IntensityLevel1"))) {
            this.editedEntry.setIntensityLevel(SELECT_INTENSITY_LEVEL_LIST[1]);
        } else if (this.intensityLevelComboBox.getSelectedItem().toString().equals(Resource.getString("StereoVision.common.caption.IntensityLevel2"))) {
            this.editedEntry.setIntensityLevel(SELECT_INTENSITY_LEVEL_LIST[2]);
        } else {
            this.editedEntry.setIntensityLevel("3");
        }
        this.edited = true;
        this.setVisible(false);
    }

    boolean isEdited() {
        return this.edited;
    }

    void cancel() {
        this.setVisible(false);
    }

    private void loadLimitDisplaySize() {
        int[] nArray = null;
        nArray = JAMManager.getLimitDisplaySize(0, 0);
        this.minMainDisplayWidth = nArray[0];
        this.maxMainDisplayWidth = nArray[1];
        nArray = JAMManager.getLimitDisplaySize(0, 1);
        this.minMainDisplayHeight = nArray[0];
        this.maxMainDisplayHeight = nArray[1];
        nArray = JAMManager.getLimitDisplaySize(1, 0);
        this.minSubDisplayWidth = nArray[0];
        this.maxSubDisplayWidth = nArray[1];
        nArray = JAMManager.getLimitDisplaySize(1, 1);
        this.minSubDisplayHeight = nArray[0];
        this.maxSubDisplayHeight = nArray[1];
    }

    private boolean isEditPushed() {
        return this.editedEntry.getDeviceName().length() > 0;
    }
}

