/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindowDoButtonControl;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExternalDeviceParamWindow
extends AbstractWindow {
    private JPanel jContentPane = null;
    private JPanel parameterPanel = null;
    private JPanel buttonPanel = null;
    private JLabel paramLabel = null;
    private JTextField paramTextField = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private MainWindow parent;
    private String params;

    ExternalDeviceParamWindow(MainWindow mainWindow, String string) {
        super(mainWindow, Resource.getString("EXTERNAL_PARAM_WINDOW_TITLE"));
        this.parent = mainWindow;
        if (string != null) {
            string = string.trim();
        }
        this.params = string;
        this.initialize();
        this.okButton.setActionCommand("invoke");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.okButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setResizable(true);
        this.pack();
    }

    private boolean doValidate(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i % 2 == 0 && stringArray[i].equals("")) {
                return false;
            }
            ++n;
        }
        return n <= 32;
    }

    public static String[] tokenToArgs(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(string2);
        int n3 = 0;
        while (n2 >= 0) {
            vector.addElement(string.substring(n, n2));
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
            ++n3;
        }
        vector.addElement(string.substring(n));
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return (String[])objectArray;
    }

    public static Hashtable parse(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = "";
            try {
                string2 = stringArray[i + 1];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    void invoke() {
        this.params = this.paramTextField.getText();
        this.params = this.params == null ? "" : this.params.trim();
        String[] stringArray = new String[]{};
        if (!this.params.equals("")) {
            stringArray = ExternalDeviceParamWindow.tokenToArgs(this.params, " ");
        }
        if (!this.doValidate(stringArray)) {
            System.err.println(Resource.getString("EXTERNAL_PARAM_ERROR_MSG"));
        } else {
            Hashtable hashtable = ExternalDeviceParamWindow.parse(stringArray);
            Setting setting = this.parent.getProjectSetting();
            setting.setProperty("ExternalDeviceParam", this.params);
            this.parent.saveProjectSetting(setting);
            try {
                JAMManager.invokeApplication(this.parent.getAppType(), this.parent.getAdfPath(), this.parent.getJarPath(), 4, JAMManager.getParams(hashtable), this.parent.getDeviceName(), this.parent.getAdfUrl(), this.parent.getProjectNameForBytes(), DebugTraceWindow.getDebugParam());
                this.parent.setEnabledDeviceMenu(false);
            }
            catch (Exception exception) {
                this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
            }
            MainWindowDoButtonControl.start(this.parent);
        }
        this.parent.closeWindow(this);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private void initialize() {
        this.setSize(400, 130);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getParameterPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getParameterPanel() {
        if (this.parameterPanel == null) {
            this.paramLabel = new JLabel();
            this.paramLabel.setText(Resource.getString("EXTERNAL_PARAM_LABEL"));
            this.parameterPanel = new JPanel();
            this.parameterPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("EXTERNAL_PARAM_BORDER_TITLE"), 0, 0, null, null));
            this.parameterPanel.add((Component)this.paramLabel, null);
            this.parameterPanel.add((Component)this.getParamTextField(), null);
        }
        return this.parameterPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JTextField getParamTextField() {
        if (this.paramTextField == null) {
            this.paramTextField = new JTextField(this.params);
            this.paramTextField.setColumns(25);
        }
        return this.paramTextField;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(Resource.getString("EXTERNAL_PARAM_BUTTON_INVOKE"));
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(Resource.getString("EXTERNAL_PARAM_BUTTON_CANCEL"));
        }
        return this.cancelButton;
    }
}

