/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class GyroSensorDataEntry {
    public static final String SECTION_KEY_RANGE = "GYRODATARANGE";
    public static final String SECTION_KEY_PROPERTY = "GYRODATAPROPERTY";
    public static final String SECTION_KEY_DATA = "GYRODATA_";
    public static final String S_KEY_MIN_DATA_VAL_X = "MINVALUE_X";
    public static final String S_KEY_MAX_DATA_VAL_X = "MAXVALUE_X";
    public static final String S_KEY_MIN_DATA_VAL_Y = "MINVALUE_Y";
    public static final String S_KEY_MAX_DATA_VAL_Y = "MAXVALUE_Y";
    public static final String S_KEY_MIN_DATA_VAL_Z = "MINVALUE_Z";
    public static final String S_KEY_MAX_DATA_VAL_Z = "MAXVALUE_Z";
    public static final String S_KEY_DATA_COUNT = "COUNT";
    public static final String S_KEY_DATA_VAL_X = "VALUE_X";
    public static final String S_KEY_DATA_VAL_Y = "VALUE_Y";
    public static final String S_KEY_DATA_VAL_Z = "VALUE_Z";
    public static final String GYRO_SENSOR_DAT = "gyrosensor.dat";
    private static final String GYRO_SENSOR_PATH = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "gyrosensor.dat";
    private static final int GYRO_DATA_COUNT = 0;
    private static final String GYRO_DEFAULT_MIN_VALUE = "-180";
    private static final String GYRO_DEFAULT_MAX_VALUE = "180";
    private String[] values_X = new String[]{"-180", "180"};
    private String[] values_Y = new String[]{"-180", "180"};
    private String[] values_Z = new String[]{"-180", "180"};
    private int count = 0;
    private ArrayList data = null;

    public String[] getAngleValuesX() {
        return this.values_X;
    }

    public String[] getAngleValuesY() {
        return this.values_Y;
    }

    public String[] getAngleValuesZ() {
        return this.values_Z;
    }

    public void setAngleValuesX(String[] stringArray) {
        this.values_X = stringArray;
    }

    public void setAngleValuesY(String[] stringArray) {
        this.values_Y = stringArray;
    }

    public void setAngleValuesZ(String[] stringArray) {
        this.values_Z = stringArray;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public ArrayList getData() {
        return this.data;
    }

    public void setData(ArrayList arrayList) {
        this.data = arrayList;
    }

    public void load() throws IOException {
        IniFileEntity iniFileEntity = new IniFileEntity(GYRO_SENSOR_PATH);
        iniFileEntity.read();
        String string = "";
        boolean bl = false;
        string = iniFileEntity.getSectionAttribute(SECTION_KEY_RANGE, S_KEY_MIN_DATA_VAL_X);
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            this.values_X[0] = string;
        }
        String string2 = "";
        bl = false;
        string2 = iniFileEntity.getSectionAttribute(SECTION_KEY_RANGE, S_KEY_MAX_DATA_VAL_X);
        try {
            Integer.parseInt(string2);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            this.values_X[1] = string2;
        }
        string = "";
        bl = false;
        string = iniFileEntity.getSectionAttribute(SECTION_KEY_RANGE, S_KEY_MIN_DATA_VAL_Y);
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            this.values_Y[0] = string;
        }
        string2 = "";
        bl = false;
        string2 = iniFileEntity.getSectionAttribute(SECTION_KEY_RANGE, S_KEY_MAX_DATA_VAL_Y);
        try {
            Integer.parseInt(string2);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            this.values_Y[1] = string2;
        }
        string = "";
        bl = false;
        string = iniFileEntity.getSectionAttribute(SECTION_KEY_RANGE, S_KEY_MIN_DATA_VAL_Z);
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            this.values_Z[0] = string;
        }
        string2 = "";
        bl = false;
        string2 = iniFileEntity.getSectionAttribute(SECTION_KEY_RANGE, S_KEY_MAX_DATA_VAL_Z);
        try {
            Integer.parseInt(string2);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            this.values_Z[1] = string2;
        }
        this.count = iniFileEntity.getSectionAttributeInt(SECTION_KEY_PROPERTY, S_KEY_DATA_COUNT, 0);
        if (this.count <= 0) {
            return;
        }
        this.data = new ArrayList();
        Hashtable<String, String> hashtable = null;
        String string3 = "";
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            hashtable = new Hashtable<String, String>();
            try {
                string3 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_VAL_X);
                n = Integer.parseInt(string3);
                hashtable.put(S_KEY_DATA_VAL_X, String.valueOf(n));
                string3 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_VAL_Y);
                n = Integer.parseInt(string3);
                hashtable.put(S_KEY_DATA_VAL_Y, String.valueOf(n));
                string3 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_VAL_Z);
                n = Integer.parseInt(string3);
                hashtable.put(S_KEY_DATA_VAL_Z, String.valueOf(n));
                this.data.add(hashtable);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() throws IOException {
        IniFileEntity iniFileEntity = new IniFileEntity(GYRO_SENSOR_PATH);
        if (this.count > 0) {
            this.count = this.data.size();
        }
        for (int i = 0; i < this.count; ++i) {
            Hashtable hashtable = (Hashtable)this.data.get(i);
            String string = (String)hashtable.get(S_KEY_DATA_VAL_X);
            String string2 = (String)hashtable.get(S_KEY_DATA_VAL_Y);
            String string3 = (String)hashtable.get(S_KEY_DATA_VAL_Z);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_VAL_X, string);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_VAL_Y, string2);
            iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_VAL_Z, string3);
        }
        iniFileEntity.setSectionAttribute(SECTION_KEY_PROPERTY, S_KEY_DATA_COUNT, Integer.toString(this.count));
        iniFileEntity.setSectionAttribute(SECTION_KEY_RANGE, S_KEY_MIN_DATA_VAL_X, this.values_X[0]);
        iniFileEntity.setSectionAttribute(SECTION_KEY_RANGE, S_KEY_MAX_DATA_VAL_X, this.values_X[1]);
        iniFileEntity.setSectionAttribute(SECTION_KEY_RANGE, S_KEY_MIN_DATA_VAL_Y, this.values_Y[0]);
        iniFileEntity.setSectionAttribute(SECTION_KEY_RANGE, S_KEY_MAX_DATA_VAL_Y, this.values_Y[1]);
        iniFileEntity.setSectionAttribute(SECTION_KEY_RANGE, S_KEY_MIN_DATA_VAL_Z, this.values_Z[0]);
        iniFileEntity.setSectionAttribute(SECTION_KEY_RANGE, S_KEY_MAX_DATA_VAL_Z, this.values_Z[1]);
        iniFileEntity.save();
    }

    public void delete(int n) throws IOException {
        this.data.remove(n);
        int n2 = this.getCount();
        this.setCount(--n2);
        this.save();
    }
}

