/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.GyroSensorAngleWindow;
import com.nttdocomo.dojaemu.ktoolbar.GyroSensorDataEntry;
import com.nttdocomo.dojaemu.ktoolbar.GyroSensorDataWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class GyroSensorWindow
extends TabPanel {
    private JTable gyroSensorTable;
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton setButton;
    private JLabel lblAngleXMinData;
    private JLabel lblAngleXMaxData;
    private JLabel lblAngleYMinData;
    private JLabel lblAngleYMaxData;
    private JLabel lblAngleZMinData;
    private JLabel lblAngleZMaxData;
    private GyroSensorDataEntry gde = null;

    GyroSensorWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("GYRO_LBL_ANGLE_RATE_X"));
        JLabel jLabel2 = new JLabel(Resource.getString("GYRO_LBL_DATA_MIN"));
        JLabel jLabel3 = new JLabel(Resource.getString("GYRO_LBL_DATA_MAX"));
        JLabel jLabel4 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_RATE_Y"));
        JLabel jLabel5 = new JLabel(Resource.getString("GYRO_LBL_DATA_MIN"));
        JLabel jLabel6 = new JLabel(Resource.getString("GYRO_LBL_DATA_MAX"));
        JLabel jLabel7 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_RATE_Z"));
        JLabel jLabel8 = new JLabel(Resource.getString("GYRO_LBL_DATA_MIN"));
        JLabel jLabel9 = new JLabel(Resource.getString("GYRO_LBL_DATA_MAX"));
        this.lblAngleXMinData = new JLabel("0");
        this.lblAngleXMinData.setPreferredSize(new Dimension(70, this.lblAngleXMinData.getPreferredSize().height));
        this.lblAngleXMaxData = new JLabel("0");
        this.lblAngleXMaxData.setPreferredSize(new Dimension(70, this.lblAngleXMaxData.getPreferredSize().height));
        this.lblAngleYMinData = new JLabel("0");
        this.lblAngleYMinData.setPreferredSize(new Dimension(70, this.lblAngleYMinData.getPreferredSize().height));
        this.lblAngleYMaxData = new JLabel("0");
        this.lblAngleYMaxData.setPreferredSize(new Dimension(70, this.lblAngleYMaxData.getPreferredSize().height));
        this.lblAngleZMinData = new JLabel("0");
        this.lblAngleZMinData.setPreferredSize(new Dimension(70, this.lblAngleZMinData.getPreferredSize().height));
        this.lblAngleZMaxData = new JLabel("0");
        this.lblAngleZMaxData.setPreferredSize(new Dimension(70, this.lblAngleZMaxData.getPreferredSize().height));
        this.gde = new GyroSensorDataEntry();
        try {
            this.gde.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] stringArray = this.gde.getAngleValuesX();
        String[] stringArray2 = this.gde.getAngleValuesY();
        String[] stringArray3 = this.gde.getAngleValuesZ();
        this.lblAngleXMinData.setText(stringArray[0]);
        this.lblAngleXMaxData.setText(stringArray[1]);
        this.lblAngleYMinData.setText(stringArray2[0]);
        this.lblAngleYMaxData.setText(stringArray2[1]);
        this.lblAngleZMinData.setText(stringArray3[0]);
        this.lblAngleZMaxData.setText(stringArray3[1]);
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.setButton = new JButton(Resource.getString("SET_UP"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        this.setButton.setActionCommand("setting");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.setButton.addActionListener(actionDispatcher);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("GYRO_ANGLE_RATE_TITLE")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        jPanel3.add(this.setButton);
        jPanel4.add(jLabel);
        jPanel4.add(jLabel2);
        jPanel4.add(this.lblAngleXMinData);
        jPanel4.add(jLabel3);
        jPanel4.add(this.lblAngleXMaxData);
        jPanel5.add(jLabel4);
        jPanel5.add(jLabel5);
        jPanel5.add(this.lblAngleYMinData);
        jPanel5.add(jLabel6);
        jPanel5.add(this.lblAngleYMaxData);
        jPanel6.add(jLabel7);
        jPanel6.add(jLabel8);
        jPanel6.add(this.lblAngleZMinData);
        jPanel6.add(jLabel9);
        jPanel6.add(this.lblAngleZMaxData);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        jPanel2.add(this.addButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        this.gyroSensorTable = this.createGyroSensorTable();
        this.scrollpane = new JScrollPane(this.gyroSensorTable);
        this.changeButtonEnabled();
        this.add("North", jPanel);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    private JTable createGyroSensorTable() {
        JTable jTable = null;
        GyroTableModel gyroTableModel = null;
        String[] stringArray = new String[]{Resource.getString("GYRO_LBL_COLUM_X"), Resource.getString("GYRO_LBL_COLUM_Y"), Resource.getString("GYRO_LBL_COLUM_Z")};
        gyroTableModel = new GyroTableModel(stringArray, 0);
        int n = this.gde.getCount();
        if (n > 0) {
            ArrayList arrayList = this.gde.getData();
            for (int i = 0; i < arrayList.size(); ++i) {
                Vector vector = new Vector();
                Hashtable hashtable = (Hashtable)arrayList.get(i);
                vector.addElement(hashtable.get("VALUE_X"));
                vector.addElement(hashtable.get("VALUE_Y"));
                vector.addElement(hashtable.get("VALUE_Z"));
                gyroTableModel.addRow(vector);
            }
        }
        jTable = new JTable(gyroTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new GyroTableCellRenderer());
        jTable.setSelectionMode(0);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    GyroSensorWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    GyroSensorWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    public void add() {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        GyroSensorDataWindow gyroSensorDataWindow = new GyroSensorDataWindow(this.parent, this.gde, -1);
        gyroSensorDataWindow.setLocation(this.parent.getShowLocation(gyroSensorDataWindow.getWidth(), gyroSensorDataWindow.getHeight(), this.tabwin));
        gyroSensorDataWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.gyroSensorTable = null;
        this.gyroSensorTable = this.createGyroSensorTable();
        this.scrollpane = new JScrollPane(this.gyroSensorTable);
        this.add("Center", this.scrollpane);
        this.changeButtonEnabled();
        this.setVisible(true);
    }

    public void edit() {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        if (this.gyroSensorTable.getSelectedRowCount() == 1) {
            int n = this.gyroSensorTable.getSelectedRow();
            GyroSensorDataWindow gyroSensorDataWindow = new GyroSensorDataWindow(this.parent, this.gde, n);
            gyroSensorDataWindow.setLocation(this.parent.getShowLocation(gyroSensorDataWindow.getWidth(), gyroSensorDataWindow.getHeight(), this.tabwin));
            gyroSensorDataWindow.setVisible(true);
            this.gde = new GyroSensorDataEntry();
            try {
                this.gde.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.gyroSensorTable = null;
            this.gyroSensorTable = this.createGyroSensorTable();
            this.scrollpane = new JScrollPane(this.gyroSensorTable);
            this.add("Center", this.scrollpane);
            this.changeButtonEnabled();
            this.setVisible(true);
        }
    }

    public void delete() {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        if (this.gyroSensorTable.getSelectedRowCount() == 1) {
            int n = this.gyroSensorTable.getSelectedRow();
            int n2 = JOptionPane.showConfirmDialog(this, Resource.getString("GYRODATA_DELETE_WNG"), Resource.getString("CONFIRM"), 0);
            if (n2 == 0) {
                try {
                    this.gde.delete(n);
                }
                catch (IOException iOException) {
                    this.parent.showDialog(Resource.format("WRITE_ERR", "gyrosensor.dat"), this, 2);
                }
                this.gde = new GyroSensorDataEntry();
                try {
                    this.gde.load();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.gyroSensorTable = null;
                this.gyroSensorTable = this.createGyroSensorTable();
                this.scrollpane = new JScrollPane(this.gyroSensorTable);
                this.add("Center", this.scrollpane);
                this.changeButtonEnabled();
                this.setVisible(true);
            }
        }
    }

    public void setting() {
        GyroSensorAngleWindow gyroSensorAngleWindow = new GyroSensorAngleWindow(this.parent, this.gde);
        gyroSensorAngleWindow.setLocation(this.parent.getShowLocation(gyroSensorAngleWindow.getWidth(), gyroSensorAngleWindow.getHeight(), this.tabwin));
        gyroSensorAngleWindow.setVisible(true);
        this.setVisible(false);
        this.gde = new GyroSensorDataEntry();
        try {
            this.gde.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] stringArray = this.gde.getAngleValuesX();
        String[] stringArray2 = this.gde.getAngleValuesY();
        String[] stringArray3 = this.gde.getAngleValuesZ();
        this.lblAngleXMinData.setText(stringArray[0]);
        this.lblAngleXMaxData.setText(stringArray[1]);
        this.lblAngleYMinData.setText(stringArray2[0]);
        this.lblAngleYMaxData.setText(stringArray2[1]);
        this.lblAngleZMinData.setText(stringArray3[0]);
        this.lblAngleZMaxData.setText(stringArray3[1]);
        this.setVisible(true);
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.gyroSensorTable.getRowCount() == 0) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    public void addRow(final JTable jTable, final Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jTable != null && GyroSensorWindow.this.gyroSensorTable != null && jTable.equals(GyroSensorWindow.this.gyroSensorTable)) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                    defaultTableModel.addRow(objectArray);
                }
            }
        });
    }

    class GyroTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        GyroTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class GyroTableModel
    extends DefaultTableModel {
        GyroTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

