/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.JavaClass;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Method;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class IAppliChecker {
    private Setting setting = null;
    private boolean enable = false;
    private Vector classList = null;
    private HashMap traceMethods = null;
    private int traceLevel = 0;
    private boolean enableHttpProc = false;
    private Vector httpProc = new Vector();
    private boolean enableCallHttpProc = false;
    private Vector callHttpProc = new Vector();
    private boolean enableNoEndLoop = false;
    private Vector noEndLoop = new Vector();

    public IAppliChecker() {
        String string = this.getSettingPath();
        File file = new File(string);
        try {
            this.setting = new Setting(file);
            if ("1".equals(this.setting.getProperty("httpProc"))) {
                this.enableHttpProc = true;
            }
            if ("1".equals(this.setting.getProperty("callHttpProc"))) {
                this.enableCallHttpProc = true;
            }
            if ("1".equals(this.setting.getProperty("noEndLoop"))) {
                this.enableNoEndLoop = true;
            }
            this.enable = this.enableHttpProc || this.enableCallHttpProc || this.enableNoEndLoop;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(Resource.format("NOT_FOUND_ERR", file));
            this.setting = new Setting();
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", file));
            this.setting = new Setting();
        }
    }

    private String getSettingPath() {
        String string = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "iAppliChecker.properties";
        return string;
    }

    public void iAppliChecker(String string) throws Exception {
        JavaClass javaClass = null;
        if (this.enable) {
            System.out.println(Resource.getString("START_IAPPLI_CHECKER"));
            this.createJavaClass(string);
            for (int i = 0; i < this.classList.size(); ++i) {
                javaClass = (JavaClass)this.classList.get(i);
                this.analysis(javaClass);
            }
            this.outputErrorInfo();
        }
    }

    private void analysis(JavaClass javaClass) {
        if (javaClass.isInterface() || javaClass.isSynthetic()) {
            return;
        }
        Method[] methodArray = javaClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (this.enableHttpProc) {
                this.checkHttpConnection(javaClass, methodArray[i], false);
            }
            if (this.enableCallHttpProc) {
                this.checkCallHttpProc(javaClass, methodArray[i]);
            }
            if (!this.enableNoEndLoop) continue;
            this.checkNoEndLoop(javaClass, methodArray[i]);
        }
    }

    private boolean checkHttpConnection(JavaClass javaClass, Method method, boolean bl) {
        Vector vector = null;
        Iterator iterator = null;
        Vector vector22 = null;
        String string = null;
        String string2 = null;
        string = javaClass.getClassName();
        string2 = method.getMethodSignature();
        if (method.isAbstract() || method.isNative() || method.isSynthetic()) {
            return true;
        }
        vector = method.getCodes().getDetailArray();
        for (Vector vector22 : vector) {
            if (!this.isHttpConnection(vector22)) continue;
            if (!bl) {
                this.httpProc.add(this.createMessage(string, string2));
            }
            return false;
        }
        return true;
    }

    private boolean isHttpConnection(Vector vector) {
        return vector.get(1).toString().startsWith("invoke") && "com/nttdocomo/io/HttpConnection".equals(vector.get(2)) && "connect".equals(vector.get(3));
    }

    private void checkNoEndLoop(JavaClass javaClass, Method method) {
        Vector vector = null;
        int[] nArray = null;
        String string = null;
        String string2 = null;
        string = javaClass.getClassName();
        string2 = method.getMethodSignature();
        if (method.isAbstract() || method.isNative() || method.isSynthetic()) {
            return;
        }
        vector = method.getCodes().getDetailArray();
        for (int i = vector.size() - 1; 0 <= i; --i) {
            nArray = this.findLoop(vector, i);
            if (0 <= nArray[0] && !this.findLoopEndConditions(vector, nArray)) {
                this.noEndLoop.add(this.createMessage(string, string2));
                return;
            }
            i = nArray[2];
        }
    }

    private int[] findLoop(Vector vector, int n) {
        int n2;
        int[] nArray = new int[]{-1, -1, -1, -1};
        int n3 = 0;
        int n4 = 0;
        Vector vector2 = null;
        for (n2 = n; 0 <= n2; --n2) {
            vector2 = (Vector)vector.get(n2);
            if (!vector2.get(1).toString().startsWith("if") && !vector2.get(1).toString().startsWith("goto") || (n3 = Integer.parseInt(vector2.get(0).toString())) < (n4 = Integer.parseInt(vector2.get(2).toString()))) continue;
            nArray[0] = n4;
            nArray[1] = n3;
            nArray[3] = n2;
            break;
        }
        if (0 <= nArray[0]) {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                vector2 = (Vector)vector.get(n2);
                n3 = Integer.parseInt(vector2.get(0).toString());
                if (n3 != nArray[0]) continue;
                nArray[2] = n2;
                break;
            }
        }
        return nArray;
    }

    private boolean findLoopEndConditions(Vector vector, int[] nArray) {
        Vector vector2 = null;
        int n = 0;
        String string = null;
        vector2 = (Vector)vector.get(nArray[3]);
        string = vector2.get(1).toString();
        if (string.startsWith("if")) {
            return true;
        }
        for (int i = nArray[2]; i < nArray[3]; ++i) {
            vector2 = (Vector)vector.get(i);
            string = vector2.get(1).toString();
            if (!(string.startsWith("if") || string.startsWith("goto") ? nArray[1] < (n = Integer.parseInt(vector2.get(2).toString())) : string.endsWith("return"))) continue;
            return true;
        }
        return false;
    }

    private void checkCallHttpProc(JavaClass javaClass, Method method) {
        Vector vector = null;
        int[] nArray = null;
        String string = null;
        String string2 = null;
        string = javaClass.getClassName();
        string2 = method.getMethodSignature();
        if (method.isAbstract() || method.isNative() || method.isSynthetic()) {
            return;
        }
        this.traceLevel = 0;
        this.traceMethods = new HashMap();
        this.traceMethods.put(method.getMethodName(true) + method.getDescriptor(true), new Integer(this.traceLevel));
        vector = method.getCodes().getDetailArray();
        for (int i = vector.size() - 1; 0 <= i; --i) {
            nArray = this.findLoop(vector, i);
            if (0 <= nArray[0] && !this.findCallHttpProc(vector, nArray)) {
                this.callHttpProc.add(this.createMessage(string, string2));
                return;
            }
            i = nArray[2];
        }
    }

    private boolean findCallHttpProc(Vector vector, int[] nArray) {
        Vector vector2 = null;
        int n = Math.min(vector.size(), nArray[3]);
        for (int i = nArray[2]; i < n; ++i) {
            vector2 = (Vector)vector.get(i);
            if (this.isHttpConnection(vector2)) {
                return false;
            }
            if (!vector2.get(1).toString().startsWith("invoke") || this.checkMethodTrace(vector2)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMethodTrace(Vector vector) {
        int[] nArray = new int[]{0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE};
        String string = vector.get(2).toString();
        String string2 = vector.get(3).toString();
        String string3 = vector.get(4).toString();
        JavaClass javaClass = this.findClass(string);
        if (null == javaClass) {
            return true;
        }
        Method method = this.findMethod(javaClass, string2 + string3);
        if (null == method) {
            return true;
        }
        if (method.isAbstract() || method.isNative() || method.isSynthetic()) {
            return true;
        }
        Integer n = (Integer)this.traceMethods.get(string2 + string3);
        if (null != n && n < this.traceLevel + 1) {
            return true;
        }
        ++this.traceLevel;
        this.traceMethods.put(string2 + string3, new Integer(this.traceLevel));
        if (!this.checkHttpConnection(javaClass, method, true)) {
            --this.traceLevel;
            return false;
        }
        if (!this.findCallHttpProc(method.getCodes().getDetailArray(), nArray)) {
            --this.traceLevel;
            return false;
        }
        --this.traceLevel;
        return true;
    }

    private JavaClass findClass(String string) {
        String string2 = null;
        for (int i = 0; i < this.classList.size(); ++i) {
            string2 = ((JavaClass)this.classList.get(i)).getClassName();
            if (!string2.equals(string)) continue;
            return (JavaClass)this.classList.get(i);
        }
        return null;
    }

    private Method findMethod(JavaClass javaClass, String string) {
        String string2 = null;
        String string3 = null;
        Method[] methodArray = javaClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            string2 = methodArray[i].getMethodName(true);
            string3 = methodArray[i].getDescriptor(true);
            if (!(string2 + string3).equals(string)) continue;
            return methodArray[i];
        }
        return null;
    }

    private String createMessage(String string, String string2) {
        Object[] objectArray = new String[]{string, string2};
        return Resource.format("ERROR_METHOD", objectArray);
    }

    private void outputErrorInfo() {
        int n;
        if (0 < this.httpProc.size()) {
            System.out.println(Resource.getString("HTTP_PROC_FOUND"));
            for (n = 0; n < this.httpProc.size(); ++n) {
                System.out.println(this.httpProc.get(n).toString());
            }
        }
        if (0 < this.callHttpProc.size()) {
            System.out.println(Resource.getString("CALL_HTTP_PROC_FOUND"));
            for (n = 0; n < this.callHttpProc.size(); ++n) {
                System.out.println(this.callHttpProc.get(n).toString());
            }
        }
        if (0 < this.noEndLoop.size()) {
            System.out.println(Resource.getString("NO_END_LOOP_FOUND"));
            for (n = 0; n < this.noEndLoop.size(); ++n) {
                System.out.println(this.noEndLoop.get(n).toString());
            }
        }
        System.out.println(Resource.getString("FINISH_IAPPLI_CHECKER"));
    }

    private void createJavaClass(String string) throws Exception {
        this.classList = new Vector();
        JarFile jarFile = null;
        JarEntry jarEntry = null;
        byte[] byArray = null;
        InputStream inputStream = null;
        Enumeration<JarEntry> enumeration = null;
        long l = 0L;
        int n = 0;
        try {
            jarFile = new JarFile(new File(string));
            enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                l = jarEntry.getSize();
                byArray = new byte[(int)l];
                inputStream = jarFile.getInputStream(jarEntry);
                n = 0;
                while ((long)(n += inputStream.read(byArray, n, (int)l - n)) < l) {
                }
                inputStream.close();
                this.classList.add(new JavaClass(byArray));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (null != jarFile) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

