/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AppIconCheck;
import com.nttdocomo.dojaemu.ktoolbar.AttrWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.ProjectFilesPath;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

class IconViewWindow
extends AbstractWindow {
    private AttrWindow adfWindow = null;
    private static final int ICON_VIEW = 96;
    private static final int IMAGE_VIEW = 160;
    private ProjectFilesPath pfl;
    private static final String ICON_DIR = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "images" + File.separator;
    private static final String ICON_NAME_NORMAL = "normal.gif";
    private static final String ICON_NAME_NORMAL2 = "normal2.gif";
    private static final String ICON_NAME_NORMAL_IC1 = "normal_ic1.gif";
    private static final String ICON_NAME_NORMAL_IC2 = "normal_ic2.gif";
    private static final String ICON_NOT_IN_JAR = "notinjar.gif";
    private ImageIcon iconNormal;
    private ImageIcon iconNormal2;
    private ImageIcon iconNormal_ic1;
    private ImageIcon iconNormal_ic2;
    private ImageIcon iconNotInJar;
    private static final int[] REGULATION_SIZE = new int[]{24, 48, 96, 160, 320};

    IconViewWindow(MainWindow mainWindow, AttrWindow attrWindow) {
        super(mainWindow, Resource.getString("IMAGE_VIEW"));
        Container container;
        JPanel jPanel;
        JComponent jComponent;
        this.adfWindow = attrWindow;
        this.addWindowListener();
        int n = JAMManager.getFeliCaEmuDiv();
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.pfl = new ProjectFilesPath(mainWindow.getProjectHome());
        this.iconNormal = this.getDefaultIcon(ICON_NAME_NORMAL, 96);
        this.iconNormal2 = this.getDefaultIcon(ICON_NAME_NORMAL2, 160);
        this.iconNormal_ic1 = this.getDefaultIcon(ICON_NAME_NORMAL_IC1, 96);
        this.iconNormal_ic2 = this.getDefaultIcon(ICON_NAME_NORMAL_IC2, 160);
        this.iconNotInJar = this.getDefaultIcon(ICON_NOT_IN_JAR, 96);
        JLabel jLabel = new JLabel(this.getImageIcon("AppIcon", 0));
        JLabel jLabel2 = new JLabel(this.getImageIcon("AppMainTitle", 0));
        JLabel jLabel3 = new JLabel(this.getImageIcon("MenuTitleImage", 0));
        JLabel jLabel4 = new JLabel(this.getImageIcon("MenuTitleImage", 1));
        JLabel jLabel5 = new JLabel(Resource.getString("ICON_IMAGE"));
        JLabel jLabel6 = new JLabel(Resource.getString("MAINTITLE_IMAGE"));
        JLabel jLabel7 = new JLabel(Resource.getString("IC_ICON_IMAGE"));
        JLabel jLabel8 = new JLabel(Resource.getString("IC_MAINTITLE_IMAGE"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel5);
        jPanel2.setLayout(new FlowLayout(2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EtchedBorder());
        jPanel3.setLayout(new FlowLayout(1));
        jPanel3.add(jLabel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jLabel6);
        jPanel5.setLayout(new FlowLayout(2));
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new EtchedBorder());
        jPanel6.setLayout(new FlowLayout(1));
        jPanel6.add(jLabel2);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(1, 2));
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.add(jPanel4);
        jPanel8.add(jPanel7);
        if (n != 4) {
            jComponent = new JPanel();
            jComponent.add(jLabel7);
            jComponent.setLayout(new FlowLayout(2));
            jPanel = new JPanel();
            jPanel.setBorder(new EtchedBorder());
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(jLabel3);
            container = new JPanel();
            container.setLayout(new GridLayout(1, 2));
            container.add(jComponent);
            container.add(jPanel);
            JPanel jPanel9 = new JPanel();
            jPanel9.add(jLabel8);
            jPanel9.setLayout(new FlowLayout(2));
            JPanel jPanel10 = new JPanel();
            jPanel10.setBorder(new EtchedBorder());
            jPanel10.setLayout(new FlowLayout(1));
            jPanel10.add(jLabel4);
            JPanel jPanel11 = new JPanel();
            jPanel11.setLayout(new GridLayout(1, 2));
            jPanel11.add(jPanel9);
            jPanel11.add(jPanel10);
            jPanel8.add(container);
            jPanel8.add(jPanel11);
        }
        jComponent = new JButton(Resource.getString("CLOSE"));
        ((AbstractButton)jComponent).setActionCommand("cancel");
        ((AbstractButton)jComponent).addActionListener(actionDispatcher);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jComponent);
        container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add("Center", jPanel8);
        container.add("South", jPanel);
        this.pack();
        this.setResizable(false);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    public ImageIcon getImageIcon(String string, int n) {
        ImageIcon imageIcon = this.iconNormal;
        Image image = null;
        String string2 = this.parent.getProjectName();
        int n2 = 160;
        int n3 = REGULATION_SIZE[1];
        ImageIcon imageIcon2 = new ImageIcon();
        if (string.equals("AppIcon")) {
            n2 = 96;
        }
        if (string.equals("AppMainTitle")) {
            imageIcon = this.iconNormal2;
            n3 = REGULATION_SIZE[3];
        }
        if (string.equals("MenuTitleImage")) {
            imageIcon = this.iconNormal_ic2;
            n3 = REGULATION_SIZE[3];
        }
        if (string.equals("MenuTitleImage") && n == 0) {
            imageIcon = this.iconNormal_ic1;
            n2 = 96;
            n3 = REGULATION_SIZE[2];
        }
        try {
            StringTokenizer stringTokenizer;
            int n4;
            String string3 = this.adfWindow.getKeyValue(string);
            if (string3.getBytes().length >= 256) {
                return this.iconNotInJar;
            }
            if (string3 != null && (n4 = (stringTokenizer = new StringTokenizer(string3, ",")).countTokens()) > 0) {
                String string4 = stringTokenizer.nextToken();
                if (string.equals("MenuTitleImage") && n == 1) {
                    string4 = stringTokenizer.nextToken();
                }
                if (n4 >= 2 && string.equals("AppIcon")) {
                    string4 = stringTokenizer.nextToken();
                    n3 = REGULATION_SIZE[2];
                }
                AppIconCheck appIconCheck = new AppIconCheck(1);
                String string5 = this.pfl.getJarPath(string2);
                byte[] byArray = this.getIconBytes(string5, string4);
                String string6 = null;
                if (!(byArray != null && appIconCheck.checkFormat(byArray, n3) == 0 || (byArray = this.getIconBytes(string6 = this.pfl.getResPath(string2) + string4)) != null && appIconCheck.checkFormat(byArray, n3) == 0)) {
                    return this.iconNotInJar;
                }
                imageIcon = new ImageIcon(byArray);
                image = imageIcon.getImage();
                Image image2 = image.getScaledInstance(n2, n2, 4);
                imageIcon.setImage(image2);
                if (string6 != null) {
                    image = imageIcon.getImage();
                    BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                    Image image3 = this.iconNotInJar.getImage();
                    Image image4 = image3.getScaledInstance(n2, n2, 4);
                    imageIcon2.setImage(image4);
                    graphics2D.drawImage(imageIcon2.getImage(), 0, 0, null);
                    imageIcon.setImage(bufferedImage);
                }
                return imageIcon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageIcon;
    }

    private ImageIcon getDefaultIcon(String string, int n) {
        ImageIcon imageIcon = null;
        Image image = null;
        try {
            byte[] byArray = this.getIconBytes(ICON_DIR + string);
            AppIconCheck appIconCheck = new AppIconCheck(0);
            int n2 = appIconCheck.checkFormat(byArray);
            if (n2 == 0) {
                imageIcon = new ImageIcon(byArray);
            } else if (n2 == -3) {
                imageIcon = new ImageIcon(byArray);
                image = imageIcon.getImage();
                int n3 = image.getWidth(null);
                int n4 = image.getHeight(null);
                if (n3 > 0 && n4 > 0) {
                    image = image.getScaledInstance(n, n, 4);
                    imageIcon.setImage(image);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getIconBytes(String string) {
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        byte[] byArray2 = null;
        try {
            fileInputStream = new FileInputStream(string);
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getIconBytes(String string, String string2) {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        JarFile jarFile = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        byte[] byArray2 = null;
        try {
            jarFile = new JarFile(string);
            inputStream = jarFile.getInputStream(jarFile.getEntry(string2));
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray2;
    }
}

