/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class ImageFileChooser
extends JFrame {
    public ImageFileChooser() throws HeadlessException {
        this.setIconImage(MainWindow.titlebarIconImage.getImage());
    }

    public String showImageDialog(String string) {
        String string2 = Resource.getString("FILE_CHOOSER_TITLE");
        return this.showDialog(string2, string, new ImageFileFilter());
    }

    private String showDialog(String string, String string2, FileFilter fileFilter) {
        File file = new File(string2);
        JFileChooser jFileChooser = null;
        jFileChooser = file.exists() ? new JFileChooser(file) : new JFileChooser();
        jFileChooser.setAccessory(new ImagePreview(jFileChooser));
        jFileChooser.setDialogTitle(string);
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            return jFileChooser.getSelectedFile().getPath();
        }
        return null;
    }

    class ImagePreview
    extends JComponent
    implements PropertyChangeListener {
        private static final int PREVIEW_HEIGHT = 50;
        private static final int PREVIEW_WIDTH = 90;
        private static final int PREVIEW_MARGIN = 5;
        private ImageIcon previewImage = null;
        private File file = null;

        public ImagePreview(JFileChooser jFileChooser) {
            this.setPreferredSize(new Dimension(100, 50));
            jFileChooser.addPropertyChangeListener(this);
        }

        private void loadImage() {
            Image image;
            if (this.file == null) {
                this.previewImage = null;
                return;
            }
            ImageIcon imageIcon = new ImageIcon(this.file.getPath());
            if (imageIcon == null) {
                return;
            }
            if (imageIcon.getIconWidth() > 90) {
                image = imageIcon.getImage().getScaledInstance(90, -1, 1);
                imageIcon = new ImageIcon(image);
            }
            if (imageIcon.getIconHeight() > 50) {
                image = imageIcon.getImage().getScaledInstance(-1, 50, 1);
                imageIcon = new ImageIcon(image);
            }
            this.previewImage = imageIcon;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = false;
            String string = propertyChangeEvent.getPropertyName();
            if ("directoryChanged".equals(string)) {
                this.file = null;
                bl = true;
            } else if ("SelectedFileChangedProperty".equals(string)) {
                this.file = (File)propertyChangeEvent.getNewValue();
                bl = true;
            }
            if (bl) {
                this.previewImage = null;
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.previewImage == null) {
                this.loadImage();
            }
            if (this.previewImage != null) {
                int n = this.getWidth() / 2 - this.previewImage.getIconWidth() / 2;
                int n2 = this.getHeight() / 2 - this.previewImage.getIconHeight() / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < 5) {
                    n = 5;
                }
                this.previewImage.paintIcon(this, graphics, n, n2);
            }
        }
    }

    class ImageFileFilter
    extends FileFilter {
        ImageFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getPath().toLowerCase();
            return string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".jpeg");
        }

        @Override
        public String getDescription() {
            return Resource.getString("FILE_CHOOSER_SOURCE_FILTER");
        }
    }
}

