/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AsciiDocument;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindowDoButtonControl;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class InvitationWindow
extends AbstractWindow {
    private JPanel jContentPane = null;
    private JPanel parameterPanel = null;
    private JLabel paramLabel = null;
    private JPanel buttonPanel = null;
    private JTextField paramTextField;
    private JButton invitationRunButton = null;
    private JButton cancelButton = null;
    private MainWindow parent;

    InvitationWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("DISP_INVITATION"));
        this.parent = mainWindow;
        this.initialize();
        this.invitationRunButton.setActionCommand("invitationRun");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.invitationRunButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setResizable(true);
        this.pack();
    }

    void invitationRun() {
        this.setInvitationParam();
        try {
            JAMManager.invokeApplication(this.parent.getAppType(), this.parent.getAdfPath(), this.parent.getJarPath(), 25, new byte[]{0}, this.parent.getDeviceName(), this.parent.getAdfUrl(), this.parent.getProjectNameForBytes(), DebugTraceWindow.getDebugParam());
            this.parent.setEnabledDeviceMenu(false);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
        }
        MainWindowDoButtonControl.start(this.parent);
        this.dispose();
    }

    private void setInvitationParam() {
        String string = this.paramTextField.getText();
        string = string == null ? "" : string.trim();
        Setting setting = this.parent.projectSetting;
        setting.setProperty("invitationParameter", string);
        this.parent.saveProjectSetting(setting);
    }

    private void getInvitationParam() {
        Setting setting = this.parent.projectSetting;
        String string = setting.getProperty("invitationParameter");
        this.paramTextField.setText(string);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private void initialize() {
        this.setSize(400, 130);
        this.setContentPane(this.getJContentPane());
        this.getInvitationParam();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getParameterPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getParameterPanel() {
        if (this.parameterPanel == null) {
            this.paramLabel = new JLabel();
            this.paramLabel.setText(Resource.getString("INVITATION_PARAM"));
            this.parameterPanel = new JPanel();
            this.parameterPanel.add((Component)this.paramLabel, null);
            this.parameterPanel.add((Component)this.getParamTextField(), null);
        }
        return this.parameterPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getInvitationRunButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JTextField getParamTextField() {
        if (this.paramTextField == null) {
            this.paramTextField = new JTextField();
            this.paramTextField.setDocument(new AsciiDocument(50));
            this.paramTextField.setHorizontalAlignment(2);
            this.paramTextField.setColumns(25);
        }
        return this.paramTextField;
    }

    private JButton getInvitationRunButton() {
        if (this.invitationRunButton == null) {
            this.invitationRunButton = new JButton();
            this.invitationRunButton.setText(Resource.getString("DISP_INVITATION"));
        }
        return this.invitationRunButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(Resource.getString("CANCEL"));
        }
        return this.cancelButton;
    }
}

