/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class KtoolbarTitleSettingWindow
extends TabPanel
implements ItemListener {
    private MainWindow parent = null;
    private JRadioButton radioButton1;
    private JRadioButton radioButton2;
    static final int KTOOLBAR_TITLE_TYPE_1 = 1;
    static final int KTOOLBAR_TITLE_TYPE_2 = 2;

    KtoolbarTitleSettingWindow(MainWindow mainWindow, AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.parent = mainWindow;
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radioButton1 = new JRadioButton(Resource.getString("SET_KTOOLBAR_TITLE_TYPE_1"));
        this.radioButton2 = new JRadioButton(Resource.getString("SET_KTOOLBAR_TITLE_TYPE_2"));
        buttonGroup.add(this.radioButton1);
        buttonGroup.add(this.radioButton2);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_KTOOLBAR_TITLE_UPDATE")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.radioButton1, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.radioButton2, gridBagConstraints);
        int n = JAMManager.getKtoolbarTitleType();
        if (n == 2) {
            this.radioButton2.setSelected(true);
        } else {
            this.radioButton1.setSelected(true);
        }
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
        this.radioButton1.addItemListener(this);
        this.radioButton2.addItemListener(this);
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        int n = -1;
        if (this.radioButton1.isSelected()) {
            n = 1;
        }
        if (this.radioButton2.isSelected()) {
            n = 2;
        }
        if (JAMManager.setKtoolbarTitleType(n) < 0) {
            return false;
        }
        this.parent.setTitlebarName();
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }
}

