/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ListenerSetting;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

class MakeSourceFile {
    private static final String PARENT_DIR = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "template" + File.separator;
    static final String IAPP_PANEL = PARENT_DIR + "IApplicationPanel.txt";
    static final String IAPP_CANVAS = PARENT_DIR + "IApplicationCanvas.txt";
    static final String MAPP_PANEL = PARENT_DIR + "MApplicationPanel.txt";
    static final String MAPP_CANVAS = PARENT_DIR + "MApplicationCanvas.txt";
    static final String NONE_PANEL = PARENT_DIR + "Panel.txt";
    static final String NONE_CANVAS = PARENT_DIR + "Canvas.txt";
    static final int FRAME_NONE = 0;
    static final int FRAME_PANEL = 1;
    static final int FRAME_CANVAS = 2;
    private static final int CLASSNAME_CODE = 0;
    private static final int DATE_CODE = 1;
    private static final int IMPORT_CODE = 2;
    private static final int IMPLEMENTS_CODE = 3;
    private static final int INIT_PROC_CODE = 4;
    private static final int ABSTRACT_METHOD_CODE = 5;
    private static final int FIELD_CODE = 6;
    private static final int SPARE_CODE = 7;
    private static String[] KEYWORDS = new String[]{"{CLASSNAME}", "{DATE}", "%IMPORT%", "%IMPLEMENTS%", "%INIT_PROC%", "%ABSTRACT_METHOD%", "%FIELD%"};
    private static String[] BLOCK_WORDS = new String[]{"[IMPORT]", "[IMPLEMENTS]", "[INIT_PROC]", "[ABSTRACT_METHOD]", "[FIELD]"};
    private static final String S_BRACKET = "[";
    private static final String E_BRACKET = "]";
    private Vector enableKey = null;
    private String[] indents = new String[KEYWORDS.length];
    private Vector alreadyImports = new Vector();
    private static final String WS = " ";
    private static final String BR = "\r\n";
    private static final String SCOLON = ";";
    private static final String COMMA = ", ";
    private static final String ASTARISK = ".*";
    private static final String STR_IMPORT = "import ";
    private static final String STR_IMPLEMENTS = "implements ";
    private static final String LISTENER_DIR = PARENT_DIR + File.separator + "listener" + File.separator;
    private static final File SOFTKEYL_SETFILE = new File(LISTENER_DIR + "SoftKeyListener.conf");
    static final int CODE_SOFTKEYL = 0;
    private static final File KEYL_SETFILE = new File(LISTENER_DIR + "KeyListener.conf");
    static final int CODE_KEYL = 1;
    private static final File COMPONENTL_SETFILE = new File(LISTENER_DIR + "ComponentListener.conf");
    static final int CODE_COMPONENTL = 2;
    private static final File MEDIAL_SETFILE = new File(LISTENER_DIR + "MediaListener.conf");
    static final int CODE_MEDIAL = 3;
    private static final File TIMERL_SETFILE = new File(LISTENER_DIR + "TimerListener.conf");
    static final int CODE_TIMERL = 4;
    private static final File MESFOLDERL_SETFILE = new File(LISTENER_DIR + "MessageFolderListener.conf");
    static final int CODE_MESFOLDERL = 5;
    private static final File AUDIO3DL_SETFILE = new File(LISTENER_DIR + "Audio3DListener.conf");
    static final int CODE_AUDIO3DL = 6;
    private static File[] SETFILES = new File[]{SOFTKEYL_SETFILE, KEYL_SETFILE, COMPONENTL_SETFILE, MEDIAL_SETFILE, TIMERL_SETFILE, MESFOLDERL_SETFILE, AUDIO3DL_SETFILE};
    private boolean[] useListeners = new boolean[SETFILES.length];
    private ListenerSetting[] lSets = new ListenerSetting[SETFILES.length];
    private static final String STR_SOFTKEYL = "SoftKeyListener";
    private static final String STR_KEYL = "KeyListener";
    private static final String STR_COMPONENTL = "ComponentListener";
    private static final String STR_MEDIAL = "MediaListener";
    private static final String STR_TIMERL = "TimerListener";
    private static final String STR_MESFOLDERL = "MessageFolderListener";
    private static final String STR_AUDIO3DL = "Audio3DListener";
    private static final String STR_COMPONENT = "Component";
    private static final String STR_AUDIOPRES = "AudioPresenter";
    private static final String STR_MEDIAPRES = "MediaPresenter";
    private static final String STR_TIMER = "Timer";
    private static final String STR_MESAGANT = "MessageAgent";
    private static final String STR_AUDIO3D = "Audio3D";
    private static final String PACAGE_UI = "com.nttdocomo.ui.";
    private static final String PACAGE_UTIL = "com.nttdocomo.util.";
    private static final String PACAGE_SYSTEM = "com.nttdocomo.system.";
    private static final String[] IMPORT_SOFTKEYL = new String[]{"import com.nttdocomo.ui.SoftKeyListener;"};
    private static final String[] IMPORT_KEYL = new String[]{"import com.nttdocomo.ui.KeyListener;"};
    private static final String[] IMPORT_COMPONENTL = new String[]{"import com.nttdocomo.ui.ComponentListener;", "import com.nttdocomo.ui.Component;"};
    private static final String[] IMPORT_MEDIAL = new String[]{"import com.nttdocomo.ui.MediaListener;", "import com.nttdocomo.ui.AudioPresenter;", "import com.nttdocomo.ui.MediaPresenter;"};
    private static final String[] IMPORT_TIMERL = new String[]{"import com.nttdocomo.util.TimerListener;", "import com.nttdocomo.util.Timer;"};
    private static final String[] IMPORT_MESFOLDERL = new String[]{"import com.nttdocomo.system.MessageFolderListener;", "import com.nttdocomo.system.MessageAgent;"};
    private static final String[] IMPORT_AUDIO3DL = new String[]{"import com.nttdocomo.ui.Audio3DListener;", "import com.nttdocomo.ui.Audio3D;", "import com.nttdocomo.ui.AudioPresenter;"};
    private static final String[][] ARRAY_IMPORTS = new String[][]{IMPORT_SOFTKEYL, IMPORT_KEYL, IMPORT_COMPONENTL, IMPORT_MEDIAL, IMPORT_TIMERL, IMPORT_MESFOLDERL, IMPORT_AUDIO3DL};
    private static final String[] IMPL_SOFTKEYL = new String[]{"SoftKeyListener"};
    private static final String[] IMPL_KEYL = new String[]{"KeyListener"};
    private static final String[] IMPL_COMPONENTL = new String[]{"ComponentListener"};
    private static final String[] IMPL_MEDIAL = new String[]{"MediaListener"};
    private static final String[] IMPL_TIMERL = new String[]{"TimerListener"};
    private static final String[] IMPL_MESFOLDERL = new String[]{"MessageFolderListener"};
    private static final String[] IMPL_AUDIO3DL = new String[]{"Audio3DListener"};
    private static final String[][] ARRAY_IMPLEMNTS = new String[][]{IMPL_SOFTKEYL, IMPL_KEYL, IMPL_COMPONENTL, IMPL_MEDIAL, IMPL_TIMERL, IMPL_MESFOLDERL, IMPL_AUDIO3DL};
    private static final String[] INIT_SOFTKEYL = new String[]{"setSoftKeyListener((SoftKeyListener)this);"};
    private static final String[] INIT_KEYL = new String[]{"setKeyListener((KeyListener)this);"};
    private static final String[] INIT_COMPONENTL = new String[]{"setComponentListener((ComponentListener)this);"};
    private static final String[] INIT_MEDIAL = new String[]{"(AudioPresenter.getAudioPresenter()).setMediaListener((MediaListener)this);"};
    private static final String[] INIT_TIMERL = new String[]{"Timer tm = new Timer();", "tm.setListener((TimerListener)this);"};
    private static final String[] INIT_MESFOLDERL = new String[]{"MessageAgent.setMessageFolderListener((MessageFolderListener)this);"};
    private static final String[] INIT_AUDIO3DL = new String[]{"Audio3D a3d = (AudioPresenter.getAudioPresenter()).getAudio3D();", "a3d.setListener((Audio3DListener)this);"};
    private static final String[][] ARRAY_INITPROC = new String[][]{INIT_SOFTKEYL, INIT_KEYL, INIT_COMPONENTL, INIT_MEDIAL, INIT_TIMERL, INIT_MESFOLDERL, INIT_AUDIO3DL};
    private static final String[] SOFTKEYL_METHOD = new String[]{"public void softKeyPressed(int softKey) {}", "public void softKeyReleased(int softKey) {}"};
    private static final String[] KEYL_METHOD = new String[]{"public void keyPressed(Panel panel, int key) {}", "public void keyReleased(Panel panel, int key) {}"};
    private static final String[] COMPL_METHOD = new String[]{"public void componentAction(Component source, int type, int param) {}"};
    private static final String[] MEDIAL_METHOD = new String[]{"public void mediaAction(MediaPresenter source, int type, int param) {}"};
    private static final String[] TIMERL_METHOD = new String[]{"public void timerExpired(Timer source) {}"};
    private static final String[] MESFOLDERL_METHOD = new String[]{"public void folderChanged(int type) {}"};
    private static final String[] AUDIO3DL_METHOD = new String[]{"public void audioAction(Audio3D source, int type, int param) {}"};
    private static final String[][] ARRAY_METHOD = new String[][]{SOFTKEYL_METHOD, KEYL_METHOD, COMPL_METHOD, MEDIAL_METHOD, TIMERL_METHOD, MESFOLDERL_METHOD, AUDIO3DL_METHOD};
    private static final String IMPORT_PANEL = "import com.nttdocomo.ui.Panel;";
    private static final String[] INSTANCE_PANEL = new String[]{"Panel p = new Panel();"};
    private static final String[] INIT_SOFTKEYL_P = new String[]{"p.setSoftLabel(Frame.SOFT_KEY_1, \"FIN\");", "p.setBackground(Graphics.getColorOfName(Graphics.RED));", "p.setSoftKeyListener((SoftKeyListener)this);"};
    private static final String[] INIT_KEYL_P = new String[]{"p.setKeyListener((KeyListener)this);"};
    private static final String[] INIT_COMPONENTL_P = new String[]{"p.setComponentListener((ComponentListener)this);"};
    private int frameType = 1;
    private boolean needNewPanel = false;
    boolean setNewPanel = false;
    private String className = null;
    private File baseFile = null;
    private File dupFile = null;

    MakeSourceFile(String string, File file, File file2) throws IOException {
        if (string == null || file == null || file2 == null) {
            throw new NullPointerException();
        }
        if (!file.canRead()) {
            throw new IOException();
        }
        this.className = string;
        this.baseFile = file;
        this.dupFile = file2;
        this.setFileInfo();
        this.initUseListener();
    }

    MakeSourceFile(String string, File file, File file2, int n) throws IOException {
        if (string == null || file == null || file2 == null) {
            throw new NullPointerException();
        }
        if (!file.canRead()) {
            throw new IOException();
        }
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.className = string;
        this.baseFile = file;
        this.dupFile = file2;
        this.frameType = n;
        this.setFileInfo();
        this.initUseListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileInfo() {
        BufferedReader bufferedReader = null;
        String string = "";
        for (int i = 0; i < this.indents.length; ++i) {
            this.indents[i] = "";
        }
        try {
            String string2;
            int n = -1;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.baseFile)));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (this.trimSpace(string2).indexOf(STR_IMPORT) == 0) {
                    string = string + string2;
                }
                for (int i = 0; i < KEYWORDS.length; ++i) {
                    n = string2.indexOf(KEYWORDS[i]);
                    if (n == -1) continue;
                    this.setNewIndent(i, string2.substring(0, n));
                }
            }
            if (string.length() > 0) {
                this.setExistImportLine(string);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private void initUseListener() {
        for (int i = 0; i < this.useListeners.length; ++i) {
            this.useListeners[i] = false;
            this.lSets[i] = null;
        }
        this.enableKey = new Vector<String>(Arrays.asList(BLOCK_WORDS));
    }

    void setUseListener(int n, boolean bl) {
        this.useListeners[n] = bl;
        if (bl) {
            this.lSets[n] = new ListenerSetting(SETFILES[n], this.enableKey);
        }
        if (this.frameType == 2 && (n == 0 || n == 1 || n == 2)) {
            this.needNewPanel = true;
        }
    }

    private void setNewIndent(int n, String string) {
        String string2 = "";
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            return;
        }
        string2 = this.trimSpace(string).length() == 0 ? string : this.strMemset(string, ' ');
        this.indents[n] = string2;
    }

    private void setExistImportLine(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        String[] stringArray = this.splitStr(string, SCOLON);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.trimSpace(stringArray[i]).indexOf(STR_IMPORT) != 0) continue;
            this.alreadyImports.add(this.trimSpace(stringArray[i]) + SCOLON);
        }
    }

    private String unitizeSettingStr(int n) {
        String string = "";
        String string2 = "";
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.useListeners.length; ++i) {
            if (!this.useListeners[i] || (string = this.readRepSrcCode(i, n)) == null) continue;
            vector.add(string);
        }
        string2 = !vector.isEmpty() ? this.combineRepKeyLines(vector, n) : "";
        return string2;
    }

    private String readRepSrcCode(int n, int n2) {
        String string = null;
        if (n2 == 0 || n2 == 1) {
            return null;
        }
        switch (n2) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = this.getLines(n, n2, true);
                break;
            }
            case 6: 
            case 7: {
                string = this.getLines(n, n2, false);
                break;
            }
            default: {
                string = this.getLines(n, n2, false);
            }
        }
        return string;
    }

    private String getLines(int n, int n2, boolean bl) {
        String string = "";
        String string2 = "";
        if (this.lSets[n] == null) {
            throw new NullPointerException();
        }
        string2 = bl ? this.getCoupler(n2) : BR + this.indents[n2];
        String string3 = this.createBlocWord(n2);
        string = this.lSets[n].keyExist(string3) ? this.lSets[n].getText(string3, string2) : (bl ? this.readDefault(n, n2) : null);
        return string;
    }

    private String createBlocWord(int n) {
        String string = KEYWORDS[n];
        if (string.length() <= 2) {
            return "";
        }
        String string2 = string.substring(1, string.length() - 1);
        String string3 = S_BRACKET + string2 + E_BRACKET;
        return string3;
    }

    private String readDefault(int n, int n2) {
        String[] stringArray;
        String string = "";
        String string2 = this.getCoupler(n2);
        switch (n2) {
            case 2: {
                stringArray = ARRAY_IMPORTS[n];
                break;
            }
            case 3: {
                stringArray = ARRAY_IMPLEMNTS[n];
                break;
            }
            case 4: {
                if (this.needNewPanel) {
                    if (n == 0) {
                        stringArray = INIT_SOFTKEYL_P;
                        break;
                    }
                    if (n == 1) {
                        stringArray = INIT_KEYL_P;
                        break;
                    }
                    if (n == 2) {
                        stringArray = INIT_COMPONENTL_P;
                        break;
                    }
                    stringArray = ARRAY_INITPROC[n];
                    break;
                }
                stringArray = ARRAY_INITPROC[n];
                break;
            }
            case 5: {
                stringArray = ARRAY_METHOD[n];
                break;
            }
            default: {
                stringArray = null;
            }
        }
        if (stringArray == null) {
            return null;
        }
        string = this.concatArray(stringArray, string2);
        return string;
    }

    private String getCoupler(int n) {
        String string = "";
        switch (n) {
            case 3: {
                string = COMMA;
                break;
            }
            case 2: {
                string = BR;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = BR + this.indents[n];
                break;
            }
            default: {
                string = BR;
            }
        }
        return string;
    }

    private String combineRepKeyLines(Collection collection, int n) {
        String string = null;
        if (n == 0 || n == 1) {
            return null;
        }
        if (n == 2 && this.needNewPanel) {
            collection.add(IMPORT_PANEL);
        }
        Object[] objectArray = collection.toArray();
        switch (n) {
            case 2: {
                string = this.concatImport(objectArray);
                break;
            }
            case 3: {
                string = this.concatImplements(objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = this.concatKeyWord(objectArray, n);
                break;
            }
            default: {
                string = this.concatKeyWord(objectArray, n);
            }
        }
        return string;
    }

    private String concatImport(Object[] objectArray) {
        String string = "";
        if (objectArray.length == 0) {
            return string;
        }
        string = this.concatArray(objectArray, this.getCoupler(2));
        String string2 = this.removeDupItem(string, this.alreadyImports);
        string = this.removeImportWithOnDemand(string2);
        string = this.sortImportLine(string);
        return string;
    }

    private String concatImplements(Object[] objectArray) {
        if (objectArray.length == 0) {
            return "";
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (this.trimSpace(string).length() == 0) continue;
            vector.add(objectArray[i]);
        }
        String string = "";
        string = vector.isEmpty() ? "" : this.concatArray(vector.toArray(), this.getCoupler(3));
        if (string.length() != 0) {
            string = STR_IMPLEMENTS + this.removeDupItem(string, COMMA);
        }
        return string;
    }

    private String concatKeyWord(Object[] objectArray, int n) {
        String string = "";
        if (objectArray == null) {
            return null;
        }
        if (n >= KEYWORDS.length) {
            return null;
        }
        string = this.concatArray(objectArray, this.getCoupler(n));
        return string;
    }

    private String removeDupItem(String string, Collection collection) {
        return this.removeDupItem(string, collection, BR);
    }

    private String removeDupItem(String string, String string2) {
        Vector vector = new Vector();
        return this.removeDupItem(string, vector, string2);
    }

    private String removeDupItem(String string, Collection collection, String string2) {
        if (string.length() == 0) {
            return string;
        }
        String[] stringArray = this.splitStr(string, string2);
        String string3 = "";
        TreeSet<String> treeSet = new TreeSet<String>(collection);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.trimSpace(stringArray[i]).length() == 0 || !treeSet.add(this.trimSpace(stringArray[i]))) continue;
            string3 = string3 + stringArray[i] + string2;
        }
        String string4 = "";
        int n = 0;
        n = string3.lastIndexOf(string2);
        string4 = n != -1 ? string3.substring(0, n) : string3;
        return string4;
    }

    private String removeImportWithOnDemand(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = "";
        String string3 = "";
        int n = 0;
        Enumeration enumeration = this.alreadyImports.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            n = string2.indexOf(ASTARISK);
            if (n == -1) continue;
            vector.add(string2.substring(0, n));
        }
        if (vector.isEmpty()) {
            return string;
        }
        String[] stringArray = this.splitStr(string, BR);
        Vector<String> vector2 = new Vector<String>();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            bl = false;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string2 = (String)enumeration2.nextElement();
                if (stringArray[i].indexOf(string2) == -1) continue;
                bl = true;
            }
            if (bl) continue;
            vector2.add(stringArray[i]);
        }
        string3 = !vector2.isEmpty() ? this.concatArray(vector2.toArray(), BR) : "";
        return string3;
    }

    private String sortImportLine(String string) {
        if (string.length() == 0) {
            return string;
        }
        Object[] objectArray = this.splitStr(string, BR);
        Arrays.sort(objectArray);
        return this.concatArray(objectArray, BR);
    }

    void makeFile() throws IOException {
        String string = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < KEYWORDS.length; ++i) {
            Object object;
            if (i == 0) {
                string = this.className;
            } else if (i == 1) {
                object = Calendar.getInstance();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                string = simpleDateFormat.format(((Calendar)object).getTime());
            } else {
                string = this.unitizeSettingStr(i);
                if (i == 6 && this.needNewPanel && !this.setNewPanel) {
                    object = this.getCoupler(6);
                    string = string + (String)object + this.concatArray(INSTANCE_PANEL, (String)object);
                    this.setNewPanel = true;
                }
                if (string == null) {
                    string = "";
                }
            }
            hashtable.put(KEYWORDS[i], string);
        }
        this.makeFile(hashtable);
    }

    private void makeFile(Hashtable hashtable) throws IOException {
        if (hashtable == null) {
            throw new NullPointerException();
        }
        String string = "";
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.dupFile)));
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.baseFile)));
            boolean bl = true;
            while ((string = bufferedReader.readLine()) != null) {
                bl = this.trimSpace(string).length() == 0 ? true : (string = this.replaceKeyword(string, hashtable)).length() != 0;
                if (!bl) continue;
                bufferedWriter.write(string + BR);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                bufferedWriter.close();
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private String replaceKeyword(String string, Hashtable hashtable) {
        int n = 0;
        int[] nArray = new int[2];
        while ((nArray = this.firstKeywordPos(string, n))[0] != -1) {
            String string2 = string.substring(nArray[0], nArray[1] + 1);
            if (hashtable.containsKey(string2)) {
                String string3 = (String)hashtable.get(string2);
                if (string3 == null) {
                    string3 = "";
                }
                if (this.trimSpace(string = string.substring(0, nArray[0]) + string3 + string.substring(nArray[1] + 1)).length() == 0) {
                    string = "";
                    break;
                }
                n = nArray[0] + string3.length();
                continue;
            }
            n = nArray[1];
        }
        return string;
    }

    private int[] firstKeywordPos(String string, int n) {
        int[] nArray = new int[]{-1, -1};
        if (string.length() == 0) {
            nArray[0] = -1;
            return nArray;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= string.length()) {
            nArray[0] = -1;
            return nArray;
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < KEYWORDS.length; ++i) {
            n4 = string.indexOf(KEYWORDS[i], n);
            if (n4 == -1 || n4 >= n2) continue;
            n2 = n4;
            n3 = n2 + (KEYWORDS[i].length() - 1);
        }
        if (n2 == string.length()) {
            nArray[0] = -1;
            return nArray;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return nArray;
    }

    private String strMemset(String string, char c) {
        byte[] byArray;
        String string2 = "";
        if (string == null || string.length() == 0) {
            return string2;
        }
        String string3 = "";
        try {
            byArray = string.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        for (int i = 0; i < byArray.length; ++i) {
            string3 = string3 + String.valueOf(c);
        }
        return string3;
    }

    private String concatArray(Object[] objectArray, String string) {
        if (objectArray.length == 0 || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = objectArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(objectArray[i]);
            if (i >= n) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String[] splitStr(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        if (string.equals("") || string2.equals("")) {
            vector.add("");
            return vector.toArray(new String[0]);
        }
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        if (vector.isEmpty()) {
            vector.add("");
        }
        return vector.toArray(new String[0]);
    }

    private String trimSpace(String string) {
        String string2 = "";
        if (string.length() != 0) {
            string2 = string.trim();
        }
        return string2;
    }
}

