/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AppPropDeviceSetupTab;
import com.nttdocomo.dojaemu.ktoolbar.Environment;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SDF;
import com.nttdocomo.dojaemu.ktoolbar.SelectProjectWindow;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import com.nttdocomo.dojaemu.ktoolbar.StringChecker;
import com.nttdocomo.dojaemu.ktoolbar.StringDocument;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

class NewWindow
extends AbstractWindow {
    private JTextField projectNameField;
    private JLabel projectPathLabel;
    private JCheckBox checkBox;
    private JRadioButton fullApplRadioButton;
    private JRadioButton miniApplRadioButton;
    private JRadioButton minifullApplRadioButton;
    private JRadioButton bookmarkRadioButton;
    private SelectProjectWindow spw = null;
    private static String projectHome;
    private static String preProjectHome;
    private String fullApplProjectName = "";
    private String miniApplProjectName = "";

    NewWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("NEW_WINDOW_TITLE"));
        this.addWindowListener();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("PROJECT_HOME"));
        this.projectPathLabel = new JLabel(mainWindow.getProjectHome());
        JButton jButton = new JButton(Resource.getString("FILE_SELECT"));
        jButton.setMnemonic(82);
        JLabel jLabel2 = new JLabel(" ");
        JLabel jLabel3 = new JLabel("                   ");
        JLabel jLabel4 = new JLabel("           ");
        JLabel jLabel5 = new JLabel(Resource.getString("PROJECT_NAME"));
        this.projectNameField = new JTextField(25);
        this.projectNameField.setDocument(new StringDocument(64));
        JButton jButton2 = new JButton(Resource.getString("MAKE"));
        JButton jButton3 = new JButton(Resource.getString("CANCEL"));
        this.checkBox = new JCheckBox(Resource.getString("MAKE_CONTINUE"), true);
        JLabel jLabel6 = new JLabel(Resource.getString("TYPE_OF_IAPPLI"));
        this.fullApplRadioButton = new JRadioButton(Resource.getString("APPTYPE_FULL"));
        this.miniApplRadioButton = new JRadioButton(Resource.getString("APPTYPE_MINI"));
        this.minifullApplRadioButton = new JRadioButton(Resource.getString("APPTYPE_MNFL"));
        this.bookmarkRadioButton = new JRadioButton(Resource.getString("APPTYPE_BOMK"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fullApplRadioButton);
        buttonGroup.add(this.miniApplRadioButton);
        buttonGroup.add(this.minifullApplRadioButton);
        buttonGroup.add(this.bookmarkRadioButton);
        this.fullApplRadioButton.setSelected(true);
        this.projectNameField.setActionCommand("make");
        jButton.setActionCommand("select");
        jButton2.setActionCommand("make");
        jButton3.setActionCommand("cancel");
        this.fullApplRadioButton.setActionCommand("checkFullApplRadioButton");
        this.miniApplRadioButton.setActionCommand("checkMiniApplRadioButton");
        this.minifullApplRadioButton.setActionCommand("checkMinifullApplRadioButton");
        this.bookmarkRadioButton.setActionCommand("checkBookmarkRadioButton");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.projectNameField.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        this.fullApplRadioButton.addActionListener(actionDispatcher);
        this.miniApplRadioButton.addActionListener(actionDispatcher);
        this.minifullApplRadioButton.addActionListener(actionDispatcher);
        this.bookmarkRadioButton.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 0));
        jPanel4.setLayout(new BorderLayout(3, 0));
        jPanel5.setLayout(new BorderLayout(3, 0));
        jPanel2.setLayout(new FlowLayout(0));
        JSeparator jSeparator = new JSeparator(0);
        jPanel3.setLayout(new FlowLayout(0));
        jPanel6.setLayout(new FlowLayout(1));
        JSeparator jSeparator2 = new JSeparator(0);
        jPanel7.setLayout(new FlowLayout(1));
        jPanel8.setLayout(new BorderLayout(3, 0));
        jPanel9.setLayout(new GridLayout(3, 0));
        jPanel9.setPreferredSize(new Dimension(50, 75));
        JSeparator jSeparator3 = new JSeparator(0);
        jPanel10.setLayout(new FlowLayout(0));
        jPanel11.setLayout(new FlowLayout(0));
        jPanel12.setLayout(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(jButton);
        jPanel.add("North", jPanel2);
        jPanel.add("West", jLabel2);
        jPanel.add("Center", this.projectPathLabel);
        jPanel3.add(jLabel5);
        jPanel3.add(this.projectNameField);
        jPanel4.add("North", jSeparator);
        jPanel4.add("Center", jPanel3);
        jPanel10.add(jLabel6);
        jPanel11.add(this.fullApplRadioButton);
        jPanel11.add(jLabel3);
        jPanel11.add(this.miniApplRadioButton);
        jPanel12.add(this.minifullApplRadioButton);
        jPanel12.add(jLabel4);
        jPanel12.add(this.bookmarkRadioButton);
        jPanel9.add(jPanel10);
        jPanel9.add(jPanel11);
        jPanel9.add(jPanel12);
        jPanel8.add("North", jSeparator3);
        jPanel8.add("Center", jPanel9);
        jPanel4.add("South", jPanel8);
        jPanel6.add(this.checkBox);
        jPanel7.add(jButton2);
        jPanel7.add(jButton3);
        jPanel5.add("North", jSeparator2);
        jPanel5.add("Center", jPanel6);
        jPanel5.add("South", jPanel7);
        container.add("North", jPanel);
        container.add("Center", jPanel4);
        container.add("South", jPanel5);
        preProjectHome = projectHome = mainWindow.getProjectHome();
        this.setResizable(false);
        this.pack();
        this.projectNameField.requestFocus();
    }

    void make() {
        String string = this.projectNameField.getText();
        this.parent.setProjectHome(projectHome);
        try {
            this.checkProjectName(string);
        }
        catch (Exception exception) {
            this.parent.showDialog(exception.getMessage(), this, 2);
            return;
        }
        if (this.minifullApplRadioButton.isSelected()) {
            this.fullApplProjectName = "";
            this.miniApplProjectName = "";
            this.selectProject();
            if (this.fullApplProjectName.equals("")) {
                this.closeWindow();
                return;
            }
        }
        this.parent.clearOutputText();
        System.out.println(Resource.format("MAKE_PROJECT", string));
        Setting setting = new Setting();
        setting.setProperty("adfUrl", "");
        setting.setProperty("launchType", String.valueOf(0));
        setting.setProperty("sentMailMax", "50");
        setting.setProperty("receivedMailMax", "200");
        setting.setProperty("phoneBookEntry", "100");
        setting.setProperty("groupEntry", "10");
        setting.setProperty("bookmarkEntry", "10");
        setting.setProperty("dtvScheduleMax", "50");
        setting.setProperty("accelerationDevice", AppPropDeviceSetupTab.ACCELERATION_DEVICE[1]);
        setting.setProperty("accelerationDataMax", "20");
        setting.setProperty("launchTime", "1@1999/11//9/9/9;4@//2//2/2;8@///1/12/0;16@/6//1/15/30;");
        setting.setProperty("launchTimeMax", "4");
        setting.setProperty("cameraDevice", "1");
        setting.setProperty("cameraFrameRate", "15");
        setting.setProperty("sound3dResource", "4");
        setting.setProperty("simultaneousWithBuild", "false");
        setting.setProperty("linkHttpHeader", "false");
        setting.setProperty("xDcmMove", "0000");
        setting.setProperty("appMoveInfo", "false");
        setting.setProperty("moveFromOtherTerm", "false");
        setting.setProperty("invitationParameter", "");
        setting.setProperty("invitationResponse", "true");
        setting.setProperty("daysForSavingPedometerDataMax", Integer.toString(30));
        setting.setProperty("compassMaxDataSize", Integer.toString(3000));
        setting.setProperty("compassIntervalResolution", Integer.toString(100));
        setting.setProperty("gyroSensorMaxDataSize", Integer.toString(3000));
        setting.setProperty("gyroSensorIntervalResolution", "100");
        setting.setProperty("gyroSensorCalibrateTime", Integer.toString(10000));
        setting.setProperty("maxByte", Integer.toString(128));
        setting.setProperty("maxRuby", Integer.toString(16));
        setting.setProperty("readSpeed", Integer.toString(200));
        if (this.parent.saveProjectSetting(string, setting) < 0) {
            System.err.println(Resource.getString("MAKE_PROJECT_ERR"));
            this.cancel();
            return;
        }
        if (this.minifullApplRadioButton.isSelected()) {
            setting.setProperty("FullApp", ".." + File.separator + this.fullApplProjectName + File.separator + "bin" + File.separator + this.fullApplProjectName + ".jam");
            setting.setProperty("MiniApp", ".." + File.separator + this.miniApplProjectName + File.separator + "bin" + File.separator + this.miniApplProjectName + ".jam");
        }
        if (this.parent.saveProjectSetting(string, setting) < 0) {
            System.err.println(Resource.getString("MAKE_PROJECT_ERR"));
            this.cancel();
            return;
        }
        ADF aDF = new ADF();
        aDF.setProperty("PackageURL", string + ".jar");
        if (!this.bookmarkRadioButton.isSelected()) {
            aDF.setProperty("LastModified", this.getDate());
        }
        if (this.fullApplRadioButton.isSelected()) {
            aDF.setProperty("AppType", "FullApp");
        } else if (this.miniApplRadioButton.isSelected()) {
            aDF.setProperty("AppType", "MiniApp");
        } else if (this.bookmarkRadioButton.isSelected()) {
            aDF.setProperty("AppName", "");
            aDF.setProperty("BookmarkURL", "");
            aDF.setProperty("BookmarkAppURL", "");
            aDF.setProperty("BookmarkPreinType", "Java");
        } else {
            aDF.setProperty("AppType", "MiniApp,FullApp");
        }
        if (this.parent.saveProject(string, aDF) < 0) {
            System.err.println(Resource.getString("MAKE_PROJECT_ERR"));
            this.cancel();
            return;
        }
        SDF sDF = new SDF();
        sDF.setProperty("Sts", "0");
        String string2 = aDF.getProperty("PackageURL");
        sDF.setProperty("PackageURL", string2);
        sDF.parseSDF(aDF);
        if (this.parent.saveSdf(string, sDF) < 0) {
            System.err.println(Resource.getString("MAKE_PROJECT_ERR"));
            this.cancel();
            return;
        }
        this.parent.setProject(string, aDF, sDF);
        String string3 = this.parent.getProjectPath(string) + File.separator + "src";
        String string4 = this.parent.getProjectPath(string) + File.separator + "res";
        String string5 = this.parent.getProjectPath(string) + File.separator + "sp";
        if (this.bookmarkRadioButton.isSelected()) {
            string5 = null;
            string3 = null;
        }
        if (this.fullApplRadioButton.isSelected() || this.miniApplRadioButton.isSelected()) {
            File file = new File(string3);
            File file2 = new File(string4);
            File file3 = new File(string5);
            file.mkdirs();
            file2.mkdirs();
            file3.mkdirs();
            System.out.println(Resource.getString("FINISH_MAKE_PROJECT"));
            System.out.println(Resource.format("SRC_LOCATION", file.getPath()));
            System.out.println(Resource.format("RESOURCE_LOCATION", file2.getPath()));
            System.out.println(Resource.format("SP_LOCATION", file3.getPath()));
        } else if (this.bookmarkRadioButton.isSelected()) {
            File file = new File(string4);
            file.mkdirs();
            System.out.println(Resource.getString("FINISH_MAKE_PROJECT"));
            System.out.println(Resource.format("RESOURCE_LOCATION", file.getPath()));
        } else {
            File file = new File(string5);
            File file4 = new File(string4);
            file.mkdirs();
            file4.mkdirs();
            System.out.println(Resource.getString("FINISH_MAKE_PROJECT"));
            System.out.println(Resource.format("SP_LOCATION", file.getPath()));
            System.out.println(Resource.format("RESOURCE_LOCATION", file4.getPath()));
        }
        preProjectHome = projectHome;
        this.parent.setProjectHistory(projectHome, string);
        if (this.checkBox.isSelected()) {
            this.parent.makeSource(string);
        }
        this.parent.closeWindow(this);
    }

    void select() {
        JFileChooser jFileChooser = null;
        File file = new File(projectHome);
        jFileChooser = file.exists() ? new JFileChooser(projectHome) : new JFileChooser(System.getProperty("emu.home") + File.separator + "apps");
        jFileChooser.setDialogTitle(Resource.getString("PROJECT_HOME_DIALOG"));
        jFileChooser.setDialogType(2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(null);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.exists()) {
                file2 = new File(System.getProperty("emu.home") + File.separator + "apps");
            }
            projectHome = file2.getAbsolutePath();
            this.projectPathLabel.setText(projectHome);
            this.parent.setProjectHome(projectHome);
        }
    }

    void setPreProjectHome() {
        this.parent.setProjectHome(preProjectHome);
    }

    public void checkProjectName(String string) throws Exception {
        if (string.equals("")) {
            throw new Exception(Resource.getString("PROJECT_NAME_WNG"));
        }
        if (!new StringChecker(string).isFileName()) {
            throw new Exception(Resource.getString("PROJECT_NAME_WNG_ISFILENAME"));
        }
        if (this.parent.checkProjectExists(string)) {
            throw new Exception(Resource.format("EXIST_PROJECT_WNG", string));
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    void checkFullApplRadioButton() {
        if (this.fullApplRadioButton.isSelected()) {
            this.checkBox.setEnabled(true);
        }
    }

    void checkMiniApplRadioButton() {
        if (this.miniApplRadioButton.isSelected()) {
            this.checkBox.setEnabled(true);
        }
    }

    void checkMinifullApplRadioButton() {
        if (this.minifullApplRadioButton.isSelected()) {
            this.checkBox.setEnabled(false);
            this.checkBox.setSelected(false);
        }
    }

    void checkBookmarkRadioButton() {
        if (this.bookmarkRadioButton.isSelected()) {
            this.checkBox.setEnabled(false);
            this.checkBox.setSelected(false);
        }
    }

    void selectProject() {
        if (this.spw == null) {
            this.spw = new SelectProjectWindow(this);
            this.spw.setLocation(this.parent.getShowLocation(this.spw.getWidth(), this.spw.getHeight(), this.parent));
            this.spw.setVisible(true);
        }
    }

    void closeWindow() {
        if (this.spw != null) {
            this.spw.setVisible(false);
            this.spw.dispose();
            this.spw = null;
        }
    }

    public void setFullProjectName(String string) {
        this.fullApplProjectName = string;
    }

    public void setMiniProjectName(String string) {
        this.miniApplProjectName = string;
    }

    private String getDate() {
        int n = 60000;
        int n2 = 60 * n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Environment.getLocale());
        String string = simpleDateFormat.format(new Date());
        return string;
    }
}

