/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.Const;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public final class PedometerUtil {
    private static final int YEAR_MAX = 9999;
    private static final int YEAR_MIN = 1000;
    private static final int MONTH_MAX = 12;
    private static final int DAY_MAX = 31;
    private static final int DATE_MIN = 1;
    private static final File PEDOM_BASE_DIR = new File(Const.PATH_LIB_PEDOM);

    private PedometerUtil() {
    }

    public static Date parse(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n < 1000 || n > 9999) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("Illegal params.");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        if (n3 > gregorianCalendar.getActualMaximum(5)) {
            throw new IllegalArgumentException("Illegal params.");
        }
        gregorianCalendar.set(5, n3);
        return gregorianCalendar.getTime();
    }

    public static String dateToString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String[] getYMDStrings(String string) {
        String string2 = string.substring(0, 4);
        String string3 = string.substring(5, 7);
        String string4 = string.substring(8, 10);
        String[] stringArray = new String[]{string2, string3, string4};
        return stringArray;
    }

    public static boolean checkExists(String string) {
        File file = new File(PEDOM_BASE_DIR.getPath() + File.separator + string);
        return file.exists();
    }
}

