/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhysicalActivityBasicInfoWindows;
import com.nttdocomo.dojaemu.ktoolbar.PhysicalActivityEntry;
import com.nttdocomo.dojaemu.ktoolbar.PhysicalActivityExerciseWindows;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PhysicalActivityEditWindows
extends AbstractWindow {
    private JLabel lblDateYear = null;
    private JLabel lblDateMonth = null;
    private JLabel lblDateDay = null;
    private JLabel lblIntervalVal = null;
    private JButton settingButton = null;
    private JTable exerciseTable = null;
    private JScrollPane scrollpane = null;
    private JButton editButton = null;
    private JButton setButton = null;
    private JButton cancelButton = null;
    private JPanel centerPanel = null;
    private PhysicalActivityEntry entry = null;
    private Hashtable dispData = null;
    private String key = null;
    private static final int SCROLL_HEIGHT = 200;
    private static final int SCROLL_WIDTH = 400;
    private static final int FLOW_HGAP = 10;
    private static final int FLOW_VGAP = 10;
    private static final int ENABLED_WIDTH = 100;
    private static final int CMB_HEIGHT = 20;
    private static final int DATE_YEAR_WIDTH = 24;
    private static final int DATE_MONTH_WIDTH = 12;
    private static final int DATE_DAY_WIDTH = 12;

    public PhysicalActivityEditWindows(MainWindow mainWindow, PhysicalActivityEntry physicalActivityEntry, String string) {
        super(mainWindow, Resource.getString("PHYSICAL_EDIT_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.entry = physicalActivityEntry;
        this.key = string;
        Hashtable hashtable = this.entry.getData();
        this.dispData = this.key == null ? new Hashtable() : (hashtable.containsKey(this.key) ? (Hashtable)hashtable.get(this.key) : new Hashtable());
        this.addWindowListener();
        JPanel jPanel = new JPanel();
        this.centerPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("PHYSICAL_LBL_DATE"));
        JLabel jLabel2 = new JLabel(Resource.getString("YEAR"));
        JLabel jLabel3 = new JLabel(Resource.getString("MONTH"));
        JLabel jLabel4 = new JLabel(Resource.getString("DAY"));
        JLabel jLabel5 = new JLabel(Resource.getString("PHYSICAL_E_LBL_INTERVAL"));
        JLabel jLabel6 = new JLabel(Resource.getString("PHYSICAL_E_LBL_INTERVAL_UNIT"));
        this.lblDateYear = new JLabel();
        this.lblDateYear.setPreferredSize(new Dimension(24, 20));
        this.lblDateMonth = new JLabel();
        this.lblDateMonth.setPreferredSize(new Dimension(12, 20));
        this.lblDateDay = new JLabel();
        this.lblDateDay.setPreferredSize(new Dimension(12, 20));
        this.lblIntervalVal = new JLabel();
        this.lblIntervalVal.setPreferredSize(new Dimension(100, 20));
        this.exerciseTable = this.createPedometerTable();
        this.scrollpane = new JScrollPane(this.exerciseTable);
        this.scrollpane.setPreferredSize(new Dimension(400, 200));
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.settingButton = new JButton(Resource.getString("SET_UP"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.centerPanel.setLayout(new FlowLayout(1));
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel5.setLayout(new FlowLayout(0, 10, 10));
        jPanel6.setLayout(new FlowLayout(0, 10, 10));
        jPanel7.setLayout(new FlowLayout(0, 10, 10));
        jPanel8.setLayout(new FlowLayout(0, 10, 10));
        jPanel9.setLayout(new FlowLayout(1));
        jPanel10.setLayout(new FlowLayout(1));
        jPanel5.add(jLabel);
        jPanel6.add(jLabel5);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel7.add(this.lblDateYear);
        jPanel7.add(jLabel2);
        jPanel7.add(this.lblDateMonth);
        jPanel7.add(jLabel3);
        jPanel7.add(this.lblDateDay);
        jPanel7.add(jLabel4);
        jPanel8.add(this.lblIntervalVal);
        jPanel8.add(jLabel6);
        jPanel8.add(this.settingButton);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel.add("West", jPanel3);
        jPanel.add("Center", jPanel4);
        this.centerPanel.add(this.scrollpane);
        jPanel9.add(this.editButton);
        jPanel10.add(this.setButton);
        jPanel10.add(this.cancelButton);
        jPanel2.add(jPanel9);
        jPanel2.add(jPanel10);
        container.add("North", jPanel);
        container.add("Center", this.centerPanel);
        container.add("South", jPanel2);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        this.editButton.setActionCommand("edit");
        this.settingButton.setActionCommand("setting");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.settingButton.addActionListener(actionDispatcher);
        this.setDisplyData();
        this.changeEnabled();
        this.pack();
        this.setResizable(false);
    }

    private JTable createPedometerTable() {
        Object object;
        Object object2;
        JTable jTable = null;
        PhysicalTableModel physicalTableModel = null;
        String[] stringArray = new String[]{Resource.getString("PHYSICAL_E_LBL_TIME"), Resource.getString("PHYSICAL_E_LBL_EXERCISE"), Resource.getString("PHYSICAL_E_LBL_AEROBICS_EXERCISE")};
        physicalTableModel = new PhysicalTableModel(stringArray, 0);
        int n = 0;
        Object v = this.dispData.get("EXERCISESIZE");
        if (v != null && v instanceof Integer && (object2 = this.dispData.get("EXERCISE_DATA")) != null && object2 instanceof String[][]) {
            object = (String[][])object2;
            int n2 = PhysicalActivityEntry.getNumOfFilter();
            n = (Integer)v / n2;
            for (int i = 0; i < n; ++i) {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(object[i][0]);
                for (int j = 0; j < n2; ++j) {
                    vector.addElement(object[i][1 + j]);
                }
                physicalTableModel.addRow(vector);
            }
        }
        jTable = new JTable(physicalTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        object2 = jTable.getColumnModel().getColumn(0);
        ((TableColumn)object2).setMaxWidth(100);
        ((TableColumn)object2).setPreferredWidth(100);
        object = jTable.getColumnModel().getColumn(1);
        ((TableColumn)object).setMaxWidth(400);
        ((TableColumn)object).setPreferredWidth(400);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setMaxWidth(400);
        tableColumn.setPreferredWidth(400);
        jTable.setDefaultRenderer(Object.class, new PhysicalTableCellRenderer());
        jTable.setSelectionMode(0);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    PhysicalActivityEditWindows.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    PhysicalActivityEditWindows.this.edit();
                }
            }
        });
        return jTable;
    }

    private void setDisplyData() {
        if (this.key == null) {
            return;
        }
        Hashtable hashtable = this.entry.getData();
        if (hashtable.containsKey(this.key)) {
            String string = (String)this.dispData.get("YEAR");
            String string2 = (String)this.dispData.get("MONTH");
            String string3 = (String)this.dispData.get("DATE");
            String string4 = (String)this.dispData.get("INTERVAL");
            this.lblDateYear.setText(string);
            this.lblDateMonth.setText(string2);
            this.lblDateDay.setText(string3);
            this.lblIntervalVal.setText(string4);
        }
    }

    private void changeEnabled() {
        if (this.exerciseTable.getRowCount() > 0) {
            this.editButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
        }
        if (this.exerciseCheaker()) {
            this.setButton.setEnabled(true);
        } else {
            this.setButton.setEnabled(false);
        }
        if (this.key == null) {
            this.settingButton.setEnabled(true);
        } else {
            this.settingButton.setEnabled(false);
        }
    }

    public boolean set() {
        Hashtable<String, Hashtable> hashtable;
        if (!this.exerciseCheaker()) {
            return false;
        }
        if (this.key == null) {
            int n = this.entry.getCount();
            this.entry.setCount(++n);
            this.key = (String)this.dispData.get("EXERCISE_DATE");
        }
        if ((hashtable = this.entry.getData()) == null) {
            hashtable = new Hashtable<String, Hashtable>();
        }
        int n = this.exerciseTable.getRowCount();
        String string = null;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < PhysicalActivityEntry.getNumOfFilter(); ++j) {
                string = (String)this.exerciseTable.getValueAt(i, 1 + j);
                if (j == 0) {
                    f += Float.parseFloat(string);
                    continue;
                }
                if (j != 1) continue;
                f2 += Float.parseFloat(string);
            }
        }
        this.dispData.put("EXERCISE_GROSS", Float.toString(f));
        this.dispData.put("EXERCISE_AEROBICS_GROSS", Float.toString(f2));
        hashtable.put(this.key, this.dispData);
        this.entry.setData(hashtable);
        try {
            this.entry.save();
        }
        catch (IOException iOException) {
            this.parent.showDialog(Resource.format("WRITE_ERR", "physicalactivity.dat"), this, 2);
        }
        this.setVisible(false);
        this.dispose();
        return true;
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    public void edit() {
        if (this.exerciseTable.getSelectedRowCount() == 1) {
            int n = this.exerciseTable.getSelectedRow();
            String string = (String)this.exerciseTable.getValueAt(n, 0);
            String[] stringArray = new String[]{(String)this.exerciseTable.getValueAt(n, 1), (String)this.exerciseTable.getValueAt(n, 2)};
            PhysicalActivityExerciseWindows physicalActivityExerciseWindows = new PhysicalActivityExerciseWindows(this.parent, this.dispData, string, stringArray);
            physicalActivityExerciseWindows.setLocation(this.parent.getShowLocation(physicalActivityExerciseWindows.getWidth(), physicalActivityExerciseWindows.getHeight(), this));
            physicalActivityExerciseWindows.setVisible(true);
            this.setVisible(false);
            this.centerPanel.remove(this.scrollpane);
            this.scrollpane = null;
            this.exerciseTable = null;
            this.exerciseTable = this.createPedometerTable();
            this.scrollpane = new JScrollPane(this.exerciseTable);
            this.scrollpane.setPreferredSize(new Dimension(400, 200));
            this.centerPanel.add(this.scrollpane);
            this.changeEnabled();
            this.setVisible(true);
        }
    }

    public void setting() {
        if (this.key != null) {
            return;
        }
        PhysicalActivityBasicInfoWindows physicalActivityBasicInfoWindows = new PhysicalActivityBasicInfoWindows(this.parent, this.dispData, this.entry);
        physicalActivityBasicInfoWindows.setLocation(this.parent.getShowLocation(physicalActivityBasicInfoWindows.getWidth(), physicalActivityBasicInfoWindows.getHeight(), this));
        physicalActivityBasicInfoWindows.setVisible(true);
        this.setVisible(false);
        this.centerPanel.remove(this.scrollpane);
        this.scrollpane = null;
        this.exerciseTable = null;
        this.exerciseTable = this.createPedometerTable();
        this.scrollpane = new JScrollPane(this.exerciseTable);
        this.scrollpane.setPreferredSize(new Dimension(400, 200));
        this.centerPanel.add(this.scrollpane);
        Object v = this.dispData.get("YEAR");
        if (v != null && v instanceof String) {
            this.lblDateYear.setText((String)v);
        } else {
            this.lblDateYear.setText("");
        }
        Object v2 = this.dispData.get("MONTH");
        if (v2 != null && v2 instanceof String) {
            this.lblDateMonth.setText((String)v2);
        } else {
            this.lblDateMonth.setText("");
        }
        Object v3 = this.dispData.get("DATE");
        if (v3 != null && v3 instanceof String) {
            this.lblDateDay.setText((String)v3);
        } else {
            this.lblDateDay.setText("");
        }
        Object v4 = this.dispData.get("INTERVAL");
        if (v4 != null && v4 instanceof String) {
            this.lblIntervalVal.setText((String)v4);
        } else {
            this.lblIntervalVal.setText("");
        }
        this.changeEnabled();
        this.setVisible(true);
    }

    private boolean exerciseCheaker() {
        Object v = this.dispData.get("EXERCISESIZE");
        return v != null && v instanceof Integer;
    }

    class PhysicalTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        PhysicalTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class PhysicalTableModel
    extends DefaultTableModel {
        PhysicalTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

