/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;

public class PhysicalActivityEntry {
    public static final String SECTION_KEY_MONITOR = "PHYSICALACTIVITYMONITOR";
    public static final String SECTION_KEY_DATA = "PHYSICALACTIVITYDATA_";
    public static final String S_KEY_MONITOR_COUNT = "COUNT";
    public static final String S_KEY_MONITOR_METS = "METS";
    public static final String S_KEY_MONITOR_LIMIT = "LIMIT";
    public static final String S_KEY_DATA_YEAR = "YEAR";
    public static final String S_KEY_DATA_MONTH = "MONTH";
    public static final String S_KEY_DATA_DAY = "DATE";
    public static final String I_KEY_DATA_SIZE = "EXERCISESIZE";
    public static final String S_KEY_DATA_GROSS = "EXERCISE_GROSS";
    public static final String S_KEY_DATA_AEROB_GROSS = "EXERCISE_AEROBICS_GROSS";
    public static final String S_KEY_DATA_INTERVAL = "INTERVAL";
    public static final String S_KEY_DATA_EXERCISE = "EXERCISE_";
    public static final String S_KEY_DATA_DATE = "EXERCISE_DATE";
    public static final String KEY_EXERCISE_DATA = "EXERCISE_DATA";
    public static final String PHYSICAL_ACTIVITY_DAT = "physicalactivity.dat";
    private static final String PHYSICAL_ACTIVITY_PATH = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "physicalactivity.dat";
    public static final int FILTER_NONE = 0;
    public static final int FILTER_AEROBICS = 1;
    public static final int SUPPORTED_FILTER = 1;
    private static final String PHYSICAL_ACTIVITY_METS = "1.5";
    private static final int PHYSICAL_ACTIVITY_COUNT = 0;
    private static final int PHYSICAL_ACTIVITY_LIMIT = 1;
    private String mets = "1.5";
    private int count = 0;
    private int limit = 1;
    private Hashtable data = null;

    public String getMETs() {
        return this.mets;
    }

    public void setMETs(String string) {
        this.mets = string;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public static int getNumOfFilter() {
        int n = 1;
        for (int i = 0; i < 32; ++i) {
            if ((1 >> i & 1) != 1) continue;
            ++n;
        }
        return n;
    }

    public Hashtable getData() {
        return this.data;
    }

    public void setData(Hashtable hashtable) {
        this.data = hashtable;
    }

    public void load() throws IOException {
        IniFileEntity iniFileEntity = new IniFileEntity(PHYSICAL_ACTIVITY_PATH);
        iniFileEntity.read();
        String string = iniFileEntity.getSectionAttribute(SECTION_KEY_MONITOR, S_KEY_MONITOR_METS);
        if (string == null || string.length() == 0) {
            string = PHYSICAL_ACTIVITY_METS;
        }
        try {
            Float.parseFloat(string);
        }
        catch (Exception exception) {
            string = "";
        }
        this.mets = string;
        this.count = iniFileEntity.getSectionAttributeInt(SECTION_KEY_MONITOR, S_KEY_MONITOR_COUNT, 0);
        if (this.count <= 0) {
            return;
        }
        this.limit = iniFileEntity.getSectionAttributeInt(SECTION_KEY_MONITOR, S_KEY_MONITOR_LIMIT, 1);
        this.data = new Hashtable();
        Hashtable<String, Object> hashtable = null;
        Calendar calendar = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm");
        for (int i = 0; i < this.count; ++i) {
            hashtable = new Hashtable<String, Object>();
            try {
                String string2 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_YEAR);
                String string3 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_MONTH);
                String string4 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_DAY);
                calendar = Calendar.getInstance();
                calendar.set(Integer.parseInt(string2), Integer.parseInt(string3) - 1, Integer.parseInt(string4), 0, 0);
                String string5 = simpleDateFormat.format(calendar.getTime());
                hashtable.put(S_KEY_DATA_DATE, string5);
                hashtable.put(S_KEY_DATA_YEAR, string2);
                hashtable.put(S_KEY_DATA_MONTH, string3);
                hashtable.put(S_KEY_DATA_DAY, string4);
                String string6 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_GROSS);
                hashtable.put(S_KEY_DATA_GROSS, string6);
                String string7 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_AEROB_GROSS);
                if (string7 == null) {
                    string7 = "0.0";
                }
                hashtable.put(S_KEY_DATA_AEROB_GROSS, string7);
                String string8 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_INTERVAL);
                int n = 0;
                n = Integer.parseInt(string8);
                hashtable.put(S_KEY_DATA_INTERVAL, string8);
                String string9 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), I_KEY_DATA_SIZE);
                int n2 = 0;
                n2 = Integer.parseInt(string9);
                int n3 = PhysicalActivityEntry.getNumOfFilter();
                int n4 = 86400 / n * n3;
                if (n4 != n2) {
                    n2 = n4;
                }
                hashtable.put(I_KEY_DATA_SIZE, new Integer(n2));
                String[][] stringArray = new String[n2 / n3][1 + n3];
                for (int j = 0; j < n2 / n3; ++j) {
                    stringArray[j][0] = simpleDateFormat2.format(calendar.getTime());
                    for (int k = 0; k < n3; ++k) {
                        String string10 = iniFileEntity.getSectionAttribute(SECTION_KEY_DATA + (i + 1), S_KEY_DATA_EXERCISE + (k * (n2 / n3) + j + 1));
                        if (string10 == null) {
                            string10 = "0";
                        }
                        stringArray[j][1 + k] = string10;
                    }
                    calendar.add(13, n);
                }
                hashtable.put(KEY_EXERCISE_DATA, stringArray);
                this.data.put(string5, hashtable);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() throws IOException {
        IniFileEntity iniFileEntity = new IniFileEntity(PHYSICAL_ACTIVITY_PATH);
        int n = 1;
        if (this.count > 0) {
            ArrayList arrayList = this.sort();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Hashtable hashtable = (Hashtable)this.data.get(arrayList.get(i));
                String[][] stringArray = (String[][])hashtable.get(KEY_EXERCISE_DATA);
                String string = (String)hashtable.get(S_KEY_DATA_YEAR);
                String string2 = (String)hashtable.get(S_KEY_DATA_MONTH);
                String string3 = (String)hashtable.get(S_KEY_DATA_DAY);
                Integer n2 = (Integer)hashtable.get(I_KEY_DATA_SIZE);
                String string4 = (String)hashtable.get(S_KEY_DATA_GROSS);
                String string5 = (String)hashtable.get(S_KEY_DATA_AEROB_GROSS);
                String string6 = (String)hashtable.get(S_KEY_DATA_INTERVAL);
                iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + n, S_KEY_DATA_GROSS, string4);
                iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + n, S_KEY_DATA_AEROB_GROSS, string5);
                iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + n, S_KEY_DATA_INTERVAL, string6);
                iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + n, S_KEY_DATA_YEAR, string);
                iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + n, S_KEY_DATA_MONTH, string2);
                iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + n, S_KEY_DATA_DAY, string3);
                iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + n, I_KEY_DATA_SIZE, n2.toString());
                int n3 = PhysicalActivityEntry.getNumOfFilter();
                int n4 = 1;
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n2 / n3; ++k) {
                        iniFileEntity.setSectionAttribute(SECTION_KEY_DATA + n, S_KEY_DATA_EXERCISE + n4, stringArray[k][1 + j]);
                        ++n4;
                    }
                }
                ++n;
            }
        }
        iniFileEntity.setSectionAttribute(SECTION_KEY_MONITOR, S_KEY_MONITOR_METS, this.mets);
        iniFileEntity.setSectionAttribute(SECTION_KEY_MONITOR, S_KEY_MONITOR_COUNT, Integer.toString(n - 1));
        iniFileEntity.setSectionAttribute(SECTION_KEY_MONITOR, S_KEY_MONITOR_LIMIT, Integer.toString(this.limit));
        iniFileEntity.save();
    }

    public void delete(String string) throws IOException {
        this.data.remove(string);
        int n = this.getCount();
        this.setCount(--n);
        this.save();
    }

    public ArrayList sort() {
        ArrayList arrayList = new ArrayList(this.data.keySet());
        Collections.sort(arrayList, new DataComparator());
        return arrayList;
    }

    class DataComparator
    implements Comparator {
        DataComparator() {
        }

        public int compare(Object object, Object object2) {
            Date date;
            Date date2;
            if (!(object instanceof String) || !(object2 instanceof String)) {
                return 0;
            }
            String string = (String)object;
            String string2 = (String)object2;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            try {
                date2 = simpleDateFormat.parse(string);
                date = simpleDateFormat.parse(string2);
            }
            catch (Exception exception) {
                return 0;
            }
            return date.compareTo(date2);
        }
    }
}

