/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;

public class PhysicalActivityExerciseWindows
extends AbstractWindow {
    private static final int EXERCISE_MAX = 100;
    private static final int EXERCISE_DEC_POINT = 5;
    private static final int BUTTON_PANEL_HEIGHT = 45;
    private static final int BUTTON_PANEL_WIDTH = 200;
    private static final int TXT_INPUT_MAX = 8;
    private static final int TXT_FIELD_WIDTH = 12;
    private static final int FLOW_HGAP = 20;
    private static final int FLOW_VGAP = 5;
    private JTextField txtExercise = null;
    private JTextField txtExercise2 = null;
    private JButton setButton = null;
    private JButton cancelButton = null;
    private Hashtable entry = null;
    private String time = null;

    public PhysicalActivityExerciseWindows(MainWindow mainWindow, Hashtable hashtable, String string, String[] stringArray) {
        super(mainWindow, Resource.getString("PHYSICAL_EXERCISE_EDIT_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.entry = hashtable;
        this.time = string;
        this.addWindowListener();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel5.setPreferredSize(new Dimension(200, 45));
        JLabel jLabel = new JLabel(Resource.getString("PHYSICAL_EX_LBL_EXERCISE"));
        JLabel jLabel2 = new JLabel(Resource.getString("PHYSICAL_EX_LBL_AEROBICS_EXERCISE"));
        JLabel jLabel3 = new JLabel(Resource.getString("PHYSICAL_EX_LBL_EXERCISE_UNIT"));
        JLabel jLabel4 = new JLabel(Resource.getString("PHYSICAL_EX_LBL_EXERCISE_UNIT"));
        this.txtExercise = new JTextField(12);
        this.txtExercise.setDocument(new NumberFormatDocument(8));
        this.txtExercise.setText(stringArray[0]);
        this.txtExercise2 = new JTextField(12);
        this.txtExercise2.setDocument(new NumberFormatDocument(8));
        this.txtExercise2.setText(stringArray[1]);
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel.setLayout(new FlowLayout(0, 20, 5));
        jPanel3.setLayout(new FlowLayout(0, 20, 5));
        jPanel.add(jLabel);
        jPanel2.add(this.txtExercise);
        jPanel2.add(jLabel3);
        jPanel3.add(jLabel2);
        jPanel4.add(this.txtExercise2);
        jPanel4.add(jLabel4);
        jPanel5.add(this.setButton);
        jPanel5.add(this.cancelButton);
        container.add(jPanel);
        container.add(jPanel2);
        container.add(jPanel3);
        container.add(jPanel4);
        container.add(jPanel5);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.pack();
    }

    public boolean set() {
        if (!this.inputCheaker()) {
            return false;
        }
        String string = this.txtExercise.getText();
        String string2 = this.txtExercise2.getText();
        Object v = this.entry.get("EXERCISE_DATA");
        String[][] stringArray = (String[][])v;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.time.compareTo(stringArray[i][0]) != 0) continue;
            stringArray[i][1] = string;
            stringArray[i][2] = string2;
            break;
        }
        this.entry.put("EXERCISE_DATA", stringArray);
        this.setVisible(false);
        this.dispose();
        return true;
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean inputCheaker() {
        String[] stringArray = new String[]{this.txtExercise.getText(), this.txtExercise2.getText()};
        String[] stringArray2 = new String[]{Resource.getString("PHYSICAL_EX_LBL_EXERCISE"), Resource.getString("PHYSICAL_EX_LBL_AEROBICS_EXERCISE")};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0) {
                this.parent.showDialog(Resource.format("PHYSICAL_VAL_NOT_INPUT_WNG", stringArray2[i]), this, 2);
                return false;
            }
            int n = stringArray[i].indexOf(".");
            if (n > 0 && stringArray[i].substring(n + 1).length() > 5) {
                this.parent.showDialog(Resource.format("PHYSICAL_VAL_OUTSIDE_WNG", stringArray2[i]), this, 2);
                return false;
            }
            boolean bl = false;
            try {
                Float f = Float.valueOf(stringArray[i]);
                if (f.floatValue() < 0.0f || f.floatValue() >= 100.0f) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (!bl) continue;
            this.parent.showDialog(Resource.format("PHYSICAL_VAL_OUTSIDE_WNG", stringArray2[i]), this, 2);
            return false;
        }
        return true;
    }

    class NumberFormatDocument
    extends PlainDocument {
        private int maxLen;

        public NumberFormatDocument(int n) {
            this.maxLen = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                super.insertString(n, string, attributeSet);
                return;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '.' || string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
                return;
            }
            if (this.maxLen - 1 < this.getLength()) {
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

