/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhysicalActivityEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;

public class PhysicalActivityMetsWindows
extends AbstractWindow {
    private static final int METS_MAX = 100;
    private static final int METS_DEC_POINT = 5;
    private static final int BUTTON_PANEL_HEIGHT = 35;
    private static final int BUTTON_PANEL_WIDTH = 165;
    private static final int TXT_INPUT_MAX = 8;
    private static final int TXT_FIELD_WIDTH = 12;
    private JTextField txtMETs = null;
    private JButton setButton;
    private JButton cancelButton;
    private PhysicalActivityEntry entry = null;

    public PhysicalActivityMetsWindows(MainWindow mainWindow, PhysicalActivityEntry physicalActivityEntry) {
        super(mainWindow, Resource.getString("PHYSICAL_METS_EDIT_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.entry = physicalActivityEntry;
        this.addWindowListener();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setPreferredSize(new Dimension(165, 35));
        JLabel jLabel = new JLabel(Resource.getString("PHYSICAL_LBL_METS"));
        JLabel jLabel2 = new JLabel(Resource.getString("PHYSICAL_LBL_METS_UNIT"));
        this.txtMETs = new JTextField(12);
        this.txtMETs.setDocument(new NumberFormatDocument(8));
        this.txtMETs.setText(this.entry.getMETs());
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel.add(jLabel);
        jPanel2.add(this.txtMETs);
        jPanel2.add(jLabel2);
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        jPanel4.add(this.setButton);
        jPanel4.add(this.cancelButton);
        container.add(jPanel3);
        container.add(jPanel4);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    public boolean set() {
        if (!this.inputCheaker()) {
            return false;
        }
        String string = this.txtMETs.getText();
        this.entry.setMETs(string);
        try {
            this.entry.save();
        }
        catch (IOException iOException) {
            this.parent.showDialog(Resource.format("WRITE_ERR", "physicalactivity.dat"), this, 2);
        }
        this.setVisible(false);
        this.dispose();
        return true;
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean inputCheaker() {
        String string = this.txtMETs.getText();
        if (string == null || string.length() == 0) {
            this.parent.showDialog(Resource.format("PHYSICAL_VAL_NOT_INPUT_WNG", Resource.getString("PHYSICAL_LBL_METS")), this, 2);
            return false;
        }
        int n = string.indexOf(".");
        if (n > 0 && string.substring(n + 1).length() > 5) {
            this.parent.showDialog(Resource.format("PHYSICAL_VAL_OUTSIDE_WNG", Resource.getString("PHYSICAL_LBL_METS")), this, 2);
            return false;
        }
        boolean bl = false;
        try {
            Float f = Float.valueOf(string);
            if (f.floatValue() < 0.0f || f.floatValue() >= 100.0f) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl) {
            this.parent.showDialog(Resource.format("PHYSICAL_VAL_OUTSIDE_WNG", Resource.getString("PHYSICAL_LBL_METS")), this, 2);
            return false;
        }
        return true;
    }

    class NumberFormatDocument
    extends PlainDocument {
        private int maxLen;

        public NumberFormatDocument(int n) {
            this.maxLen = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                super.insertString(n, string, attributeSet);
                return;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '.' || string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
                return;
            }
            if (this.maxLen - 1 < this.getLength()) {
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

