/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.PhysicalActivityEditWindows;
import com.nttdocomo.dojaemu.ktoolbar.PhysicalActivityEntry;
import com.nttdocomo.dojaemu.ktoolbar.PhysicalActivityMetsWindows;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PhysicalActivityWindows
extends TabPanel {
    private static final int GRID_COUNT_COL = 8;
    private static final int GRID_COUNT_ROW = 1;
    private JTable physicalActivityTable;
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton setButton;
    private JLabel lblMetsData;
    private static final int ENABLED_WIDTH = 100;
    private PhysicalActivityEntry pae = null;

    PhysicalActivityWindows(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("PHYSICAL_LBL_METS"));
        this.lblMetsData = new JLabel();
        JLabel jLabel2 = new JLabel(Resource.getString("PHYSICAL_LBL_METS_UNIT"));
        this.pae = new PhysicalActivityEntry();
        try {
            this.pae.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lblMetsData.setText(this.pae.getMETs());
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.setButton = new JButton(Resource.getString("SET_UP"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        this.setButton.setActionCommand("setting");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.setButton.addActionListener(actionDispatcher);
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), ""));
        jPanel2.setLayout(new GridLayout(1, 8));
        jPanel2.add(new JLabel(""));
        jPanel2.add(jLabel);
        jPanel2.add(new JLabel(""));
        jPanel2.add(this.lblMetsData);
        jPanel2.add(jLabel2);
        jPanel2.add(new JLabel(""));
        jPanel2.add(this.setButton);
        jPanel2.add(new JLabel(""));
        jPanel.add(this.addButton);
        jPanel.add(this.editButton);
        jPanel.add(this.deleteButton);
        this.physicalActivityTable = this.createPhysicalActivityTable();
        this.scrollpane = new JScrollPane(this.physicalActivityTable);
        this.changeButtonEnabled();
        this.add("North", jPanel2);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel);
    }

    private JTable createPhysicalActivityTable() {
        Serializable serializable;
        JTable jTable = null;
        PhysicalTableModel physicalTableModel = null;
        String[] stringArray = new String[]{Resource.getString("PHYSICAL_LBL_DATE"), Resource.getString("PHYSICAL_LBL_INTERVAL"), Resource.getString("PHYSICAL_LBL_EXERCISE"), Resource.getString("PHYSICAL_LBL_AEROBICS_EXERCISE")};
        physicalTableModel = new PhysicalTableModel(stringArray, 0);
        if (this.pae.getCount() > 0) {
            serializable = this.pae.getData();
            ArrayList arrayList = this.pae.sort();
            for (int i = 0; i < arrayList.size(); ++i) {
                Vector vector = new Vector();
                Hashtable hashtable = (Hashtable)((Hashtable)serializable).get(arrayList.get(i));
                vector.addElement(hashtable.get("EXERCISE_DATE"));
                vector.addElement(hashtable.get("INTERVAL"));
                vector.addElement(hashtable.get("EXERCISE_GROSS"));
                vector.addElement(hashtable.get("EXERCISE_AEROBICS_GROSS"));
                physicalTableModel.addRow(vector);
            }
        }
        jTable = new JTable(physicalTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        serializable = jTable.getColumnModel().getColumn(0);
        ((TableColumn)serializable).setMaxWidth(100);
        ((TableColumn)serializable).setPreferredWidth(100);
        jTable.setDefaultRenderer(Object.class, new PhysicalTableCellRenderer());
        jTable.setSelectionMode(0);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    PhysicalActivityWindows.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    PhysicalActivityWindows.this.edit();
                }
            }
        });
        return jTable;
    }

    public void add() {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        PhysicalActivityEditWindows physicalActivityEditWindows = new PhysicalActivityEditWindows(this.parent, this.pae, null);
        physicalActivityEditWindows.setLocation(this.parent.getShowLocation(physicalActivityEditWindows.getWidth(), physicalActivityEditWindows.getHeight(), this.tabwin));
        physicalActivityEditWindows.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.physicalActivityTable = null;
        this.physicalActivityTable = this.createPhysicalActivityTable();
        this.scrollpane = new JScrollPane(this.physicalActivityTable);
        this.add("Center", this.scrollpane);
        this.changeButtonEnabled();
        this.setVisible(true);
    }

    public void edit() {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        if (this.physicalActivityTable.getSelectedRowCount() == 1) {
            int n = this.physicalActivityTable.getSelectedRow();
            String string = (String)this.physicalActivityTable.getValueAt(n, 0);
            PhysicalActivityEditWindows physicalActivityEditWindows = new PhysicalActivityEditWindows(this.parent, this.pae, string);
            physicalActivityEditWindows.setLocation(this.parent.getShowLocation(physicalActivityEditWindows.getWidth(), physicalActivityEditWindows.getHeight(), this.tabwin));
            physicalActivityEditWindows.setVisible(true);
            this.pae = new PhysicalActivityEntry();
            try {
                this.pae.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.physicalActivityTable = null;
            this.physicalActivityTable = this.createPhysicalActivityTable();
            this.scrollpane = new JScrollPane(this.physicalActivityTable);
            this.add("Center", this.scrollpane);
            this.changeButtonEnabled();
            this.setVisible(true);
        }
    }

    public void delete() {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        if (this.physicalActivityTable.getSelectedRowCount() == 1) {
            int n = this.physicalActivityTable.getSelectedRow();
            int n2 = JOptionPane.showConfirmDialog(this, Resource.getString("PHYSICAL_DELETE_WNG"), Resource.getString("CONFIRM"), 0);
            if (n2 == 0) {
                String string = (String)this.physicalActivityTable.getValueAt(n, 0);
                try {
                    this.pae.delete(string);
                }
                catch (IOException iOException) {
                    this.parent.showDialog(Resource.format("WRITE_ERR", "physicalactivity.dat"), this, 2);
                }
                this.pae = new PhysicalActivityEntry();
                try {
                    this.pae.load();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.physicalActivityTable = null;
                this.physicalActivityTable = this.createPhysicalActivityTable();
                this.scrollpane = new JScrollPane(this.physicalActivityTable);
                this.add("Center", this.scrollpane);
                this.changeButtonEnabled();
                this.setVisible(true);
            }
        }
    }

    public void setting() {
        PhysicalActivityMetsWindows physicalActivityMetsWindows = new PhysicalActivityMetsWindows(this.parent, this.pae);
        physicalActivityMetsWindows.setLocation(this.parent.getShowLocation(physicalActivityMetsWindows.getWidth(), physicalActivityMetsWindows.getHeight(), this.tabwin));
        physicalActivityMetsWindows.setVisible(true);
        this.setVisible(false);
        this.pae = new PhysicalActivityEntry();
        try {
            this.pae.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lblMetsData.setText(this.pae.getMETs());
        this.setVisible(true);
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.physicalActivityTable.getRowCount() == 0) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    public void addRow(final JTable jTable, final Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jTable != null && PhysicalActivityWindows.this.physicalActivityTable != null && jTable.equals(PhysicalActivityWindows.this.physicalActivityTable)) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                    defaultTableModel.addRow(objectArray);
                }
            }
        });
    }

    class PhysicalTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        PhysicalTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class PhysicalTableModel
    extends DefaultTableModel {
        PhysicalTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

