/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow2;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsBean;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsManager;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistBean;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistManager;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicAbstractWindowWindowListener;
import com.nttdocomo.dojaemu.ktoolbar.swing.EditWindowInterface;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTableUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTextFieldUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.WidthBean;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.WindowsFilenameDocument;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class PlaylistEditWindow
extends AbstractWindow2
implements EditWindowInterface {
    private PlaylistWindow pw;
    private static final GridLayout GRID_LAYOUT = new GridLayout(4, 1);
    private JPanel panelPlaylistContents;
    private JTableUtil jtuPlaylist;
    private JTableUtil jtuMusicContents;
    private static final int SIZE_TEXTFIELD = 30;
    private JTextField txtPlaylistName;
    private JScrollPane scrollPanePlaylistContents;
    private JTable tablePlaylist;
    private JTable tableMusicContents;
    private JScrollPane scrollPaneMusicContents;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JButton buttonSet;
    private JButton buttonCancel;
    private PlaylistBean playlistBean = null;
    private List<MusicContentsBean> musicContentsBeanList = null;
    private static final int COLUMN_WIDTH = 100;
    private static final int DIMENSION_WIDTH = 200;
    private static final int DIMENSION_HEIGHT = 300;

    public PlaylistEditWindow(MainWindow mainWindow, PlaylistWindow playlistWindow) {
        this(mainWindow, playlistWindow, new PlaylistBean(""));
    }

    public PlaylistEditWindow(MainWindow mainWindow, PlaylistWindow playlistWindow, PlaylistBean playlistBean) {
        super(mainWindow, Resource.getString("MusicPlayer.common.caption.playlistEditWindow"));
        this.parent = mainWindow;
        this.playlistBean = playlistBean;
        this.playlistEditWindow(playlistWindow);
    }

    private void playlistEditWindow(PlaylistWindow playlistWindow) {
        this.pw = playlistWindow;
        this.setResizable(false);
        this.addWindowListener(new BasicAbstractWindowWindowListener(this.parent, this){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PlaylistEditWindow.this.cancel();
            }
        });
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(Resource.getString("MusicPlayer.common.caption.playlistName"));
        this.txtPlaylistName = JTextFieldUtil.createBasicTextField(30, new WindowsFilenameDocument(215 - ".properties".length(), false));
        jPanel2.add(jLabel);
        jPanel3.add(this.txtPlaylistName);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JLabel jLabel2 = new JLabel(" ");
        JLabel jLabel3 = new JLabel(Resource.getString("MusicPlayer.common.caption.playlistContents"));
        JLabel jLabel4 = new JLabel("                                                     ");
        JLabel jLabel5 = new JLabel(Resource.getString("MusicPlayer.common.caption.musicContents"));
        jPanel4.add(jLabel2);
        jPanel4.add(jLabel3);
        jPanel4.add(jLabel4);
        jPanel4.add(jLabel5);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        try {
            if (!"".equals(this.playlistBean.getFileName())) {
                this.playlistBean = PlaylistManager.read(this.playlistBean);
            } else {
                this.playlistBean.createMcbList();
            }
        }
        catch (Exception exception) {
            System.err.println(Resource.format("READ_ERR", this.playlistBean.getFileName()));
        }
        this.panelPlaylistContents = new JPanel(new FlowLayout(0));
        this.createPlaylistTable();
        this.panelPlaylistContents.add("Center", this.scrollPanePlaylistContents);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        this.buttonAdd = JButtonUtil.createBasicButton(Resource.getString("MusicPlayer.common.caption.musicContentsAdd"), "add", actionDispatcher2);
        jPanel7.add(this.buttonAdd);
        this.buttonRemove = JButtonUtil.createBasicButton(Resource.getString("MusicPlayer.common.caption.musicContentsRemove"), "remove", actionDispatcher2);
        jPanel10.add(this.buttonRemove);
        jPanel8.add(new JLabel("  "));
        jPanel9.add(new JLabel("  "));
        jPanel6 = new JPanel(GRID_LAYOUT);
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel8);
        jPanel6.add(jPanel9);
        jPanel6.add(jPanel10);
        this.musicContentsBeanList = MusicContentsManager.allContentsRead();
        JPanel jPanel11 = new JPanel(new FlowLayout(0));
        this.createMusicContentsTable();
        jPanel11.add("Center", this.scrollPaneMusicContents);
        jPanel5.add(this.panelPlaylistContents);
        jPanel5.add(jPanel6);
        jPanel5.add(jPanel11);
        JPanel jPanel12 = new JPanel();
        this.buttonSet = JButtonUtil.createBasicButton(Resource.getString("SET"), "set", actionDispatcher2);
        jPanel12.add(this.buttonSet);
        this.buttonCancel = JButtonUtil.createBasicButton(Resource.getString("CANCEL"), "cancel", actionDispatcher2);
        jPanel12.add(this.buttonCancel);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel);
        container.add(jPanel4);
        container.add(jPanel5);
        container.add(jPanel12);
        this.pack();
        try {
            this.txtPlaylistName.setText(PlaylistManager.getPlaylistFileNameWithoutExt(this.playlistBean.getFileName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Vector<String>> convertData(PlaylistBean playlistBean) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (int i = 0; i < playlistBean.getMcbList().size(); ++i) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(playlistBean.getMcbList().get(i).getTitle());
            try {
                vector.addElement(MusicContentsManager.getMusicFileNameWithoutExt(playlistBean.getMcbList().get(i).getFileName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            arrayList.add(vector);
        }
        return arrayList;
    }

    private List<Vector<String>> convertData(List<MusicContentsBean> list) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (int i = 0; i < list.size(); ++i) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(list.get(i).getTitle());
            try {
                vector.addElement(MusicContentsManager.getMusicFileNameWithoutExt(list.get(i).getFileName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.addElement(list.get(i).getArtist());
            vector.addElement(list.get(i).getAlbum());
            vector.addElement(list.get(i).getGenre());
            arrayList.add(vector);
        }
        return arrayList;
    }

    private void createPlaylistTable() {
        String[] stringArray = new String[]{Resource.getString("MusicPlayer.common.caption.title"), Resource.getString("MusicPlayer.common.caption.filename")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(100, 100));
        this.jtuPlaylist = new JTableUtil();
        this.tablePlaylist = this.jtuPlaylist.createBasicTable(stringArray, arrayList, 0, this.convertData(this.playlistBean));
        this.scrollPanePlaylistContents = JTableUtil.createBasicScrollPane(this.tablePlaylist, 200, 300);
    }

    private void createMusicContentsTable() {
        String[] stringArray = new String[]{Resource.getString("MusicPlayer.common.caption.title"), Resource.getString("MusicPlayer.common.caption.filename")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(100, 100));
        this.jtuMusicContents = new JTableUtil();
        this.tableMusicContents = this.jtuMusicContents.createBasicTable(stringArray, arrayList, 0, this.convertData(this.musicContentsBeanList));
        this.scrollPaneMusicContents = JTableUtil.createBasicScrollPane(this.tableMusicContents, 200, 300);
    }

    private void updatePlaylistTable() {
        this.setVisible(false);
        this.panelPlaylistContents.remove(this.scrollPanePlaylistContents);
        this.tablePlaylist = this.jtuPlaylist.updateBasicTable(this.convertData(this.playlistBean));
        this.scrollPanePlaylistContents = JTableUtil.createBasicScrollPane(this.tablePlaylist, 200, 300);
        this.panelPlaylistContents.add("Center", this.scrollPanePlaylistContents);
        this.setVisible(true);
    }

    void add() {
        int[] nArray = this.tableMusicContents.getSelectedRows();
        if (this.tableMusicContents.getSelectedRowCount() == 1) {
            MusicContentsBean musicContentsBean = this.musicContentsBeanList.get(nArray[0]);
            this.playlistBean.addMcbList(musicContentsBean);
            this.updatePlaylistTable();
        }
    }

    void remove() {
        int[] nArray = this.tablePlaylist.getSelectedRows();
        if (this.tablePlaylist.getSelectedRowCount() == 1) {
            this.playlistBean.removeMcbList(nArray[0]);
            this.updatePlaylistTable();
        }
    }

    @Override
    public void checkInput() throws Exception {
        if ("".equals(this.txtPlaylistName.getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("MusicPlayer.common.caption.playlistName")));
        }
        if (this.playlistBean.getMcbList().size() == 0) {
            throw new Exception(Resource.format("MusicPlayer.common.message.set.warn.playlist.contentsNothing", Resource.getString("MusicPlayer.common.caption.playlistContents")));
        }
    }

    @Override
    public void checkFormat() throws Exception {
        if (this.txtPlaylistName.getText().getBytes().length > 215 - ".properties".length()) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.playlistName")));
        }
        if (!WindowsFilenameDocument.isFileNameFormat(this.txtPlaylistName.getText(), false)) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.playlistName")));
        }
    }

    void set() {
        try {
            this.checkInput();
            this.checkFormat();
            String string = PlaylistManager.getPlaylistFileNameWithExt(this.txtPlaylistName.getText());
            if (!this.playlistBean.getOriginalFileName().equals(string)) {
                for (PlaylistBean playlistBean : this.pw.getPlaylistBeanList()) {
                    if (!playlistBean.getFileName().equals(string)) continue;
                    throw new Exception(Resource.getString("MusicPlayer.common.message.set.warn.playlist.duplication"));
                }
            }
            this.playlistBean.setFileName(PlaylistManager.getPlaylistFileNameWithExt(this.txtPlaylistName.getText()));
            try {
                if (this.playlistBean.isFilenameChanged()) {
                    PlaylistManager.rename(this.playlistBean);
                }
                PlaylistManager.write(this.playlistBean);
                this.playlistBean.updateOriginalFileName();
            }
            catch (Exception exception) {
                System.err.println(Resource.format("WRITE_ERR", this.playlistBean.getFileName()));
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            this.parent.showDialog(exception.getMessage(), this, 2);
        }
    }

    void cancel() {
        this.playlistBean = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.playlistBean == null;
    }

    public PlaylistBean getPlaylistBean() {
        return this.playlistBean;
    }
}

