/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsBean;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsManager;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistBean;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistFileReader;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistFileRecord;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistFileWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class PlaylistManager {
    private static final String PLAYLIST_FILE_EXT = ".dat";

    private PlaylistManager() {
    }

    public static PlaylistBean read(PlaylistBean playlistBean) throws Exception {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        PlaylistFileReader playlistFileReader = null;
        try {
            PlaylistFileRecord playlistFileRecord;
            inputStreamReader = new FileReader(Const.PATH_LIB_AVPLAYER_PLAYLIST + playlistBean.getFileName());
            bufferedReader = new BufferedReader(inputStreamReader);
            playlistFileReader = new PlaylistFileReader(bufferedReader);
            playlistBean.createMcbList();
            while ((playlistFileRecord = playlistFileReader.readRecord()) != null) {
                MusicContentsBean musicContentsBean = new MusicContentsBean(playlistFileRecord.getFileName());
                if ((musicContentsBean = MusicContentsManager.read(musicContentsBean)) == null) continue;
                playlistBean.addMcbList(musicContentsBean);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = new File(Const.PATH_LIB_AVPLAYER_PLAYLIST + playlistBean.getFileName());
            boolean bl = false;
            bl = file.createNewFile();
            if (!bl) {
                throw new Exception();
            }
            playlistBean.createMcbList();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                playlistFileReader.close();
                bufferedReader.close();
                inputStreamReader.close();
            }
            catch (Exception exception) {}
        }
        return playlistBean;
    }

    public static void write(PlaylistBean playlistBean) throws Exception {
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        PlaylistFileWriter playlistFileWriter = null;
        try {
            ArrayList<PlaylistFileRecord> arrayList = new ArrayList<PlaylistFileRecord>();
            for (MusicContentsBean object : playlistBean.getMcbList()) {
                PlaylistFileRecord playlistFileRecord = new PlaylistFileRecord();
                playlistFileRecord.setFileName(object.getFileName());
                arrayList.add(playlistFileRecord);
            }
            outputStreamWriter = new FileWriter(Const.PATH_LIB_AVPLAYER_PLAYLIST + playlistBean.getFileName());
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            playlistFileWriter = new PlaylistFileWriter(bufferedWriter);
            for (PlaylistFileRecord playlistFileRecord : arrayList) {
                playlistFileWriter.writeRecord(playlistFileRecord);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                playlistFileWriter.close();
                bufferedWriter.close();
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<PlaylistBean> allPlaylistFind() {
        ArrayList<PlaylistBean> arrayList = new ArrayList<PlaylistBean>();
        File file = null;
        File[] fileArray = null;
        try {
            file = new File(Const.PATH_LIB_AVPLAYER_PLAYLIST);
            fileArray = file.listFiles();
            if (fileArray == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            if (!file2.isFile() || !file2.getName().endsWith(PLAYLIST_FILE_EXT)) continue;
            PlaylistBean playlistBean = new PlaylistBean(file2.getName());
            arrayList.add(playlistBean);
        }
        return arrayList;
    }

    public static void delete(PlaylistBean playlistBean) throws Exception {
        File file = null;
        file = new File(Const.PATH_LIB_AVPLAYER_PLAYLIST + playlistBean.getFileName());
        if (!file.delete()) {
            throw new Exception();
        }
    }

    public static void rename(PlaylistBean playlistBean) throws Exception {
        File file = null;
        file = new File(Const.PATH_LIB_AVPLAYER_PLAYLIST + playlistBean.getOriginalFileName());
        if (!file.renameTo(new File(Const.PATH_LIB_AVPLAYER_PLAYLIST + playlistBean.getFileName()))) {
            throw new Exception();
        }
    }

    public static String getPlaylistFileNameWithoutExt(String string) throws Exception {
        return string.substring(0, string.length() - PLAYLIST_FILE_EXT.length());
    }

    public static String getPlaylistFileNameWithExt(String string) throws Exception {
        if (string == null) {
            throw new Exception();
        }
        return string + PLAYLIST_FILE_EXT;
    }
}

