/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ExtPopup;
import com.nttdocomo.dojaemu.ktoolbar.FileTransferable;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PopupManager;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerFiles;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerListAction;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerMain;
import com.nttdocomo.dojaemu.ktoolbar.ProjectListDropTarget;
import com.nttdocomo.dojaemu.ktoolbar.ProjectListMouseAdapter;
import com.nttdocomo.dojaemu.ktoolbar.RenameBox;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Position;

class ProjectExplorerList
extends JList {
    private ProjectExplorerMain mainExplorer = null;
    private PopupManager popupManager = null;
    private ProjectExplorerListAction action = null;
    private RenameBox renameBox = null;
    private Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private boolean isReLoad = false;
    private File renameTarget = null;
    private String currentPath = "";
    private boolean throwNextMatch = false;
    private String projectName;
    static final String HASHKEY_TEXT = "TEXT";
    static final String HASHKEY_ADF = "ADF";
    static final String HASHKEY_SP = "SP";
    static final String HASHKEY_PROP = "PROP";
    static final String HASHKEY_FC = "FC";
    static final String HASHKEY_SDF = "SDF";
    static final String HASHKEY_ILIB = "ILIB";
    static final String HASHKEY_OTHER = "OTHER";
    static final String HASHKEY_PLURAL = "PLURAL";
    static final String HASHKEY_NOSEL = "NOSEL";
    static final String HASHKEY_NEWSRC = "NEWSRC";

    ProjectExplorerList(ProjectExplorerMain projectExplorerMain) {
        this.mainExplorer = projectExplorerMain;
        this.initPopupMenu();
        this.setSelectionMode(2);
        this.setCellRenderer(new ListCellRenderer());
        DefaultListModel defaultListModel = new DefaultListModel();
        this.setModel(defaultListModel);
        this.addKeyListener(new ProjectListKeyAdapter());
        ProjectListMouseAdapter projectListMouseAdapter = new ProjectListMouseAdapter(this);
        this.addMouseListener(projectListMouseAdapter);
        this.addMouseMotionListener(projectListMouseAdapter);
        ProjectListDropTarget projectListDropTarget = new ProjectListDropTarget(this);
        this.setDropTarget(projectListDropTarget);
    }

    private void initPopupMenu() {
        this.action = new ProjectExplorerListAction(this);
        this.popupManager = new PopupManager();
        ExtPopup extPopup = new ExtPopup();
        extPopup.add(ProjectExplorerListAction.STR_EDIT, ProjectExplorerListAction.ACTCMD_EDIT, this.action);
        this.setGeneralMenuItem(extPopup);
        this.popupManager.setMenu(HASHKEY_TEXT, extPopup);
        ExtPopup extPopup2 = new ExtPopup();
        extPopup2.add(ProjectExplorerListAction.STR_ADFSET, "ADFSet", this.action);
        this.setGeneralMenuItem(extPopup2);
        this.popupManager.setMenu(HASHKEY_ADF, extPopup2);
        ExtPopup extPopup3 = new ExtPopup();
        extPopup3.add(ProjectExplorerListAction.STR_SPSET, "SPSet", this.action);
        this.setGeneralMenuItem(extPopup3);
        this.popupManager.setMenu(HASHKEY_SP, extPopup3);
        ExtPopup extPopup4 = new ExtPopup();
        extPopup4.add(ProjectExplorerListAction.STR_PROPSET, "PROPSet", this.action);
        this.setGeneralMenuItem(extPopup4);
        this.popupManager.setMenu(HASHKEY_PROP, extPopup4);
        ExtPopup extPopup5 = new ExtPopup();
        extPopup5.add(ProjectExplorerListAction.STR_FCSET, "FCSet", this.action);
        this.setGeneralMenuItem(extPopup5);
        this.popupManager.setMenu(HASHKEY_FC, extPopup5);
        ExtPopup extPopup6 = new ExtPopup();
        extPopup6.add(ProjectExplorerListAction.STR_SDFSET, "SDFSet", this.action);
        this.setGeneralMenuItem(extPopup6);
        this.popupManager.setMenu(HASHKEY_SDF, extPopup6);
        ExtPopup extPopup7 = new ExtPopup();
        extPopup7.add(ProjectExplorerListAction.STR_IAPPLIB, "IAPPLibSet", this.action);
        this.setGeneralMenuItem(extPopup7);
        this.popupManager.setMenu(HASHKEY_ILIB, extPopup7);
        ExtPopup extPopup8 = new ExtPopup();
        extPopup8.add(ProjectExplorerListAction.STR_OPEN, ProjectExplorerListAction.ACTCMD_OPEN, this.action);
        extPopup8.addSeparator();
        extPopup8.add(ProjectExplorerListAction.STR_RENAME, "Rename", this.action);
        extPopup8.add(ProjectExplorerListAction.STR_DELETE, "Delete", this.action);
        extPopup8.addSeparator();
        extPopup8.add(ProjectExplorerListAction.STR_COPY, "Copy", this.action);
        this.popupManager.setMenu(HASHKEY_OTHER, extPopup8);
        ExtPopup extPopup9 = new ExtPopup();
        extPopup9.add(ProjectExplorerListAction.STR_DELETE, "Delete", this.action);
        extPopup9.addSeparator();
        extPopup9.add(ProjectExplorerListAction.STR_COPY, "Copy", this.action);
        this.popupManager.setMenu(HASHKEY_PLURAL, extPopup9);
        ExtPopup extPopup10 = new ExtPopup();
        extPopup10.add(ProjectExplorerListAction.STR_PASTE, "Paste", this.action);
        this.popupManager.setMenu(HASHKEY_NOSEL, extPopup10);
        ExtPopup extPopup11 = new ExtPopup();
        extPopup11.add(ProjectExplorerListAction.STR_PASTE, "Paste", this.action);
        extPopup11.addSeparator();
        extPopup11.add(ProjectExplorerListAction.STR_NEWSRC, "NewSrc", this.action);
        this.popupManager.setMenu(HASHKEY_NEWSRC, extPopup11);
    }

    private void setGeneralMenuItem(ExtPopup extPopup) {
        extPopup.addSeparator();
        extPopup.add(ProjectExplorerListAction.STR_OPEN, ProjectExplorerListAction.ACTCMD_OPEN, this.action);
        extPopup.add(ProjectExplorerListAction.STR_RENAME, "Rename", this.action);
        extPopup.add(ProjectExplorerListAction.STR_DELETE, "Delete", this.action);
        extPopup.addSeparator();
        extPopup.add(ProjectExplorerListAction.STR_COPY, "Copy", this.action);
    }

    MainWindow getMainWindow() {
        return this.mainExplorer.getMainWindow();
    }

    void update(String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        Object[] objectArray = new Object[]{};
        if (this.currentPath.equals(string)) {
            objectArray = this.getSelectedValues();
        }
        defaultListModel.clear();
        if (string == null || string.length() == 0) {
            return;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            this.currentPath = string;
            Object[] objectArray2 = file.listFiles();
            if (objectArray2 == null) {
                this.setEnabled(false);
            } else {
                if (!this.isEnabled()) {
                    this.setEnabled(true);
                }
                Arrays.sort(objectArray2);
                for (int i = 0; i < objectArray2.length; ++i) {
                    if (((File)objectArray2[i]).isDirectory()) continue;
                    defaultListModel.addElement(objectArray2[i]);
                }
            }
        } else {
            this.setEnabled(false);
        }
        if (defaultListModel.size() > 0) {
            if (objectArray.length == 0) {
                this.setSelectedIndex(0);
                this.clearSelection();
            } else {
                this.setSelectedValues(objectArray);
            }
        }
    }

    void update(String string, String string2) {
        this.projectName = string2;
        this.update(string);
    }

    String getProjectName() {
        return this.projectName;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(SystemColor.white);
        } else {
            this.setBackground(SystemColor.control);
        }
    }

    private void setSelectedValues(Object[] objectArray) {
        int n = objectArray.length;
        if (n <= 0) {
            return;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            this.setSelectedValue(objectArray[i], false);
            nArray[i] = this.getSelectedIndex();
        }
        this.setSelectedIndices(nArray);
    }

    void update() {
        this.update(this.currentPath);
        if (this.renameTarget != null) {
            this.setSelectedValue(this.renameTarget, true);
            this.renameTarget = null;
        }
    }

    String getCurrentPath() {
        return this.currentPath;
    }

    private String getConnectFilePath(String string) {
        String string2 = this.currentPath + File.separator + string;
        return string2;
    }

    synchronized void showPopupMenu(MouseEvent mouseEvent, String string) {
        JPopupMenu jPopupMenu = this.getPopupMenu(string);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    synchronized void showPluralPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.popupManager.getMenu(HASHKEY_PLURAL);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    synchronized void showNoSelectPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = ProjectExplorerFiles.isSrcDir(this.currentPath) ? (!this.mainExplorer.getMainWindow().isMiniFullApp() ? this.popupManager.getMenu(HASHKEY_NEWSRC) : this.popupManager.getMenu(HASHKEY_NOSEL)) : this.popupManager.getMenu(HASHKEY_NOSEL);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private JPopupMenu getPopupMenu(String string) {
        String string2 = HASHKEY_OTHER;
        String string3 = ProjectExplorerFiles.getExtension(new File(string));
        string2 = string3.length() == 0 ? (ProjectExplorerFiles.isSDF(string) ? HASHKEY_SDF : HASHKEY_OTHER) : (ProjectExplorerFiles.isKToolBarExtension(string) ? (ProjectExplorerFiles.isADF(string) ? HASHKEY_ADF : (ProjectExplorerFiles.isProp(string) ? (!this.mainExplorer.getMainWindow().isFullAppUnderMiniFullApp(this.projectName) && !this.mainExplorer.getMainWindow().isMiniAppUnderMiniFullApp(this.projectName) ? HASHKEY_PROP : HASHKEY_OTHER) : (ProjectExplorerFiles.isScratch(string) ? (!this.mainExplorer.getMainWindow().isFullAppUnderMiniFullApp(this.projectName) && !this.mainExplorer.getMainWindow().isMiniAppUnderMiniFullApp(this.projectName) ? HASHKEY_SP : HASHKEY_OTHER) : (ProjectExplorerFiles.isFeliCaChip(string) ? HASHKEY_FC : (ProjectExplorerFiles.isIAppliLib(string) ? HASHKEY_ILIB : HASHKEY_OTHER))))) : (ProjectExplorerFiles.isTextExtension(string) ? HASHKEY_TEXT : HASHKEY_OTHER));
        JPopupMenu jPopupMenu = this.popupManager.getMenu(string2);
        if (jPopupMenu == null) {
            jPopupMenu = this.popupManager.getMenu(HASHKEY_OTHER);
        }
        return jPopupMenu;
    }

    private void ensureIndexIsVisible() {
        int n = this.getSelectedIndex();
        int n2 = this.getFirstVisibleIndex();
        int n3 = this.getLastVisibleIndex();
        if (n == -1 || n2 == -1 || n3 == -1) {
            return;
        }
        if (n >= n2 && n <= n3) {
            return;
        }
        super.ensureIndexIsVisible(n);
    }

    int getListSize() {
        return this.getModel().getSize();
    }

    int getSelectedRowWidth(int n) {
        File file = (File)this.getModel().getElementAt(n);
        int n2 = this.getFontMetrics(this.getFont()).stringWidth(file.getName());
        if (MainWindow.IS_OVER_JRE14) {
            DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)this.getCellRenderer();
            int n3 = defaultListCellRenderer.getIcon().getIconWidth();
            n2 += n3 + 5;
        }
        return n2;
    }

    void defaultAction(String string) {
        JPopupMenu jPopupMenu = this.getPopupMenu(string);
        ExtPopup extPopup = (ExtPopup)jPopupMenu.getComponent();
        JMenuItem jMenuItem = (JMenuItem)extPopup.getComponent(0);
        jMenuItem.doClick();
    }

    int appendFile(String string) {
        int n;
        File file = new File(string);
        if (!file.exists()) {
            return -1;
        }
        if (file.isDirectory()) {
            return -2;
        }
        File file2 = new File(this.getConnectFilePath(file.getName()));
        if (file.compareTo(file2) == 0) {
            this.update();
            this.repaint();
            return 0;
        }
        if (file2.exists() && (n = this.mainExplorer.showQuestionDialog(null, Resource.getString("EXPLORER_CONFIRM_OVERWRITE"))) == 2) {
            return -3;
        }
        try {
            ProjectExplorerFiles.copyFile(file, file2);
        }
        catch (IOException iOException) {
            this.mainExplorer.showDialog(null, Resource.getString("EXPLORER_ERR_FILE_COPY"));
            return -4;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.addElement(file2);
        this.update();
        this.repaint();
        return 0;
    }

    int appendFile(List list) {
        int n;
        if (list.size() == 0) {
            return 0;
        }
        if (!new File(this.currentPath).exists()) {
            this.mainExplorer.showDialog(null, Resource.getString("EXPLORER_ERR_FILE_COPY"));
            this.isReLoad = true;
            return -4;
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < list.size(); ++n) {
            File file = (File)list.get(n);
            vector.add(file.getAbsolutePath());
        }
        n = this.action.actCopyFiles(vector.toArray(new String[0]), this.currentPath);
        this.update();
        this.repaint();
        return n;
    }

    void deleteSelectedFile() {
        int n;
        Object[] objectArray = this.getSelectedValues();
        if (objectArray.length == 0) {
            return;
        }
        String[] stringArray = new String[objectArray.length];
        boolean bl = false;
        for (n = 0; n < objectArray.length; ++n) {
            File file = (File)objectArray[n];
            if (!file.canWrite()) {
                bl = true;
            }
            stringArray[n] = file.getAbsolutePath();
        }
        n = 0;
        if (stringArray.length > 0) {
            String string = "";
            String string2 = "";
            if (stringArray.length == 1) {
                if (bl) {
                    string2 = Resource.getString("EXPLORER_READONLY_FILE");
                }
                string = new File(stringArray[0]).getName();
            } else {
                if (bl) {
                    string2 = Resource.getString("EXPLORER_READONLY_IN_FILES");
                }
                string = Resource.format("EXPLORER_FILE_COUNT_MES", String.valueOf(stringArray.length));
            }
            String string3 = string2 + Resource.format("EXPLORER_CONFIRM_TRASHBOX", string);
            n = this.mainExplorer.showQuestionDialog(null, string3);
            if (n == 0) {
                if (this.action.actDeleteFiles(stringArray) != 0) {
                    this.mainExplorer.showDialog(null, Resource.getString("EXPLORER_ERR_FILE_DELETE"));
                }
                this.repaint();
            }
        }
    }

    void openSelectedFile() {
        Object[] objectArray = this.getSelectedValues();
        if (objectArray.length != 1) {
            return;
        }
        File file = (File)objectArray[0];
        if (!file.exists()) {
            this.repaint();
            return;
        }
        int n = 0;
        String string = file.getPath();
        n = this.action.actOpenFile(string);
        if (n != 0) {
            this.mainExplorer.showDialog(null, Resource.getString("EXPLORER_ERR_FILE_OPEN"));
        }
    }

    void openEditorSelectedFile() {
        Object[] objectArray = this.getSelectedValues();
        if (objectArray.length != 1) {
            return;
        }
        File file = (File)objectArray[0];
        if (!file.exists()) {
            this.repaint();
            return;
        }
        String string = this.getMainWindow().getSourceEditor();
        if (string == null || string.length() == 0) {
            this.openSelectedFile();
            return;
        }
        File file2 = new File(string);
        if (!file2.exists()) {
            this.openSelectedFile();
        } else {
            byte[] byArray;
            String string2 = file.getPath();
            byte[] byArray2 = (string2 = string2 + '\u0000').getBytes();
            if (JAMManager.openFile(byArray2, byArray = (file2.getAbsolutePath() + '\u0000').getBytes()) != 0) {
                this.mainExplorer.showDialog(null, Resource.getString("EXPLORER_ERR_FILE_OPEN"));
            }
        }
    }

    void renameSelectedFile() {
        Object[] objectArray = this.getSelectedValues();
        if (objectArray.length != 1) {
            return;
        }
        File file = (File)objectArray[0];
        if (!file.exists()) {
            this.repaint();
            return;
        }
        this.createRenameBox(file.getPath());
    }

    private void createRenameBox(String string) {
        int n;
        this.renameBox = new RenameBox(this, string);
        this.renameBox.setText(new File(string).getName());
        this.renameBox.setFont(this.getFont());
        this.add(this.renameBox);
        int n2 = this.getSelectedIndex();
        Rectangle rectangle = this.getCellBounds(n2, n2);
        int n3 = this.renameBox.getFontMetrics(this.renameBox.getFont()).stringWidth(this.renameBox.getText());
        n3 += 30;
        int n4 = 0;
        if (MainWindow.IS_OVER_JRE14) {
            DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)this.getCellRenderer();
            n4 = defaultListCellRenderer.getIcon().getIconWidth();
        }
        if (n3 >= (n = this.getVisibleRect().width)) {
            n3 = n - (n4 + rectangle.x);
        }
        this.renameBox.setBounds(n4 + rectangle.x, rectangle.y - 1, n3, rectangle.height + 2);
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.setSize(1, rectangle.height);
        this.scrollRectToVisible(rectangle2);
        this.renameBox.requestFocus();
        this.renameBox.selectAll();
        this.getMainWindow().clearAccelerator();
    }

    void removeRenameBox(String string) {
        if (this.renameBox != null) {
            if (this.isAncestorOf(this.renameBox)) {
                this.remove(this.renameBox);
            }
            this.requestFocus();
            if (string != null) {
                File file = new File(this.getConnectFilePath(string));
                this.setLostSelectionItem(file);
            }
            this.repaint();
            this.getMainWindow().setAccelerator();
        }
    }

    boolean isShowingRenameBox() {
        if (this.renameBox != null) {
            return this.isAncestorOf(this.renameBox);
        }
        return false;
    }

    private void setLostSelectionItem(Object object) {
        if (object instanceof File) {
            this.renameTarget = (File)object;
        }
    }

    void doRename(String string, String string2) {
        String string3;
        int n;
        File file = new File(string);
        if (ProjectExplorerFiles.compareSpell(file, string2)) {
            this.removeRenameBox(null);
            return;
        }
        if (!file.canWrite() && (n = this.mainExplorer.showQuestionDialog(null, Resource.format("EXPLORER_READONLY", string3 = file.getName()) + Resource.format("EXPLORER_RENAME_OF_FILE", string3))) != 0) {
            this.removeRenameBox(null);
            return;
        }
        int n2 = ProjectExplorerFiles.renameFile(file, string2);
        if (n2 == 0) {
            this.removeRenameBox(string2);
        } else if (n2 == -3) {
            this.mainExplorer.showDialog(null, Resource.getString("EXPLORER_ERR_RENAME_SAME"));
            this.removeRenameBox(null);
        } else {
            this.mainExplorer.showDialog(null, Resource.getString("EXPLORER_ERR_FILE_RENAME"));
            this.removeRenameBox(null);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isReLoad) {
            this.update();
            this.isReLoad = false;
        }
    }

    public ProjectExplorerMain getProjectExplorerMain() {
        return this.mainExplorer;
    }

    @Override
    public int getNextMatch(String string, int n, Position.Bias bias) {
        ListModel listModel = this.getModel();
        int n2 = listModel.getSize();
        if (string == null) {
            return -1;
        }
        if (n < 0 || n >= n2) {
            return -1;
        }
        string = string.toUpperCase();
        int n3 = bias == Position.Bias.Forward ? 1 : -1;
        int n4 = n;
        do {
            String string2;
            Object e;
            if ((e = listModel.getElementAt(n4)) == null) continue;
            if (e instanceof File) {
                String string3 = ((File)e).getName();
                string2 = string3.toUpperCase();
            } else {
                string2 = e.toString();
                if (string2 != null) {
                    string2 = string2.toUpperCase();
                }
            }
            if (string2 == null || !string2.startsWith(string)) continue;
            this.throwNextMatch = true;
            return n4;
        } while ((n4 = (n4 + n3 + n2) % n2) != n);
        return -1;
    }

    void pasteFromClipboard() {
        Transferable transferable = this.clipboard.getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            List list = null;
            try {
                list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                this.appendFile(list);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void copyToClipboard() {
        FileTransferable fileTransferable = new FileTransferable();
        Object[] objectArray = this.getSelectedValues();
        if (objectArray.length == 0) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            fileTransferable.add((File)objectArray[i]);
        }
        try {
            this.clipboard.setContents(fileTransferable, null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    class ProjectListKeyAdapter
    extends KeyAdapter {
        ProjectListKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 116) {
                ProjectExplorerList.this.update();
                return;
            }
            if (n == 86 && keyEvent.isControlDown()) {
                ProjectExplorerList.this.pasteFromClipboard();
                keyEvent.consume();
                return;
            }
            File file = (File)ProjectExplorerList.this.getSelectedValue();
            if (file == null) {
                if (ProjectExplorerList.this.getListSize() == 1 && n == 40) {
                    ProjectExplorerList.this.setSelectedIndex(0);
                }
                return;
            }
            if (n == 10) {
                if (ProjectExplorerList.this.getSelectedValues().length != 1) {
                    return;
                }
                ProjectExplorerList.this.defaultAction(file.getAbsolutePath());
            } else if (n == 113) {
                if (ProjectExplorerList.this.getSelectedValues().length != 1) {
                    return;
                }
                ProjectExplorerList.this.renameSelectedFile();
            } else if (n == 127) {
                ProjectExplorerList.this.deleteSelectedFile();
            } else if (n == 67) {
                if (keyEvent.isControlDown()) {
                    ProjectExplorerList.this.copyToClipboard();
                    keyEvent.consume();
                }
            } else {
                char c;
                if (!ProjectExplorerList.this.isSelectionEmpty() && (c = keyEvent.getKeyChar()) != '\uffff' && !this.isModifieres(keyEvent)) {
                    keyEvent.consume();
                }
                super.keyPressed(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (!ProjectExplorerList.this.throwNextMatch) {
                return;
            }
            ProjectExplorerList.this.throwNextMatch = false;
            char c = keyEvent.getKeyChar();
            if (c != '\uffff' && !this.isModifieres(keyEvent)) {
                ProjectExplorerList.this.ensureIndexIsVisible();
            }
            super.keyReleased(keyEvent);
        }

        private boolean isModifieres(KeyEvent keyEvent) {
            int n = keyEvent.getModifiersEx();
            return (n & 0x3C0) != 0;
        }
    }

    private class ListCellRenderer
    extends DefaultListCellRenderer {
        private ListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = null;
            File file = null;
            if (!(object instanceof File)) {
                ProjectExplorerList.this.isReLoad = true;
                return null;
            }
            file = (File)object;
            if (!file.exists()) {
                ProjectExplorerList.this.isReLoad = true;
                return null;
            }
            component = super.getListCellRendererComponent((JList<?>)jList, file.getName(), n, bl, bl2);
            if (MainWindow.IS_OVER_JRE14) {
                try {
                    Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
                    this.setIcon(icon);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setVerticalTextPosition(0);
            return component;
        }
    }
}

