/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AppIcon;
import com.nttdocomo.dojaemu.ktoolbar.ExtPopup;
import com.nttdocomo.dojaemu.ktoolbar.PopupManager;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerMain;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerTreeAction;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerTreeCellRenderer;
import com.nttdocomo.dojaemu.ktoolbar.ProjectTreeMouseAdapter;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

class ProjectExplorerTree
extends JTree
implements TreeSelectionListener {
    private PopupManager popupManager = null;
    private ProjectExplorerMain parent;
    private String currentDir = "";
    private static final String HASHKEY_OPEN = "OPEN";
    private static final String HASHKEY_RELOAD = "RELOAD";
    ProjectExplorerTreeAction treeAction = null;
    private boolean isThroughValueChange = false;
    private final int ICON_SIZE = 16;
    private File root;

    ProjectExplorerTree(ProjectExplorerMain projectExplorerMain) {
        this.parent = projectExplorerMain;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, true);
        this.setModel(defaultTreeModel);
        this.addTreeSelectionListener(this);
        this.getSelectionModel().setSelectionMode(1);
        ProjectTreeMouseAdapter projectTreeMouseAdapter = new ProjectTreeMouseAdapter(this);
        this.addMouseListener(projectTreeMouseAdapter);
        this.createPopupMenu();
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            Icon icon = ProjectExplorerTreeAction.getFolderIcon(0);
            Icon icon2 = ProjectExplorerTreeAction.getFolderIcon(1);
            if (icon != null && icon2 != null) {
                defaultTreeCellRenderer.setClosedIcon(icon);
                defaultTreeCellRenderer.setOpenIcon(icon2);
                this.setRowHeight(icon2.getIconHeight());
            }
        }
    }

    private void createPopupMenu() {
        this.treeAction = new ProjectExplorerTreeAction(this);
        this.popupManager = new PopupManager();
        ExtPopup extPopup = new ExtPopup();
        extPopup.add(ProjectExplorerTreeAction.STR_OPEN, "Open", this.treeAction);
        this.popupManager.setMenu(HASHKEY_OPEN, extPopup);
        ExtPopup extPopup2 = new ExtPopup();
        extPopup2.add(ProjectExplorerTreeAction.STR_OPEN, "Open", this.treeAction);
        extPopup2.addSeparator();
        extPopup2.add(ProjectExplorerTreeAction.STR_RELOAD, "Reload", this.treeAction);
        this.popupManager.setMenu(HASHKEY_RELOAD, extPopup2);
    }

    void expandedState(boolean bl) {
        if (bl) {
            for (int i = 1; i < this.getRowCount(); ++i) {
                TreePath treePath = this.getPathForRow(i);
                this.setExpandedState(treePath, bl);
            }
        } else {
            for (int i = this.getRowCount(); i > 0; --i) {
                TreePath treePath = this.getPathForRow(i);
                this.setExpandedState(treePath, bl);
            }
        }
    }

    void treeClose(Vector vector) {
        int n;
        Vector<TreePath> vector2 = new Vector<TreePath>();
        for (n = 0; n < this.getRowCount(); ++n) {
            vector2.addElement(this.getPathForRow(n));
        }
        n = 0;
        TreePath treePath = this.getPathForRow(0);
        for (int i = 0; i < vector2.size(); ++i) {
            n = 0;
            Object e = vector2.get(i);
            if (!(e instanceof TreePath)) {
                return;
            }
            TreePath treePath2 = (TreePath)e;
            Object object = vector.iterator();
            while (object.hasNext()) {
                TreePath treePath3 = (TreePath)object.next();
                if (!treePath2.toString().equals(treePath3.toString())) continue;
                n = 1;
                break;
            }
            if (n == 1 || (object = treePath2.getParentPath()) == null || treePath.equals(object)) continue;
            this.collapsePath((TreePath)object);
        }
    }

    void createNodes(DefaultMutableTreeNode defaultMutableTreeNode, File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileArray[i].getName());
                this.createNodes(defaultMutableTreeNode2, fileArray[i]);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = treeSelectionEvent.getPath().getPath();
        if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
            return;
        }
        if (objectArray != null && objectArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i].toString());
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(File.separator);
            }
            String string = this.parent.getProjectHome() + File.separator + stringBuffer.toString();
            this.parent.updateList(string, this.root.getName());
            this.currentDir = string;
            this.isThroughValueChange = true;
            int n = this.getSelectionRow();
            if (n != -1) {
                this.scrollRowToVisible(n);
            }
            String string2 = null;
            int n2 = stringBuffer.toString().indexOf(File.separator);
            string2 = n2 == -1 ? stringBuffer.toString() : stringBuffer.toString().substring(0, n2);
            this.parent.resetSelection(string2);
        }
    }

    String getSelectedPath() {
        return this.currentDir;
    }

    void updateCurrentList() {
        if (!this.isThroughValueChange) {
            this.parent.updateList(this.getSelectedPath(), this.root.getName());
        }
        this.isThroughValueChange = false;
    }

    void reloadProjectTree() {
        String string = this.getModel().getRoot().toString();
        this.parent.updateTree(string);
    }

    void openSelectedDir() {
        String string = this.getSelectedPath();
        if (string.length() == 0) {
            return;
        }
        if (!new File(string).exists()) {
            return;
        }
        this.treeAction.actOpenFolder(string);
    }

    public void showPopupMenu(MouseEvent mouseEvent, boolean bl) {
        if (bl) {
            String string;
            JPopupMenu jPopupMenu = null;
            String string2 = new File(this.getSelectedPath()).getName();
            jPopupMenu = string2.equals(string = this.root.getName()) ? this.popupManager.getMenu(HASHKEY_RELOAD) : this.popupManager.getMenu(HASHKEY_OPEN);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\uffff') {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    private int getSelectionRow() {
        int[] nArray = this.getSelectionRows();
        if (nArray == null || nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public void setRoot(File file) {
        this.root = file;
    }

    File getRoot() {
        return this.root;
    }

    public void setTreeIcon() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        this.setCellRenderer(defaultTreeCellRenderer);
        Icon icon = ProjectExplorerTreeAction.getFolderIcon(0);
        Icon icon2 = ProjectExplorerTreeAction.getFolderIcon(1);
        if (icon != null && icon2 != null) {
            defaultTreeCellRenderer.setClosedIcon(icon);
            defaultTreeCellRenderer.setOpenIcon(icon2);
            this.setRowHeight(icon.getIconHeight());
        }
    }

    public void setMiniFullIcon(String string, String string2) {
        Icon icon = ProjectExplorerTreeAction.getFolderIcon(0);
        Icon icon2 = ProjectExplorerTreeAction.getFolderIcon(1);
        AppIcon appIcon = new AppIcon(string);
        ImageIcon imageIcon = appIcon.getAppTypeImageIcon(string2);
        Image image = null;
        image = imageIcon.getImage();
        Image image2 = image.getScaledInstance(16, 16, 4);
        imageIcon.setImage(image2);
        if (icon2 != null && icon != null && imageIcon != null) {
            ProjectExplorerTreeCellRenderer projectExplorerTreeCellRenderer = new ProjectExplorerTreeCellRenderer(imageIcon, icon2, icon);
            this.setCellRenderer(projectExplorerTreeCellRenderer);
            this.setRowHeight(icon.getIconHeight());
        }
    }
}

