/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.StringChecker;
import java.util.HashSet;

class SDFNeedChecker {
    private static final String SKIP_CONFIRM_VALUE = "LAUNCH";
    private static final String PROTOCOL_HTTP = "http://";
    private static final String PROTOCOL_HTTPS = "https://";
    private static final String PROTOCOL_DOUBLE_SLASH = "//";
    private static final String SEPARATE_CHAR_COLON = ":";
    private static final String SEPARATE_CHAR_SLASH = "/";
    private static final String SEPARATE_CHAR_SPACE = " ";
    private static final String SEPARATE_CHAR_HYPHEN = "-";
    private static final String SEPARATE_CHAR_DOT = "\\.";
    private static final String STR_ANY = "ANY";
    private static final String DOCOMO_URL_NE_JP = "docomo.ne.jp";
    private static final String DOCOMO_URL_ML = "/ml/";
    private static final String DOCOMO_URL_MN = "/mn/";
    private static final String DOCOMO_URL_IMT_ML = "/imt/ml/";
    private static final String DOCOMO_URL_IMT_MN = "/imt/mn/";
    private static final int KEY_VALUE_OK = 0;
    private static final int KEY_VALUE_NOTHING = 1;
    private static final int KEY_VALUE_NG = 2;
    private static final int KEY_VALUE_ANY = 3;
    private static final int KEY_VALUE_MAX_LENGTH = 255;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int MODE_OMIT = 0;
    private static final int MODE_NOT_OMIT = 1;
    private static final int CHECK_PORT_SINGLE = 0;
    private static final int CHECK_PORT_AREA = 1;
    private static final int INT_0 = 0;
    private static final String PROHIBITION_CODE = "FF";
    private static final int MAX_FELICA_SYSTEM_INFO = 14;
    private static final int SYSTEM_CODE_LEN = 4;
    private static final int MIN_SYSTEM_SIZE = 4;
    private static final int ELEMENT_NOT_SYSTEM_SIZE = 2;
    private static final int ELEMENT_SYSTEM_SIZE = 3;
    private static final int INDEX_SYSTEM_CODE = 0;
    private static final int INDEX_SYSTEM_NAME = 1;
    private static final int INDEX_SYSTEM_SIZE = 2;

    SDFNeedChecker() {
    }

    public static int parseICServiceIDValue(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        char[] cArray = null;
        if (string == null || string.length() == 0) {
            n = 1;
        } else {
            cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (n2 == 8) {
                    if (cArray[i] == ',') {
                        n2 = 0;
                        if (++n3 <= 4) continue;
                        n = 2;
                        break;
                    }
                    n = 2;
                    break;
                }
                if (SDFNeedChecker.isXDisit(cArray[i])) {
                    ++n2;
                    continue;
                }
                n = 2;
                break;
            }
            if (n2 != 8) {
                n = 2;
            }
        }
        return n;
    }

    public static int parseSkipConfirm(String string) {
        int n = 0;
        if (string == null || string.length() == 0) {
            n = 1;
        } else if (!string.toUpperCase().equals(SKIP_CONFIRM_VALUE)) {
            n = 2;
        }
        return n;
    }

    public static int parseAppID(String string) {
        int n = 0;
        if (string == null || string.length() == 0) {
            n = 1;
        } else if (string.length() != 9) {
            n = 2;
        } else {
            StringChecker stringChecker = new StringChecker(string);
            if (!stringChecker.isHalfNumber()) {
                n = 2;
            }
        }
        return n;
    }

    public static int parseLibID(String string) {
        int n = 0;
        if (string == null || string.length() == 0) {
            n = 1;
        } else if (string.length() != 11) {
            n = 2;
        } else {
            StringChecker stringChecker = new StringChecker(string);
            if (!stringChecker.isHalfNumber()) {
                n = 2;
            }
        }
        return n;
    }

    public static int parseAllowedLauncherApp(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (string == null || string.length() == 0) {
            n2 = 1;
        } else if (string.length() > 255) {
            n2 = 2;
        } else {
            StringChecker stringChecker = new StringChecker(string);
            if (!stringChecker.isAscii()) {
                n2 = 2;
            } else {
                String[] stringArray = string.split(SEPARATE_CHAR_SPACE);
                for (n = 0; n < stringArray.length; ++n) {
                    n3 = SDFNeedChecker.isProtocol(stringArray[n], 1);
                    if (n3 == -1) {
                        n2 = 2;
                        break;
                    }
                    String string2 = stringArray[n].substring(n3);
                    String string3 = string2.substring(0, n4 = SDFNeedChecker.getHostNameLen(string2));
                    if (!SDFNeedChecker.isIPAddress(string3)) continue;
                    n2 = 2;
                    break;
                }
            }
        }
        return n2;
    }

    public static int parseAllowedTcpUdpHost(String string) {
        int n = 0;
        StringChecker stringChecker = new StringChecker();
        if (string == null || string.length() == 0) {
            n = 1;
        } else if (string.length() > 255) {
            n = 2;
        } else {
            stringChecker = new StringChecker(string);
            if (!stringChecker.isAscii()) {
                n = 2;
            } else {
                String[] stringArray = string.split(SEPARATE_CHAR_SPACE);
                if (!SDFNeedChecker.isKeyTypeHost(stringArray)) {
                    n = 2;
                }
            }
        }
        return n;
    }

    public static int parseAllowedHost(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringChecker stringChecker = new StringChecker();
        if (string == null || string.length() == 0) {
            n = 1;
        } else if (string.length() > 255) {
            n = 2;
        } else {
            stringChecker = new StringChecker(string);
            if (!stringChecker.isAscii()) {
                n = 2;
            } else {
                String[] stringArray = string.split(SEPARATE_CHAR_SPACE);
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    if (stringArray[n4].toUpperCase().equals(STR_ANY)) {
                        n = 3;
                        continue;
                    }
                    n3 = SDFNeedChecker.isProtocol(stringArray[n4], 1);
                    if (n3 == -1) {
                        n = 2;
                        break;
                    }
                    String string2 = stringArray[n4].substring(n3);
                    n2 = string2.indexOf(SEPARATE_CHAR_SLASH);
                    String[] stringArray2 = string2.split(SEPARATE_CHAR_COLON);
                    String string3 = stringArray2[0].substring(0, n2 = SDFNeedChecker.getHostNameLen(stringArray2[0]));
                    if (string3 == null || string3.length() == 0) {
                        n = 2;
                        break;
                    }
                    if (SDFNeedChecker.isIPAddress(string3)) {
                        n = 2;
                        break;
                    }
                    if (stringArray2.length == 2) {
                        if (stringArray2[1] == null || stringArray2[1].length() == 0) break;
                        if (SDFNeedChecker.isPortNumber(stringArray2[1], 0)) continue;
                        n = 2;
                        break;
                    }
                    if (stringArray2.length <= 2) continue;
                    n = 2;
                    break;
                }
            }
        }
        return n;
    }

    public static int parseDeniedHost(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringChecker stringChecker = new StringChecker();
        if (string == null || string.length() == 0) {
            n = 1;
        } else if (string.length() > 255) {
            n = 2;
        } else {
            stringChecker = new StringChecker(string);
            if (!stringChecker.isAscii()) {
                n = 2;
            } else {
                String[] stringArray = string.split(SEPARATE_CHAR_SPACE);
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    n3 = SDFNeedChecker.isProtocol(stringArray[n4], 0);
                    if (n3 == -1) {
                        n = 2;
                        break;
                    }
                    String string2 = stringArray[n4].substring(n3);
                    String[] stringArray2 = string2.split(SEPARATE_CHAR_COLON);
                    String string3 = stringArray2[0].substring(0, n2 = SDFNeedChecker.getHostNameLen(stringArray2[0]));
                    if (SDFNeedChecker.isIPAddress(string3)) {
                        n = 2;
                    }
                    if (stringArray2.length == 2) {
                        if (stringArray2[1] == null || stringArray2[1].length() == 0) break;
                        if (SDFNeedChecker.isPortNumber(stringArray2[1], 0)) continue;
                        n = 2;
                        break;
                    }
                    if (stringArray2.length <= 2) continue;
                    n = 2;
                    break;
                }
            }
        }
        return n;
    }

    public static int parseAppDownLoadURL(String string) {
        int n = 0;
        StringChecker stringChecker = new StringChecker(string);
        if (string == null || string.length() == 0) {
            n = 1;
        } else if (string.length() > 255) {
            n = 2;
        } else if (!stringChecker.isAscii()) {
            n = 2;
        } else if (!SDFNeedChecker.isURL(string)) {
            n = 2;
        }
        return n;
    }

    public static int parseFeliCaSystemInfo(String string) {
        int n = 0;
        StringChecker stringChecker = new StringChecker(string);
        int n2 = 0;
        int n3 = 0;
        if (string == null || string.length() == 0) {
            n = 1;
        } else {
            String[] stringArray;
            if (!stringChecker.isAscii()) {
                n = 2;
            }
            if ((n2 = (stringArray = string.split(SEPARATE_CHAR_SLASH, -1)).length) > 14) {
                return 2;
            }
            String[] stringArray2 = new String[n2];
            String[] stringArray3 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                int n4;
                String[] stringArray4 = stringArray[i].split(SEPARATE_CHAR_COLON, -1);
                n3 = stringArray4.length;
                if (n3 != 2 && n3 != 3) {
                    n = 2;
                    return 2;
                }
                String string2 = stringArray4[0].toUpperCase();
                if (string2.length() != 4) {
                    n = 2;
                    return 2;
                }
                char[] cArray = string2.toCharArray();
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    if (SDFNeedChecker.isXDisit(cArray[n4])) continue;
                    return 2;
                }
                if (string2.substring(0, 2).equals(PROHIBITION_CODE) || string2.substring(2, 4).equals(PROHIBITION_CODE)) {
                    return 2;
                }
                stringArray2[i] = string2;
                try {
                    n4 = Integer.parseInt(stringArray4[1]);
                    if (1 > n4 || n4 > 14) {
                        return 2;
                    }
                    stringArray3[i] = stringArray4[1];
                }
                catch (NumberFormatException numberFormatException) {
                    return 2;
                }
                if (n3 != 3) continue;
                if (stringArray4[2] == null || stringArray4[2].length() == 0) {
                    return 2;
                }
                try {
                    n4 = Integer.parseInt(stringArray4[2]);
                    if (n4 >= 4) continue;
                    return 2;
                }
                catch (NumberFormatException numberFormatException) {
                    return 2;
                }
            }
            if (!SDFNeedChecker.chkRepetition(stringArray2) || !SDFNeedChecker.chkRepetition(stringArray3)) {
                return 2;
            }
        }
        return n;
    }

    public static boolean isXDisit(char c) {
        boolean bl = false;
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
            bl = true;
        }
        return bl;
    }

    public static boolean isKeyTypeHost(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2 = stringArray[n].split(SEPARATE_CHAR_COLON);
            if (stringArray2.length != 2) {
                bl = false;
                break;
            }
            if (stringArray2[0].length() == 0 || stringArray2[1].length() == 0) {
                bl = false;
                break;
            }
            int n2 = stringArray2[1].indexOf(SEPARATE_CHAR_SLASH);
            if (n2 != -1) {
                stringArray2[1] = stringArray2[1].substring(0, n2);
            }
            if (SDFNeedChecker.isIPAddress(stringArray2[0])) {
                bl = false;
                break;
            }
            bl = SDFNeedChecker.isPortNumber(stringArray2[1], 1);
            if (!bl) break;
        }
        return bl;
    }

    public static boolean isURL(String string) {
        String string2;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        if (string.startsWith(PROTOCOL_HTTP)) {
            n = PROTOCOL_HTTP.length();
        } else if (string.startsWith(PROTOCOL_HTTPS)) {
            n = PROTOCOL_HTTPS.length();
        } else {
            bl2 = false;
            return bl2;
        }
        String string3 = string.substring(n);
        if (string3 == null || string3.length() == 0) {
            bl2 = false;
            return bl2;
        }
        if (string3.indexOf(SEPARATE_CHAR_COLON) != -1) {
            n2 = string3.indexOf(SEPARATE_CHAR_COLON);
        }
        if (string3.indexOf(SEPARATE_CHAR_SLASH) != -1) {
            n2 = n2 != 0 ? Math.min(n2, string3.indexOf(SEPARATE_CHAR_SLASH)) : string3.indexOf(SEPARATE_CHAR_SLASH);
        }
        if (SDFNeedChecker.isIPAddress(string2 = n2 == 0 ? string3 : string3.substring(0, n2))) {
            bl2 = false;
            return bl2;
        }
        if (string3.startsWith(DOCOMO_URL_NE_JP) && ((string2 = string3.substring(DOCOMO_URL_NE_JP.length())).startsWith(DOCOMO_URL_ML) || string2.startsWith(DOCOMO_URL_MN) || string2.startsWith(DOCOMO_URL_IMT_ML) || string2.startsWith(DOCOMO_URL_IMT_MN))) {
            bl2 = false;
            return bl2;
        }
        bl2 = true;
        return bl2;
    }

    public static boolean isIPAddress(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String[] stringArray = string.split(SEPARATE_CHAR_DOT);
        if (stringArray.length == 4) {
            for (n = 0; n < stringArray.length; ++n) {
                StringChecker stringChecker = new StringChecker(stringArray[n]);
                if (!stringChecker.isHalfNumber()) {
                    bl = false;
                    break;
                }
                n2 = Integer.parseInt(stringArray[n]);
                if (0 > n2 || n2 > 255) {
                    bl = false;
                    break;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static int isProtocol(String string, int n) {
        int n2 = 0;
        if (n == 0) {
            if (string.startsWith(PROTOCOL_HTTP)) {
                n2 = PROTOCOL_HTTP.length();
            } else if (string.startsWith(PROTOCOL_HTTPS)) {
                n2 = PROTOCOL_HTTPS.length();
            } else if (string.startsWith(PROTOCOL_DOUBLE_SLASH)) {
                n2 = PROTOCOL_DOUBLE_SLASH.length();
            } else if (string.indexOf(PROTOCOL_DOUBLE_SLASH) != -1) {
                n2 = -1;
            }
        } else {
            n2 = string.startsWith(PROTOCOL_HTTP) ? PROTOCOL_HTTP.length() : (string.startsWith(PROTOCOL_HTTPS) ? PROTOCOL_HTTPS.length() : -1);
        }
        return n2;
    }

    public static int getHostNameLen(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = string.indexOf(SEPARATE_CHAR_COLON);
        n2 = string.indexOf(SEPARATE_CHAR_SLASH);
        if (n == -1) {
            n3 = 0;
        }
        if (n2 != -1) {
            n3 = n3 != 0 ? Math.min(n3, n2) : n2;
        }
        if (n3 == 0) {
            n3 = string.length();
        }
        return n3;
    }

    public static boolean isPortNumber(String string, int n) {
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n2 = string.indexOf(SEPARATE_CHAR_SLASH);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (string.indexOf(SEPARATE_CHAR_HYPHEN) == 0) {
            bl = false;
            return bl;
        }
        String[] stringArray = string.split(SEPARATE_CHAR_HYPHEN);
        StringChecker stringChecker = new StringChecker(stringArray[0]);
        if (!stringChecker.isHalfNumber()) {
            bl = false;
        } else {
            n3 = Integer.parseInt(stringArray[0]);
            if (n3 < 0 || 65535 < n3) {
                bl = false;
                return bl;
            }
        }
        if (n == 0) {
            if (stringArray.length != 1) {
                bl = false;
                return bl;
            }
        } else if (n == 1) {
            if (stringArray.length == 2) {
                n4 = Integer.parseInt(stringArray[1]);
                if (n4 < 0 || 65535 < n4) {
                    bl = false;
                    return bl;
                }
                n5 = n4 - n3;
                if (n5 < 0 || 100 < n5) {
                    bl = false;
                    return bl;
                }
            } else if (stringArray.length > 2) {
                bl = false;
                return bl;
            }
        }
        return bl;
    }

    public static boolean chkRepetition(String[] stringArray) {
        boolean bl = true;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (hashSet.add(stringArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

