/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ScreenshotSettingWindow
extends TabPanel
implements ItemListener,
DocumentListener {
    private ButtonGroup radioButtonGroup;
    private JRadioButton ClipBoardRadioButton = new JRadioButton(Resource.getString("SET_SCREENSHOT_SAVE_CLIPBOARD"));
    private JRadioButton FileRadioButton = new JRadioButton(Resource.getString("SET_SCREENSHOT_SAVE_FILE"));
    private JTextField filenameField;
    private JButton fileSelButton;
    private JTextField prefixField;

    ScreenshotSettingWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.radioButtonGroup = new ButtonGroup();
        this.radioButtonGroup.add(this.ClipBoardRadioButton);
        this.radioButtonGroup.add(this.FileRadioButton);
        String string = new String(JAMManager.getScreenshotPath());
        if (string.equals("")) {
            string = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "screenshot";
        }
        this.filenameField = new JTextField(25);
        this.filenameField.setHorizontalAlignment(2);
        this.filenameField.setText(string);
        this.fileSelButton = new JButton(Resource.getString("FILE_SELECT"));
        String string2 = new String(JAMManager.getScreenshotPrefix());
        this.prefixField = new JTextField(25);
        this.prefixField.setHorizontalAlignment(2);
        this.prefixField.setText(string2);
        int n = JAMManager.getScreenshotEnable();
        if (n == 0) {
            this.ClipBoardRadioButton.setSelected(true);
            this.FileRadioButton.setSelected(false);
            this.filenameField.setEnabled(false);
            this.fileSelButton.setEnabled(false);
            this.prefixField.setEnabled(false);
        } else {
            this.ClipBoardRadioButton.setSelected(false);
            this.FileRadioButton.setSelected(true);
            this.filenameField.setEnabled(true);
            this.fileSelButton.setEnabled(true);
            this.prefixField.setEnabled(true);
        }
        this.ClipBoardRadioButton.addItemListener(this);
        this.FileRadioButton.addItemListener(this);
        this.fileSelButton.addItemListener(this);
        this.filenameField.getDocument().addDocumentListener(this);
        this.prefixField.getDocument().addDocumentListener(this);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.ClipBoardRadioButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.FileRadioButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_SCREENSHOT_SAVE_FILE_LABEL")));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(this.filenameField);
        jPanel5.add(this.fileSelButton);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_SCREENSHOT_SAVE_FILE_PREFIX")));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        jPanel7.add(this.prefixField);
        jPanel6.add(jPanel7);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel6);
        this.add("North", jPanel);
        this.fileSelButton.setActionCommand("select");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.fileSelButton.addActionListener(actionDispatcher);
    }

    @Override
    void cancel() {
    }

    void select() {
        File file = null;
        if (this.filenameField.getText().equals("") || this.filenameField.getText().length() == 0) {
            file = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "screenshot");
        } else {
            file = new File(this.filenameField.getText());
            if (!file.exists()) {
                this.parent.showDialog(Resource.getString("FILE_CHOOSER_MSG_INVALID"), this.tabwin, 2);
                return;
            }
        }
        JFileChooser jFileChooser = new JFileChooser(file.getAbsolutePath());
        jFileChooser.setDialogTitle(Resource.getString("SET_SCREENSHOT_DIALOG"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.filenameField.setText(jFileChooser.getSelectedFile().toString());
        }
    }

    @Override
    boolean set() {
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        if (this.ClipBoardRadioButton.isSelected()) {
            n2 = 0;
        } else if (this.FileRadioButton.isSelected()) {
            n2 = 1;
        }
        String string = this.filenameField.getText();
        File file = new File(string);
        if (n2 == 1 && !file.isDirectory()) {
            return false;
        }
        String string2 = this.prefixField.getText();
        n = JAMManager.setScreenshotEnable(n2);
        n = JAMManager.setScreenshotPath((string + '\u0000').getBytes());
        n = JAMManager.setScreenshotPrefix((string2 + '\u0000').getBytes());
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.ClipBoardRadioButton) {
            if (itemEvent.getStateChange() == 1) {
                this.filenameField.setEnabled(false);
                this.fileSelButton.setEnabled(false);
                this.prefixField.setEnabled(false);
            } else {
                this.filenameField.setEnabled(true);
                this.fileSelButton.setEnabled(true);
                this.prefixField.setEnabled(true);
            }
        } else if (itemEvent.getItemSelectable() == this.FileRadioButton) {
            if (itemEvent.getStateChange() == 1) {
                this.filenameField.setEnabled(true);
                this.fileSelButton.setEnabled(true);
                this.prefixField.setEnabled(true);
            } else {
                this.filenameField.setEnabled(false);
                this.fileSelButton.setEnabled(false);
                this.prefixField.setEnabled(false);
            }
        }
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }
}

