/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.ProjectFileReader;
import com.nttdocomo.dojaemu.ktoolbar.ReadWindowTable;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SelectProjectWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class SelectFullMiniProjectWindow
extends AbstractWindow {
    private final int DEFAULT_WIDTH = 600;
    private final int DEFAULT_HEIGHT = 307;
    private final int BOTTOM_BUTTON_WIDTH = 90;
    private final int BOTTOM_BUTTON_HEIGTH = 25;
    private JLabel projectPathLabel;
    private ReadWindowTable projectTable;
    private static String projectHome;
    private static String preProjectHome;
    private int windowWidth = 0;
    private int windowHeight = 0;
    private boolean firstEvent = false;
    private SelectProjectWindow sfmpParent;
    private int appType;
    private static final int TEXT_WIDTH = 30;
    private JTextField filterTextField;

    SelectFullMiniProjectWindow(SelectProjectWindow selectProjectWindow, int n) {
        super(selectProjectWindow.parent, Resource.getString("APPL_LISTWINDOW_TITLE"));
        this.addWindowListener();
        this.sfmpParent = selectProjectWindow;
        this.appType = n;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (SelectFullMiniProjectWindow.this.firstEvent) {
                    Component component = componentEvent.getComponent();
                    int n = component.getWidth();
                    int n2 = component.getHeight();
                    SelectFullMiniProjectWindow.this.storeReadWindowSize(n, n2);
                } else {
                    SelectFullMiniProjectWindow.this.firstEvent = true;
                }
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        preProjectHome = projectHome = this.parent.getProjectHome();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 0));
        jPanel2.setLayout(new BorderLayout(1, 2));
        jPanel4.setLayout(new FlowLayout(2));
        JSeparator jSeparator = new JSeparator(0);
        jPanel5.setLayout(new FlowLayout(0));
        this.projectTable = new ReadWindowTable(projectHome, n);
        this.projectTable.setSortStatus(this.parent.getSort());
        this.projectTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    SelectFullMiniProjectWindow.this.select();
                }
            }
        });
        this.projectTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SelectFullMiniProjectWindow.this.select();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.projectTable);
        this.getContentPane().add(jScrollPane);
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        Dimension dimension = new Dimension(90, 25);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton.setActionCommand("select");
        jButton2.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel2.add("North", jSeparator);
        jPanel2.add("Center", jScrollPane);
        JLabel jLabel = new JLabel(Resource.getString("FILTER_TITLE"));
        this.filterTextField = new JTextField("", 30);
        this.filterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SelectFullMiniProjectWindow.this.filter();
            }
        });
        jPanel4.add(jLabel);
        jPanel4.add(this.filterTextField);
        jPanel.add("North", jPanel4);
        container.add("North", jPanel);
        container.add("Center", jPanel2);
        container.add("South", jPanel3);
        this.getReadWindowSize();
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.windowWidth <= 0 || this.windowHeight <= 0) {
            this.setSize(600, 307);
        } else {
            this.setSize(this.windowWidth, this.windowHeight);
        }
        super.setVisible(bl);
    }

    void select() {
        String string = this.projectTable.getSelectedProject();
        ProjectFileReader projectFileReader = new ProjectFileReader(this.parent);
        if (this.projectTable.getSelectedRow() == -1 || string == null) {
            this.parent.showDialog(Resource.getString("SELECT_PROJECT_WNG"), this, 2);
            return;
        }
        if (this.appType == 2) {
            this.sfmpParent.setFullApplProjectNameField(string);
        } else {
            this.sfmpParent.setMiniApplProjectNameField(string);
        }
        this.sfmpParent.closeWindow();
    }

    void filter() {
        String string = null;
        string = this.projectTable.getSelectedProject();
        String string2 = this.filterTextField.getText();
        this.projectTable.setFilterText(string2);
        this.projectTable.resetModel(projectHome, this.appType);
        this.projectTable.loadColumnWidth();
        int n = this.projectTable.getProjectIndex(string);
        if (n != -1) {
            this.projectTable.setProjectIndex(n);
        }
    }

    void cancel() {
        this.sfmpParent.closeWindow();
    }

    public void selectCurrentProject(String string) {
        int n = -1;
        if (string != null && (n = this.projectTable.getProjectIndex(string)) != -1) {
            this.projectTable.setRowSelectionInterval(n, n);
        }
    }

    private void getReadWindowSize() {
        int n = -1;
        int n2 = JAMManager.getReadWindowWidth();
        int n3 = JAMManager.getReadWindowHeight();
        if (n2 == -1 || n3 == -1) {
            String string = Resource.getString("REGISTRY_READ_ERR");
            JOptionPane.showMessageDialog(this, string, Resource.getString("ERR"), 0);
        }
        this.windowWidth = n2;
        this.windowHeight = n3;
    }

    private void storeReadWindowSize(int n, int n2) {
        int n3 = -1;
        if (n < 600 || n2 < 307) {
            n = 600;
            n2 = 307;
        }
        if ((n3 = JAMManager.setReadWindowSize(n, n2)) == -1) {
            String string = Resource.getString("REGISTRY_ERR");
            JOptionPane.showMessageDialog(this, string, Resource.getString("ERR"), 0);
        }
        this.windowWidth = n;
        this.windowHeight = n2;
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cancel();
        }
    }
}

