/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SpeechRecognizerDDPWindow;
import com.nttdocomo.dojaemu.ktoolbar.SpeechRecognizerEntry;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComboBoxUI;

class SpeechRecognizerDataWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private SpeechRecognizerEntry entry = null;
    private JTextField txtTitle;
    private JComboBox combStatus;
    private JTextArea txtResMsg;
    private JScrollPane messageScroll;
    private JButton importButton;
    private JButton deliButton;
    private JButton optSetButton;
    private JRadioButton successDdpSelect;
    private JRadioButton otherDdpSelect;
    private JButton setButton;
    private JButton cancelButton;
    private static final String[][] screenDirectionItems = new String[][]{{"0", "SUCCESS"}, {"100", "WARNING"}, {"101", "WARNING_NOISE"}, {"102", "WARNING_LITTLE_VOICE"}, {"103", "WARNING_BIG_VOICE"}, {"104", "WARNING_FAST_SPEAKING"}, {"105", "WARNING_SLOW_SPEAKING"}, {"200", "ERROR"}, {"201", "ERROR_NOSOUND"}, {"202", "ERROR_NOISE"}, {"203", "ERROR_LITTLE_VOICE"}, {"204", "ERROR_BIG_VOICE"}, {"205", "ERROR_FAST_SPEAKING"}, {"206", "ERROR_SLOW_SPEAKING"}, {"280", "ERROR_TIMEOUT"}, {"281", "ERROR_NORESULT"}};

    SpeechRecognizerDataWindow(MainWindow mainWindow, SpeechRecognizerEntry speechRecognizerEntry, boolean bl) {
        super(mainWindow, Resource.getString("EDIR_S_R_DET"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.entry = speechRecognizerEntry;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("SR_TITLE"));
        JLabel jLabel2 = new JLabel(Resource.getString("SR_STATUS"));
        JLabel jLabel3 = new JLabel(Resource.getString("SR_RES"));
        this.combStatus = new JComboBox();
        this.combStatus.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.txtTitle = new JTextField(20);
        this.txtResMsg = new JTextArea(5, 80);
        this.txtResMsg.setFont(new Font("Monospaced", this.txtResMsg.getFont().getStyle(), 12));
        this.txtTitle.setHorizontalAlignment(2);
        this.messageScroll = new JScrollPane();
        this.messageScroll.getViewport().add(this.txtResMsg);
        this.importButton = new JButton(Resource.getString("COMMON_IMPORT"));
        this.deliButton = new JButton(Resource.getString("CLEAR"));
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.optSetButton = new JButton(Resource.getString("SET_UP"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SR_RES_PANEL")));
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SR_DDP_PANEL")));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout());
        jPanel.add(jLabel);
        jPanel.add(this.getFlowPanel(this.txtTitle, 0));
        container.add(jPanel);
        jPanel3.add(this.importButton);
        jPanel3.add(this.deliButton);
        jPanel5.add(jLabel2);
        jPanel5.add(this.combStatus);
        jPanel4.add(jPanel5);
        this.successDdpSelect = new JRadioButton();
        this.otherDdpSelect = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.successDdpSelect);
        buttonGroup.add(this.otherDdpSelect);
        this.successDdpSelect.setText(Resource.getString("SR_DDP_OPT_OK"));
        this.otherDdpSelect.setText(Resource.getString("SR_DDP_OPT_OTHER"));
        jPanel6.add(this.successDdpSelect);
        jPanel6.add(this.otherDdpSelect);
        jPanel6.add(this.optSetButton);
        jPanel4.add(this.getFlowPanel(jLabel3, 0));
        jPanel4.add(this.messageScroll);
        jPanel4.add(jPanel3);
        jPanel7.add(jPanel6);
        jPanel2.add(this.setButton);
        jPanel2.add(this.cancelButton);
        jPanel7.add(jPanel2);
        container.add(jPanel4);
        container.add(jPanel7);
        container.add(jPanel2);
        this.deliButton.setActionCommand("recogDel");
        this.importButton.setActionCommand("recogImp");
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        this.optSetButton.setActionCommand("optSet");
        this.successDdpSelect.setActionCommand("successDdpSelect");
        this.otherDdpSelect.setActionCommand("otherDdpSelect");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.deliButton.addActionListener(actionDispatcher);
        this.importButton.addActionListener(actionDispatcher);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.optSetButton.addActionListener(actionDispatcher);
        this.successDdpSelect.addActionListener(actionDispatcher);
        this.otherDdpSelect.addActionListener(actionDispatcher);
        try {
            speechRecognizerEntry.loadRecogRes();
        }
        catch (Exception exception) {
            speechRecognizerEntry.init();
        }
        this.txtTitle.setText(speechRecognizerEntry.getSettingTitle());
        this.txtResMsg.setText(speechRecognizerEntry.getRecogRes());
        this.txtResMsg.setCaretPosition(0);
        for (int i = 0; i < screenDirectionItems.length; ++i) {
            this.combStatus.addItem(screenDirectionItems[i][1]);
            if (!screenDirectionItems[i][0].equals(speechRecognizerEntry.getSettingResultStatus())) continue;
            this.combStatus.setSelectedIndex(i);
        }
        if (speechRecognizerEntry.getSettingDDP().equals("1")) {
            this.otherDdpSelect.setSelected(true);
            this.optSetButton.setEnabled(true);
        } else {
            this.successDdpSelect.setSelected(true);
            this.optSetButton.setEnabled(false);
        }
        this.pack();
        this.setResizable(false);
    }

    void recogDel() {
        this.txtResMsg.setText("");
    }

    void recogImp() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(Resource.getString("PROJECT_HOME_DIALOG"));
        jFileChooser.setDialogType(2);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(null);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            String string2 = this.readRecogImpFile(string);
            this.txtResMsg.setText(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readRecogImpFile(String string) {
        File file = new File(string);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        String string2 = null;
        if (file.exists() && file.isFile()) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                int n = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (n != 0) {
                        stringBuffer.append(System.getProperty("line.separator"));
                    }
                    stringBuffer.append(string2);
                    ++n;
                }
            }
            catch (Exception exception) {
                System.err.println(Resource.format("READ_ERR", file.getPath()));
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return stringBuffer.toString();
    }

    void set() {
        if (this.txtTitle.getText().equals("")) {
            JOptionPane.showMessageDialog(this, Resource.getString("SR_DET_WNG_CHECK_TITLE"), Resource.getString("WNG"), 2);
            return;
        }
        try {
            this.entry.setSettingTitle(this.txtTitle.getText());
            this.entry.setRecogRes(this.txtResMsg.getText());
            this.entry.setSettingResultStatus(screenDirectionItems[this.combStatus.getSelectedIndex()][0]);
            this.entry.saveRecogRes();
            this.entry.saveSetting();
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", ""));
            return;
        }
        catch (Exception exception) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void optSet() {
        try {
            SpeechRecognizerDDPWindow speechRecognizerDDPWindow = new SpeechRecognizerDDPWindow(this.parent, this.entry, false);
            speechRecognizerDDPWindow.setLocation(this.parent.getShowLocation(speechRecognizerDDPWindow.getWidth(), speechRecognizerDDPWindow.getHeight(), this));
            speechRecognizerDDPWindow.setVisible(true);
        }
        catch (Exception exception) {
            return;
        }
    }

    void successDdpSelect() {
        this.entry.setSettingDDP("0");
        this.entry.setSettingNegoRes("200");
        this.entry.setSettingSendRes("200");
        this.entry.setSettingSendTime("1");
        this.entry.setSettingResultRes("200");
        this.entry.setSettingCancelRes("200");
        this.entry.setSettingEndRes("200");
        this.optSetButton.setEnabled(false);
    }

    void otherDdpSelect() {
        this.entry.setSettingDDP("1");
        this.optSetButton.setEnabled(true);
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

