/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SpeechRecognizerDataWindow;
import com.nttdocomo.dojaemu.ktoolbar.SpeechRecognizerEntry;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class SpeechRecognizerWindow
extends TabPanel {
    private JTable ddpEmuTable;
    private int next = 0;
    private JScrollPane scrollpane;
    private String[] entryDir = null;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton selectButton;
    private final int SR_ENABLED_WIDTH = 100;

    SpeechRecognizerWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.selectButton = new JButton(Resource.getString("COMMON_SELECTION"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        this.selectButton.setActionCommand("up");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.selectButton.addActionListener(actionDispatcher);
        jPanel.add(this.addButton);
        jPanel.add(this.editButton);
        jPanel.add(this.deleteButton);
        jPanel.add(this.selectButton);
        this.ddpEmuTable = this.createddpEmuTable();
        this.scrollpane = new JScrollPane(this.ddpEmuTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel);
    }

    private JTable createddpEmuTable() {
        JTable jTable = null;
        int n = 0;
        String[] stringArray = new String[]{Resource.getString("SR_ENABLED"), Resource.getString("SR_NAME")};
        ddpEmuTableModel ddpEmuTableModel2 = new ddpEmuTableModel(stringArray, 0);
        SpeechRecognizerEntry speechRecognizerEntry = new SpeechRecognizerEntry();
        try {
            if (speechRecognizerEntry.loadMasterEntry()) {
                n = speechRecognizerEntry.getEntryId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entryDir = null;
        this.entryDir = speechRecognizerEntry.listDirEntry();
        if (this.entryDir == null) {
            this.changeButtonEnabled();
            return jTable;
        }
        try {
            for (int i = 0; i < this.entryDir.length; ++i) {
                speechRecognizerEntry.setEntryId(Integer.parseInt(this.entryDir[i]));
                if (!speechRecognizerEntry.loadRecogSettingEntry()) continue;
                Vector<String> vector = new Vector<String>();
                if (n == speechRecognizerEntry.getEntryId()) {
                    vector.addElement(Resource.getString("SR_SELECTED"));
                } else {
                    vector.addElement("");
                }
                vector.addElement(speechRecognizerEntry.getSettingTitle());
                ddpEmuTableModel2.addRow(vector);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jTable = new JTable(ddpEmuTableModel2);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(100);
        tableColumn.setPreferredWidth(100);
        jTable.setDefaultRenderer(Object.class, new ddpEmuTableCellRenderer());
        jTable.setSelectionMode(0);
        this.next = speechRecognizerEntry.getNextId();
        if (this.next <= 0) {
            this.next = 1;
        }
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    SpeechRecognizerWindow.this.entrySelect();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SpeechRecognizerWindow.this.entrySelect();
                }
            }
        });
        return jTable;
    }

    void entrySelect() {
        this.edit();
    }

    void add() {
        if (JAMManager.getState() != 4) {
            JOptionPane.showMessageDialog(this, Resource.getString("SR_DET_WNG_APP_RUNNING"), Resource.getString("WNG"), 2);
            return;
        }
        SpeechRecognizerEntry speechRecognizerEntry = new SpeechRecognizerEntry();
        speechRecognizerEntry.setEntryId(this.next);
        speechRecognizerEntry.init();
        SpeechRecognizerDataWindow speechRecognizerDataWindow = new SpeechRecognizerDataWindow(this.parent, speechRecognizerEntry, true);
        speechRecognizerDataWindow.setLocation(this.parent.getShowLocation(speechRecognizerDataWindow.getWidth(), speechRecognizerDataWindow.getHeight(), this.tabwin));
        speechRecognizerDataWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.ddpEmuTable = null;
        this.ddpEmuTable = this.createddpEmuTable();
        this.scrollpane = new JScrollPane(this.ddpEmuTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void edit() {
        if (JAMManager.getState() != 4) {
            JOptionPane.showMessageDialog(this, Resource.getString("SR_DET_WNG_APP_RUNNING"), Resource.getString("WNG"), 2);
            return;
        }
        if (this.ddpEmuTable.getSelectedRowCount() == 1) {
            int n = this.ddpEmuTable.getSelectedRow();
            SpeechRecognizerEntry speechRecognizerEntry = new SpeechRecognizerEntry();
            speechRecognizerEntry.setEntryId(Integer.parseInt(this.entryDir[n]));
            try {
                if (!speechRecognizerEntry.loadRecogSettingEntry()) {
                    return;
                }
                speechRecognizerEntry.saveSetting();
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", "setting file"));
                return;
            }
            catch (Exception exception) {
                System.err.println(Resource.format("READ_ERR", "setting file"));
                return;
            }
            SpeechRecognizerDataWindow speechRecognizerDataWindow = new SpeechRecognizerDataWindow(this.parent, speechRecognizerEntry, false);
            speechRecognizerDataWindow.setLocation(this.parent.getShowLocation(speechRecognizerDataWindow.getWidth(), speechRecognizerDataWindow.getHeight(), this.tabwin));
            speechRecognizerDataWindow.setVisible(true);
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.ddpEmuTable = null;
            this.ddpEmuTable = this.createddpEmuTable();
            this.scrollpane = new JScrollPane(this.ddpEmuTable);
            this.add("Center", this.scrollpane);
            this.ddpEmuTable.setRowSelectionInterval(n, n);
            this.setVisible(true);
        }
    }

    void delete() {
        if (this.ddpEmuTable.getSelectedRowCount() < 1) {
            return;
        }
        if (JAMManager.getState() != 4) {
            JOptionPane.showMessageDialog(this, Resource.getString("SR_DET_WNG_APP_RUNNING"), Resource.getString("WNG"), 2);
            return;
        }
        if (this.ddpEmuTable.getRowCount() <= 1) {
            JOptionPane.showMessageDialog(this, Resource.getString("SR_WNG_DELETE_NON_DATA"), Resource.getString("WNG"), 2);
            return;
        }
        int n = this.ddpEmuTable.getSelectedRow();
        String string = this.ddpEmuTable.getModel().getValueAt(n, 0).toString();
        if (!string.equals("")) {
            JOptionPane.showMessageDialog(this, Resource.getString("SR_WNG_DELETE_SELECTED_DATA"), Resource.getString("WNG"), 2);
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, Resource.getString("SR_DELETE_WNG"), Resource.getString("CONFIRM"), 0);
        if (n2 == 0) {
            SpeechRecognizerEntry speechRecognizerEntry = new SpeechRecognizerEntry();
            speechRecognizerEntry.deleteSettingEntry(this.entryDir[this.ddpEmuTable.getSelectedRow()]);
            try {
                speechRecognizerEntry.sortEntryId();
                this.next = speechRecognizerEntry.getNextId();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.ddpEmuTable = null;
            this.ddpEmuTable = this.createddpEmuTable();
            this.scrollpane = new JScrollPane(this.ddpEmuTable);
            this.add("Center", this.scrollpane);
            this.setVisible(true);
        }
    }

    void up() {
        if (JAMManager.getState() != 4) {
            JOptionPane.showMessageDialog(this, Resource.getString("SR_DET_WNG_APP_RUNNING"), Resource.getString("WNG"), 2);
            return;
        }
        if (this.ddpEmuTable.getSelectedRowCount() == 1) {
            int n = this.ddpEmuTable.getSelectedRow();
            SpeechRecognizerEntry speechRecognizerEntry = new SpeechRecognizerEntry();
            speechRecognizerEntry.setEntryId(Integer.parseInt(this.entryDir[n]));
            try {
                if (!speechRecognizerEntry.loadRecogSettingEntry()) {
                    return;
                }
                speechRecognizerEntry.saveEntry();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.ddpEmuTable = null;
            this.ddpEmuTable = this.createddpEmuTable();
            this.scrollpane = new JScrollPane(this.ddpEmuTable);
            this.add("Center", this.scrollpane);
            this.ddpEmuTable.setRowSelectionInterval(n, n);
            this.setVisible(true);
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.entryDir != null && this.entryDir.length > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            if (this.entryDir.length >= 1) {
                this.selectButton.setEnabled(true);
            } else {
                this.selectButton.setEnabled(false);
            }
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.selectButton.setEnabled(false);
        }
    }

    public void addRow(final JTable jTable, final Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jTable != null && SpeechRecognizerWindow.this.ddpEmuTable != null && jTable.equals(SpeechRecognizerWindow.this.ddpEmuTable)) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                    defaultTableModel.addRow(objectArray);
                }
            }
        });
    }

    public int delete(int n) throws ImportException {
        return n;
    }

    class ddpEmuTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ddpEmuTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class ddpEmuTableModel
    extends DefaultTableModel {
        ddpEmuTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

