/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.DecimalDocument;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SurveyEntry;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.plaf.ComboBoxUI;

class SurveyDataWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private SurveyEntry entry = null;
    private boolean pFlag = true;
    private JComboBox latitudeCombo;
    private JComboBox longitudeCombo;
    private JTextField latitudeDegreeField;
    private JTextField latitudeDecimalField;
    private JTextField longitudeDegreeField;
    private JTextField longitudeDecimalField;
    private JTextField altitudeField;
    private JTextField surveyTimeField;
    private ButtonGroup accuracyLevelButtonGroup;
    private JRadioButton accuracyCoarseRadioButton;
    private JRadioButton accuracyNormalRadioButton;
    private JRadioButton accuracyFineRadioButton;
    private JButton setButton;
    private JButton cancelButton;
    private String[] latitudePrefixItems = null;
    private String[] longitudePrefixItems = null;
    private String ILLEGAL_TIME = "1";
    private String ILLEGAL_LONGITUDE = "3";
    private String ILLEGAL_LATITUDE = "4";
    private String ILLEGAL_ALTITUDE = "5";
    private static final int DECIMAL_COLUMN = 6;

    SurveyDataWindow(MainWindow mainWindow, SurveyEntry surveyEntry, boolean bl) {
        super(mainWindow, Resource.getString("SURVEY_DATA_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.entry = surveyEntry;
        this.pFlag = bl;
        this.latitudePrefixItems = new String[2];
        this.latitudePrefixItems[0] = new String("N  ");
        this.latitudePrefixItems[1] = new String("S  ");
        this.longitudePrefixItems = new String[2];
        this.longitudePrefixItems[0] = new String("E  ");
        this.longitudePrefixItems[1] = new String("W ");
        this.latitudeCombo = new JComboBox<String>(this.latitudePrefixItems);
        this.longitudeCombo = new JComboBox<String>(this.longitudePrefixItems);
        this.latitudeCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.longitudeCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        String string = this.getDegreePart(surveyEntry.getLatitude(), 0);
        if (string.equals("N") || string.equals("+")) {
            this.latitudeCombo.setSelectedIndex(0);
        } else {
            this.latitudeCombo.setSelectedIndex(1);
        }
        string = this.getDegreePart(surveyEntry.getLongitude(), 0);
        if (string.equals("E") || string.equals("+")) {
            this.longitudeCombo.setSelectedIndex(0);
        } else {
            this.longitudeCombo.setSelectedIndex(1);
        }
        JLabel jLabel = new JLabel(Resource.getString("GPS_ACCURACY_LEVEL"));
        JLabel jLabel2 = new JLabel(Resource.getString("GPS_LATITUDE"));
        JLabel jLabel3 = new JLabel(Resource.getString("GPS_LONGITUDE"));
        JLabel jLabel4 = new JLabel(Resource.getString("GPS_ALTITUDE"));
        JLabel jLabel5 = new JLabel("m");
        JLabel jLabel6 = new JLabel(Resource.getString("GPS_DATUM_TYPE"));
        JLabel jLabel7 = new JLabel(Resource.getString("SURVEY_TIME"));
        JLabel jLabel8 = new JLabel(Resource.getString("SECOND"));
        JLabel jLabel9 = new JLabel(".");
        JLabel jLabel10 = new JLabel(".");
        JLabel jLabel11 = new JLabel(Resource.getString("SURVEY_METHOD"));
        int n = surveyEntry.getDatum();
        String string2 = null;
        string2 = n == 0 ? " " + Resource.getString("GPS_DATUM_WGS84") : " " + Resource.getString("GPS_DATUM_TOKYO");
        JLabel jLabel12 = new JLabel(string2);
        int n2 = surveyEntry.getMethod();
        String string3 = null;
        if (n2 == 0) {
            string3 = " " + Resource.getString("SURVEY_METHOD_GPS");
        }
        JLabel jLabel13 = new JLabel(string3);
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.accuracyCoarseRadioButton = new JRadioButton("1");
        this.accuracyNormalRadioButton = new JRadioButton("2");
        this.accuracyFineRadioButton = new JRadioButton("3");
        this.accuracyLevelButtonGroup = new ButtonGroup();
        this.accuracyLevelButtonGroup.add(this.accuracyCoarseRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyNormalRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyFineRadioButton);
        switch (surveyEntry.getLevel()) {
            case 1: {
                this.accuracyCoarseRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.accuracyNormalRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.accuracyFineRadioButton.setSelected(true);
            }
        }
        this.latitudeDegreeField = new JTextField(3);
        this.latitudeDecimalField = new JTextField(6);
        this.latitudeDegreeField.setHorizontalAlignment(4);
        this.latitudeDecimalField.setHorizontalAlignment(2);
        this.latitudeDegreeField.setDocument(new HalfNumberDocument(2));
        this.latitudeDecimalField.setDocument(new HalfNumberDocument(6));
        this.longitudeDegreeField = new JTextField(3);
        this.longitudeDecimalField = new JTextField(6);
        this.longitudeDegreeField.setHorizontalAlignment(4);
        this.longitudeDecimalField.setHorizontalAlignment(2);
        this.longitudeDegreeField.setDocument(new HalfNumberDocument(3));
        this.longitudeDecimalField.setDocument(new HalfNumberDocument(6));
        this.latitudeDegreeField.setText(this.getDegreePart(surveyEntry.getLatitude(), 1));
        this.latitudeDecimalField.setText(this.getDegreePart(surveyEntry.getLatitude(), 2));
        this.longitudeDegreeField.setText(this.getDegreePart(surveyEntry.getLongitude(), 1));
        this.longitudeDecimalField.setText(this.getDegreePart(surveyEntry.getLongitude(), 2));
        this.altitudeField = new JTextField(10);
        this.altitudeField.setDocument(new DecimalDocument(11));
        this.altitudeField.setHorizontalAlignment(4);
        this.altitudeField.setText(surveyEntry.getAltitude());
        this.surveyTimeField = new JTextField(10);
        this.surveyTimeField.setDocument(new HalfNumberDocument(10));
        this.surveyTimeField.setHorizontalAlignment(4);
        this.surveyTimeField.setText(surveyEntry.getTime());
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new GridLayout(7, 1));
        jPanel4.setLayout(new GridLayout(7, 1));
        jPanel6.setLayout(new FlowLayout(0));
        jPanel7.setLayout(new FlowLayout(0));
        jPanel8.setLayout(new FlowLayout(0));
        jPanel8.setLayout(new FlowLayout(0));
        jPanel10.setLayout(new FlowLayout(0));
        jPanel9.setLayout(new FlowLayout(0));
        jPanel6.add(this.accuracyCoarseRadioButton);
        jPanel6.add(this.accuracyNormalRadioButton);
        jPanel6.add(this.accuracyFineRadioButton);
        jPanel7.add(this.latitudeCombo);
        jPanel7.add(this.latitudeDegreeField);
        jPanel7.add(jLabel9);
        jPanel7.add(this.latitudeDecimalField);
        jPanel8.add(this.longitudeCombo);
        jPanel8.add(this.longitudeDegreeField);
        jPanel8.add(jLabel10);
        jPanel8.add(this.longitudeDecimalField);
        jPanel10.add(this.altitudeField);
        jPanel10.add(jLabel5);
        jPanel9.add(this.surveyTimeField);
        jPanel9.add(jLabel8);
        jPanel3.add(this.getFlowPanel(jLabel, 2));
        jPanel3.add(this.getFlowPanel(jLabel2, 2));
        jPanel3.add(this.getFlowPanel(jLabel3, 2));
        jPanel3.add(this.getFlowPanel(jLabel4, 2));
        jPanel3.add(this.getFlowPanel(jLabel7, 2));
        jPanel3.add(this.getFlowPanel(jLabel6, 2));
        jPanel3.add(this.getFlowPanel(jLabel11, 2));
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel4.add(jPanel10);
        jPanel4.add(jPanel9);
        jPanel4.add(this.getFlowPanel(jLabel12, 0));
        jPanel4.add(this.getFlowPanel(jLabel13, 0));
        jPanel5.add(this.setButton);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add("Center", jPanel2);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    private String getSurveyDataPath() {
        return System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "survey_data" + File.separator + "survey_data";
    }

    static boolean parseDegreeLatitudeString(String string) {
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        if (string2.length() < 1 || string2.length() > 4) {
            return false;
        }
        if (string3.length() < 1 || string3.length() > 6) {
            return false;
        }
        switch (string2.charAt(0)) {
            case 'N': {
                bl = false;
                break;
            }
            case 'S': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            n = Integer.parseInt(string2.substring(1));
            if (bl) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return false;
        }
        if (n < -90 || n > 90) {
            return false;
        }
        return Math.abs(n) != 90 || n2 == 0;
    }

    private String parseAltitude() {
        String string = this.altitudeField.getText();
        String string2 = null;
        int n = 0;
        try {
            n = Integer.parseInt(string);
            string2 = Integer.toString(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private String parseSurveyTime() {
        String string = this.surveyTimeField.getText();
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        return string;
    }

    private String parseDegreeLatitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.latitudeCombo.getSelectedIndex();
        String string = ((String)this.latitudeCombo.getSelectedItem()).trim();
        String string2 = this.latitudeDegreeField.getText();
        String string3 = this.latitudeDecimalField.getText();
        String string4 = null;
        try {
            n = Integer.parseInt(string2);
            if (n3 != 0) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -90 || n > 90) {
                bl = true;
            } else if (Math.abs(n) == 90 && n2 != 0) {
                bl = true;
            } else {
                String string5 = this.getDecimalString(string3, 6);
                string4 = string + string2 + "." + string5;
            }
        }
        return string4;
    }

    static boolean parseDegreeLongitudeString(String string) {
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        if (string2.length() < 1 || string2.length() > 4) {
            return false;
        }
        if (string3.length() < 1 || string3.length() > 6) {
            return false;
        }
        switch (string2.charAt(0)) {
            case 'E': {
                bl = false;
                break;
            }
            case 'W': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            n = Integer.parseInt(string2.substring(1));
            if (bl) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return false;
        }
        if (n < -180 || n >= 180) {
            return false;
        }
        return n != -180 || n2 == 0;
    }

    private String parseDegreeLongitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.longitudeCombo.getSelectedIndex();
        String string = ((String)this.longitudeCombo.getSelectedItem()).trim();
        String string2 = this.longitudeDegreeField.getText();
        String string3 = this.longitudeDecimalField.getText();
        String string4 = null;
        try {
            n = Integer.parseInt(string2);
            if (n3 != 0) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -180 || n >= 180) {
                bl = true;
            } else if (n == -180 && n2 != 0) {
                bl = true;
            } else {
                String string5 = this.getDecimalString(string3, 6);
                string4 = string + string2 + "." + string5;
            }
        }
        return string4;
    }

    private String getDegreePart(String string, int n) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = 0;
        if (stringTokenizer.countTokens() == 2) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    try {
                        n2 = Integer.parseInt(string3);
                        if (n2 < 0) {
                            string2 = string3.substring(0, 1);
                            break;
                        }
                        string2 = "+";
                    }
                    catch (Exception exception) {
                        string2 = string3.substring(0, 1);
                    }
                    break;
                }
                case 1: {
                    try {
                        n2 = Integer.parseInt(string3);
                        if (n2 < 0) {
                            string2 = string3.substring(1);
                            break;
                        }
                        string2 = string3;
                    }
                    catch (Exception exception) {
                        string2 = string3.substring(1);
                    }
                    break;
                }
                case 2: {
                    string2 = string4;
                }
            }
        }
        return string2;
    }

    void set() {
        int n = 1;
        String string = null;
        String string2 = this.parseDegreeLatitude();
        String string3 = this.parseDegreeLongitude();
        String string4 = this.parseAltitude();
        String string5 = this.parseSurveyTime();
        String string6 = null;
        String string7 = "";
        int n2 = this.latitudeCombo.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        n2 = this.longitudeCombo.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        try {
            if (string2 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_LATITUDE);
            }
            if (string3 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_LONGITUDE);
            }
            if (string5 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_TIME);
            }
            if (string4 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_ALTITUDE);
            }
            if (this.accuracyCoarseRadioButton.isSelected()) {
                n = 1;
            } else if (this.accuracyNormalRadioButton.isSelected()) {
                n = 2;
            } else if (this.accuracyFineRadioButton.isSelected()) {
                n = 3;
            }
            string = "0," + string2 + "," + string3 + "," + string4 + "," + n + "," + string5 + "," + "0";
            string6 = this.entry.getEntryId() + ".srv";
            this.entry.save(string, string6, this.pFlag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().equals(this.ILLEGAL_LATITUDE)) {
                string7 = Resource.getString("GPS_LATITUDE");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_LONGITUDE)) {
                string7 = Resource.getString("GPS_LONGITUDE");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_TIME)) {
                string7 = Resource.getString("SURVEY_TIME");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_ALTITUDE)) {
                string7 = Resource.getString("GPS_ALTITUDE");
            }
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string7), this, 2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", string6));
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    private String getDecimalString(String string, int n) {
        String string2 = null;
        if (string.length() < 0 || n < 1) {
            string2 = null;
        } else {
            string2 = string;
            while (string2.length() < n) {
                string2 = string2 + "0";
            }
        }
        return string2;
    }
}

