/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.io.File;
import java.io.IOException;

public class ToruCaEntity {
    public static final String TORUCA_DIR = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "toruca" + File.separator;
    public static final String TORUCA_PREFIX = "toruca";
    public static final String TORUCA_EXT = ".dat";
    public static final String[] TYPE_ITEMS = new String[]{Resource.getString("TORUCA_TYPE_SNIP"), Resource.getString("TORUCA_TYPE_CARD")};
    public static final int TORUCA_TYPE_SNIP = 0;
    public static final int TORUCA_TYPE_CARD = 1;
    public static final String[] CATEGORY_GENRE_ITEMS = new String[]{"", Resource.getString("TORUCA_GENRE1"), Resource.getString("TORUCA_GENRE2"), Resource.getString("TORUCA_GENRE3"), Resource.getString("TORUCA_GENRE4"), Resource.getString("TORUCA_GENRE5"), Resource.getString("TORUCA_GENRE6"), Resource.getString("TORUCA_GENRE7"), Resource.getString("TORUCA_GENRE8"), Resource.getString("TORUCA_GENRE9"), Resource.getString("TORUCA_GENRE10")};
    public static final String[][] CATEGORY_CODE_ITEMS = new String[][]{{"0000"}, {"0032", "0036", "00FB", "0034", "0035", "00F0", "00F1", "0033", "00C3", "00EF", "00F7"}, {"00AA", "004F", "0041", "0046", "002A", "002B", "0025", "001E", "001F", "0020", "0023", "0024", "0028", "0029", "00BE", "002E", "002F", "004A", "004B", "001D", "0064", "00BD", "00B8", "004D", "0026", "0027", "00B9", "004C", "0077", "00B4", "00DA", "005E"}, {"00F2", "002D", "0049", "00EE", "00F6", "00EA", "00E9", "00E7"}, {"0066", "002C", "0093", "0039", "003A", "003C", "003F", "0040", "0016", "0017", "0018", "0019", "001A", "00B7", "001B", "0015", "001C", "0022", "00E4", "00E5", "00F5", "00F9", "0065", "00D1", "00FA", "00F3", "00F4", "0099", "009B", "009D", "00BA"}, {"00B3", "00B6", "0037", "005C", "005D", "00C0", "00BF", "00C4", "00B0", "00C1", "0045", "00AB", "0047", "0048", "0094"}, {"0038", "00B5", "00CC", "00D8", "0054", "0055", "005B", "0096", "00A2", "00CB"}, {"004E", "0050", "0051", "0052", "0053", "0009", "000A", "000B", "000C", "000D", "000E", "000F", "0010", "0011", "0012", "0013", "0014", "0056", "0057", "0058", "009A"}, {"008C", "003D", "0092", "00A7", "0021", "00C2", "00BB", "0044", "003E", "00E8"}, {"00A9", "00E3", "0097", "00DF", "00EB"}, {"0088", "0089", "008A", "008B", "0071", "008D", "008E", "008F", "0090", "00C5", "00C6", "00C7", "00C8", "00C9", "00CA", "00CD", "00CE", "00CF", "00D0", "00D2", "00D3", "00F8", "00FC", "00AC", "00ED", "00E6", "00EC", "0067", "0001", "0002", "0003", "0004", "0005", "0006", "0007", "0008", "0030", "0031", "003B", "0059", "005A", "0068", "0091", "009C", "00E1", "00E2", "0042", "0043", "005F", "0060", "0061", "0062", "0063", "0069", "006A", "006B", "006E", "00BC", "00B1", "00B2", "0074", "0075", "0079", "007A", "007B", "007C", "007D", "007E", "007F", "0080", "0081", "0082", "0083", "0084", "0085", "0086", "0087", "00D4", "0076", "0073", "0095", "0098", "009E", "009F", "00A0", "00A1", "00A3", "00A4", "00A5", "00A6", "00A8", "00AD", "00AE", "00AF", "00D5", "00D6", "00D7", "00DB", "00DC", "00D9", "00DD", "00DE", "00E0"}};
    private int entryID = 0;
    private String[] version = new String[]{"", ""};
    private int type = 0;
    private String url = "";
    private String data1 = "";
    private String data2 = "";
    private String data3 = "";
    private String category = "";
    private String ipID = "";
    private String sortID = "";
    private String redistributionID = "";
    private String colorID = "";
    private String expirationDate = "";
    private String body = "";
    private static final String SECTION_TORUCA = "Toruca";
    private static final String KEY_TORUCA_VERSION = "Version";
    private static final String KEY_TORUCA_TYPE = "Type";
    private static final String KEY_TORUCA_URL = "URL";
    private static final String KEY_TORUCA_DATA1 = "Data1";
    private static final String KEY_TORUCA_DATA2 = "Data2";
    private static final String KEY_TORUCA_DATA3 = "Data3";
    private static final String KEY_TORUCA_CAT = "Cat";
    private static final String KEY_TORUCA_IPID = "IP-ID";
    private static final String KEY_TORUCA_SORTID = "Sort-ID";
    private static final String KEY_TORUCA_DIST = "Dist";
    private static final String KEY_TORUCA_COLORID = "Color-ID";
    private static final String KEY_TORUCA_EXPIRES = "Expires";
    private static final String KEY_TORUCA_BODY = "Body";
    private static final int TORUCA_SNIP_SIZE_MAX = 1024;
    private static final int TORUCA_CARD_SIZE_MAX = 102400;
    private static final String SIGNATURE = "ToruCa";
    private static final String VERSION_KEY = "Version: ";
    private static final String TYPE_KEY = "Type: ";
    private static final String URL_KEY = "URL: ";
    private static final String DATA1_KEY = "Data1: ";
    private static final String DATA2_KEY = "Data2: ";
    private static final String DATA3_KEY = "Data3: ";
    private static final String CAT_KEY = "Cat: ";
    private static final String IPID_KEY = "IP-ID: ";
    private static final String SORTID_KEY = "Sort-ID: ";
    private static final String DIST_KEY = "Dist: ";
    private static final String COLORID_KEY = "Color-ID: ";
    private static final String EXPIRES_KEY = "Expires: ";
    private static final String CRLF = "\r\n";
    private static final byte[] B64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61};

    public void setEntryID(int n) {
        this.entryID = n;
    }

    public int getEntryID() {
        return this.entryID;
    }

    public void setVersion(String[] stringArray) {
        if (stringArray == null || stringArray.length != 2 || stringArray[0] == null || stringArray[1] == null) {
            this.version[0] = "";
            this.version[1] = "";
        } else {
            this.version[0] = stringArray[0];
            this.version[1] = stringArray[1];
        }
    }

    public String[] getVersion() {
        return this.version;
    }

    public void setType(int n) {
        this.type = n < 0 || n > TYPE_ITEMS.length ? 0 : n;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return TYPE_ITEMS[this.getType()];
    }

    public void setURL(String string) {
        this.url = string == null ? "" : string;
    }

    public String getURL() {
        return this.url;
    }

    public void setData1(String string) {
        this.data1 = string == null ? "" : string;
    }

    public String getData1() {
        return this.data1;
    }

    public void setData2(String string) {
        this.data2 = string == null ? "" : string;
    }

    public String getData2() {
        return this.data2;
    }

    public void setData3(String string) {
        this.data3 = string == null ? "" : string;
    }

    public String getData3() {
        return this.data3;
    }

    public void setCategory(String string) {
        this.category = string == null ? "" : string;
    }

    public String getCategory() {
        return this.category;
    }

    public void setIPID(String string) {
        this.ipID = string == null ? "" : string;
    }

    public String getIPID() {
        return this.ipID;
    }

    public void setSortID(String string) {
        this.sortID = string == null ? "" : string;
    }

    public String getSortID() {
        return this.sortID;
    }

    public void setRedistributionID(String string) {
        this.redistributionID = string == null ? "" : string;
    }

    public String getRedistributionID() {
        return this.redistributionID;
    }

    public void setColorID(String string) {
        this.colorID = string == null ? "" : string;
    }

    public String getColorID() {
        return this.colorID;
    }

    public void setExpirationDate(String string) {
        this.expirationDate = string == null ? "" : string;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setBody(String string) {
        this.body = string == null ? "" : string;
    }

    public String getBody() {
        return this.body;
    }

    public int getRemainingBytes() {
        int n = this.getRawDataLength();
        if (this.getType() == 1) {
            return 102400 - n;
        }
        return 1024 - n;
    }

    public String[] getRowData() {
        return new String[]{this.getTypeName(), this.getCategory(), this.getURL(), this.getData1()};
    }

    public void load(String string) throws IOException {
        int n;
        IniFileEntity iniFileEntity = new IniFileEntity(TORUCA_DIR + string);
        iniFileEntity.read();
        String[] stringArray = new String[2];
        try {
            n = Integer.parseInt(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_VERSION));
            stringArray[0] = String.valueOf(n >> 8 & 0xFF);
            stringArray[1] = String.valueOf(n & 0xFF);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setVersion(stringArray);
        try {
            n = Integer.parseInt(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_TYPE));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.setType(n);
        this.setURL(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_URL));
        String string2 = iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_DATA1);
        this.setData1(ToruCaEntity.base64Decode(string2));
        String string3 = iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_DATA2);
        this.setData2(ToruCaEntity.base64Decode(string3));
        String string4 = iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_DATA3);
        this.setData3(ToruCaEntity.base64Decode(string4));
        this.setCategory(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_CAT));
        this.setIPID(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_IPID));
        this.setSortID(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_SORTID));
        this.setRedistributionID(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_DIST));
        this.setColorID(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_COLORID));
        this.setExpirationDate(iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_EXPIRES));
        String string5 = iniFileEntity.getSectionAttribute(SECTION_TORUCA, KEY_TORUCA_BODY);
        if (string5 != null && (string5 = string5.replace('\t', '\r').replace('\u000b', '\n')).startsWith("[") && string5.endsWith("]")) {
            string5 = string5.substring(1, string5.length() - 1);
        }
        this.setBody(string5);
    }

    public void save(String string) throws IOException {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        IniFileEntity iniFileEntity = new IniFileEntity(TORUCA_DIR + string);
        String[] stringArray = this.getVersion();
        if (stringArray[0].length() > 0 && stringArray[1].length() > 0) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                string9 = String.valueOf(n << 8 | n2);
                iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_VERSION, string9);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_TYPE, String.valueOf(this.getType()));
        String string10 = this.getURL();
        if (string10.length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_URL, string10);
        }
        if ((string8 = this.getData1()).length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_DATA1, ToruCaEntity.base64Encode(string8));
        }
        if ((string9 = this.getData2()).length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_DATA2, ToruCaEntity.base64Encode(string9));
        }
        if ((string7 = this.getData3()).length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_DATA3, ToruCaEntity.base64Encode(string7));
        }
        if ((string6 = this.getCategory()).length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_CAT, string6);
        }
        if ((string5 = this.getIPID()).length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_IPID, string5);
        }
        if ((string4 = this.getSortID()).length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_SORTID, string4);
        }
        if ((string3 = this.getRedistributionID()).length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_DIST, string3);
        }
        if ((string2 = this.getColorID()).length() > 0) {
            iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_COLORID, string2);
        }
        if (this.getType() == 1) {
            String string11;
            String string12 = this.getExpirationDate();
            if (string12.length() > 0) {
                iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_EXPIRES, string12);
            }
            if ((string11 = this.getBody()).length() > 0) {
                StringBuffer stringBuffer = new StringBuffer(string11);
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    if (stringBuffer.charAt(i) != '\n' || i != 0 && stringBuffer.charAt(i - 1) == '\r') continue;
                    stringBuffer.insert(i, '\r');
                    ++i;
                }
                string11 = stringBuffer.toString();
                string11 = "[" + string11.replace('\r', '\t').replace('\n', '\u000b') + "]";
                iniFileEntity.setSectionAttribute(SECTION_TORUCA, KEY_TORUCA_BODY, string11);
            }
        }
        iniFileEntity.save();
    }

    public void remove(String string) {
        File file = new File(TORUCA_DIR + string);
        file.delete();
    }

    public static String entryNum2fName(int n) {
        String string = "00000000" + Integer.toHexString(n);
        String string2 = TORUCA_PREFIX + string.substring(string.length() - 8) + TORUCA_EXT;
        return string2;
    }

    public static int fName2entryNum(String string) {
        int n = Integer.parseInt(string.substring(TORUCA_PREFIX.length(), string.indexOf(46)), 16);
        return n;
    }

    private int TORUCA_DATA_STRING_FIELD_LENGTH(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            return string.length() + string2.length();
        }
        return 0;
    }

    private int COUNT_BASE64(int n) {
        int n2 = 0;
        n2 = n % 3 > 0 ? 1 : 0;
        return (n / 3 + n2) * 4;
    }

    private int getRawDataLength() {
        String string;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n += SIGNATURE.length();
        n += CRLF.length();
        n += VERSION_KEY.length() + 3;
        n += CRLF.length();
        n += TYPE_KEY.length() + 4;
        n += CRLF.length();
        n3 = n += CRLF.length();
        n = 0;
        n2 = this.TORUCA_DATA_STRING_FIELD_LENGTH(URL_KEY, this.getURL());
        if (n2 > 0) {
            n += n2 + CRLF.length();
        }
        if ((n2 = this.getDataFieldLength(DATA1_KEY, this.getData1())) > 0) {
            n += n2 + CRLF.length();
        }
        if ((n2 = this.getDataFieldLength(DATA2_KEY, this.getData2())) > 0) {
            n += n2 + CRLF.length();
        }
        if ((n2 = this.getDataFieldLength(DATA3_KEY, this.getData3())) > 0) {
            n += n2 + CRLF.length();
        }
        if ((n2 = this.TORUCA_DATA_STRING_FIELD_LENGTH(CAT_KEY, this.getCategory())) > 0) {
            n += n2 + CRLF.length();
        }
        if ((n2 = this.TORUCA_DATA_STRING_FIELD_LENGTH(IPID_KEY, this.getIPID())) > 0) {
            n += n2 + CRLF.length();
        }
        if ((n2 = this.TORUCA_DATA_STRING_FIELD_LENGTH(SORTID_KEY, this.getSortID())) > 0) {
            n += n2 + CRLF.length();
        }
        if ((n2 = this.TORUCA_DATA_STRING_FIELD_LENGTH(DIST_KEY, this.getRedistributionID())) > 0) {
            n += n2 + CRLF.length();
        }
        if ((n2 = this.TORUCA_DATA_STRING_FIELD_LENGTH(COLORID_KEY, this.getColorID())) > 0) {
            n += n2 + CRLF.length();
        }
        if (this.getType() == 1 && (n2 = this.TORUCA_DATA_STRING_FIELD_LENGTH(EXPIRES_KEY, this.getExpirationDate())) > 0) {
            n += n2 + CRLF.length();
        }
        n4 = n += CRLF.length();
        n = 0;
        if (this.getType() == 1 && (string = this.getBody()) != null && string.length() > 0) {
            n += string.length();
        }
        n5 = n;
        n = n3 + n4 + n5;
        return n;
    }

    private int getDataFieldLength(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            return string.length() + this.COUNT_BASE64(string2.length());
        }
        return 0;
    }

    private static int VAL(byte by) {
        if (by == 61) {
            return 0;
        }
        int n = new String(B64).indexOf(by);
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public static String base64Decode(String string) {
        if (string == null) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        byte[] byArray = string.getBytes();
        int n3 = byArray.length;
        if (n3 % 4 > 0) {
            return string;
        }
        n = 0;
        while ((n & n3) != n3) {
            if (new String(B64).indexOf(byArray[n]) == -1) {
                return string;
            }
            n += 4;
        }
        byte[] byArray2 = new byte[n3];
        n = 0;
        while ((n & n3) != n3) {
            byArray2[n2] = (byte)(ToruCaEntity.VAL(byArray[n]) << 2 | (ToruCaEntity.VAL(byArray[n + 1]) & 0x30) >> 4);
            byArray2[n2 + 1] = (byte)((ToruCaEntity.VAL(byArray[n + 1]) & 0xF) << 4 | (ToruCaEntity.VAL(byArray[n + 2]) & 0x3C) >> 2);
            byArray2[n2 + 2] = (byte)((ToruCaEntity.VAL(byArray[n + 2]) & 3) << 6 | ToruCaEntity.VAL(byArray[n + 3]) & 0x3F);
            n2 += 3;
            n += 4;
        }
        int n4 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] != 0) continue;
            n4 = i;
            break;
        }
        return new String(byArray2, 0, n4);
    }

    public static String base64Encode(String string) {
        byte[] byArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (string != null) {
            byte[] byArray2 = string.getBytes();
            n3 = byArray2.length;
            n5 = n3 % 3;
            n4 = n5 == 0 ? n3 / 3 * 4 : (n3 + (3 - n5)) / 3 * 4;
            byArray = new byte[n4];
            if (n3 > 0) {
                n = 0;
                while (n3 - n >= 3) {
                    byArray[n2] = B64[(byArray2[n] & 0xFC) >> 2];
                    byArray[n2 + 1] = B64[(byArray2[n] & 3) << 4 | (byArray2[n + 1] & 0xF0) >> 4];
                    byArray[n2 + 2] = B64[(byArray2[n + 1] & 0xF) << 2 | (byArray2[n + 2] & 0xC0) >> 6];
                    byArray[n2 + 3] = B64[byArray2[n + 2] & 0x3F];
                    n2 += 4;
                    n += 3;
                }
                if (n5 == 1) {
                    byArray[n2] = B64[(byArray2[n] & 0xFC) >> 2];
                    byArray[n2 + 1] = B64[(byArray2[n] & 3) << 4];
                    byArray[n2 + 2] = 61;
                    byArray[n2 + 3] = 61;
                } else if (n5 == 2) {
                    byArray[n2] = B64[(byArray2[n] & 0xFC) >> 2];
                    byArray[n2 + 1] = B64[(byArray2[n] & 3) << 4 | (byArray2[n + 1] & 0xF0) >> 4];
                    byArray[n2 + 2] = B64[(byArray2[n + 1] & 0xF) << 2];
                    byArray[n2 + 3] = 61;
                }
            }
        } else {
            return string;
        }
        return new String(byArray);
    }
}

