/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AndFilenameFilter;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SuffixFilenameFilter;
import com.nttdocomo.dojaemu.ktoolbar.ToruCaFilenameFilter;
import com.nttdocomo.dojaemu.ktoolbar.ToruCaViewerWindow;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ToruCaSelectWindow
extends AbstractWindow {
    private String datName = null;
    private String datPath = null;
    private JList readList;
    private static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();

    ToruCaSelectWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("TORUCA_SELECT_WINDOW_TITLE"));
        this.addWindowListener();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.datPath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "toruca";
        String[] stringArray = new File(this.datPath).list(new AndFilenameFilter(new ToruCaFilenameFilter("toruca"), new SuffixFilenameFilter("dat")));
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.readList = new JList<String>(stringArray);
        this.readList.setVisibleRowCount(12);
        this.readList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.readList);
        JButton jButton = new JButton(Resource.getString("READ2"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.setActionCommand("read");
        jButton2.setActionCommand("cancel");
        this.readList.addListSelectionListener(new WindowListSelectionListener());
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        container.add("Center", jScrollPane);
        container.add("South", jPanel);
        this.pack();
    }

    void read() {
        if (this.datName == null) {
            this.parent.showDialog(Resource.getString("SELECT_TORUCA_WNG"), this, 2);
            return;
        }
        this.parent.closeWindow(this);
        try {
            this.parent.tvw = new ToruCaViewerWindow(this.parent, this.datPath + File.separator + this.datName);
            this.parent.tvw.setLocation(this.parent.getShowLocation(this.parent.tvw.getWidth(), this.parent.tvw.getHeight(), this.parent));
            JAMManager.exitChild();
            this.parent.tvw.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    class WindowListSelectionListener
    implements ListSelectionListener {
        WindowListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ToruCaSelectWindow.this.datName = (String)ToruCaSelectWindow.this.readList.getSelectedValue();
            }
        }
    }
}

