/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringChecker;

class VerifyAccelerationData {
    private static final int INDEX_DIR_X = 0;
    private static final int INDEX_DIR_Y = 1;
    private static final int INDEX_DIR_Z = 2;
    private static final int INDEX_ROLL = 3;
    private static final int INDEX_PITCH = 4;
    private static final int INDEX_ORIENTATION = 5;

    VerifyAccelerationData() {
    }

    static void verify(String[] stringArray) throws ImportException {
        if (stringArray.length != 6) {
            throw new ImportException(-1, 1, Resource.getString("IMPORT_EMES_INVALID_VALUE_NUM"));
        }
        VerifyAccelerationData.verifyAcceleration(stringArray[0], 0);
        VerifyAccelerationData.verifyAcceleration(stringArray[1], 1);
        VerifyAccelerationData.verifyAcceleration(stringArray[2], 2);
        VerifyAccelerationData.verifyAngle(stringArray[3], 3);
        VerifyAccelerationData.verifyAngle(stringArray[4], 4);
        VerifyAccelerationData.verifyOrientation(stringArray[5], 5);
    }

    static String[] adjust(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = VerifyAccelerationData.adjustAcceleration(stringArray[0], 0);
        stringArray2[1] = VerifyAccelerationData.adjustAcceleration(stringArray[1], 1);
        stringArray2[2] = VerifyAccelerationData.adjustAcceleration(stringArray[2], 2);
        stringArray2[3] = VerifyAccelerationData.adjustAngle(stringArray[3], 3);
        stringArray2[4] = VerifyAccelerationData.adjustAngle(stringArray[4], 4);
        stringArray2[5] = VerifyAccelerationData.adjustOrientation(stringArray[5], 5);
        return stringArray2;
    }

    private static void verifyAcceleration(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        long l = 0L;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 11) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isAscii()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            l = Long.parseLong(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (l < Integer.MIN_VALUE || Integer.MAX_VALUE < l) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustAcceleration(String string, int n) {
        return VerifyAccelerationData.zeroSuppress(string);
    }

    private static void verifyAngle(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        int n3 = 0;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 4) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isAscii()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            n3 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (n3 < -180 || 180 <= n3) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustAngle(String string, int n) {
        return VerifyAccelerationData.zeroSuppress(string);
    }

    private static void verifyOrientation(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        int n3 = 0;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 3) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isAscii()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            n3 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (n3 != -1 && (0 > n3 || n3 > 270 || n3 % 90 != 0)) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustOrientation(String string, int n) {
        return VerifyAccelerationData.zeroSuppress(string);
    }

    private static String zeroSuppress(String string) {
        int n;
        boolean bl = false;
        String string2 = string.trim();
        char[] cArray = string2.toCharArray();
        for (n = 0; n < cArray.length - 1; ++n) {
            if (n == 0 && cArray[n] == '-') {
                bl = true;
                continue;
            }
            if (cArray[n] != '0') break;
        }
        return (bl ? "-" : "") + string2.substring(n, cArray.length);
    }
}

