/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringChecker;

class VerifySurveyData {
    private static final int INDEX_LATITUDE = 0;
    private static final int INDEX_LONGITUDE = 1;
    private static final int INDEX_ALTITUDE = 2;
    private static final int INDEX_LEVEL = 3;
    private static final int INDEX_TIME = 4;
    private static final int INDEX_DATUM = 5;
    private static final int INDEX_METHOD = 6;

    VerifySurveyData() {
    }

    static void verify(String[] stringArray) throws ImportException {
        if (stringArray.length != 7) {
            throw new ImportException(-1, 1, Resource.getString("IMPORT_EMES_INVALID_VALUE_NUM"));
        }
        VerifySurveyData.verifyIdoKeido(stringArray[0], 0);
        VerifySurveyData.verifyIdoKeido(stringArray[1], 1);
        VerifySurveyData.verifyAltitude(stringArray[2], 2);
        VerifySurveyData.verifyLevel(stringArray[3], 3);
        VerifySurveyData.verifyTime(stringArray[4], 4);
        VerifySurveyData.verifyDatum(stringArray[5], 5);
        VerifySurveyData.verifyMethod(stringArray[6], 6);
    }

    static String[] adjust(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = VerifySurveyData.adjustIdoKeido(stringArray[0], 0);
        stringArray2[1] = VerifySurveyData.adjustIdoKeido(stringArray[1], 1);
        stringArray2[2] = VerifySurveyData.adjustAltitude(stringArray[2], 2);
        stringArray2[3] = VerifySurveyData.adjustLevel(stringArray[3], 3);
        stringArray2[4] = VerifySurveyData.adjustTime(stringArray[4], 4);
        stringArray2[5] = VerifySurveyData.adjustDatum(stringArray[5], 5);
        stringArray2[6] = VerifySurveyData.adjustMethod(stringArray[6], 6);
        return stringArray2;
    }

    private static void verifyIdoKeido(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        double d = 0.0;
        String[][] stringArrayArray = new String[][]{{"N", "S"}, {"E", "W"}};
        double[][] dArrayArray = new double[][]{{-90.0, 90.0}, {-180.0, 180.0}};
        boolean bl = false;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n == 0 && 10 < n2 || n == 1 && 11 < n2) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!string.startsWith(stringArrayArray[n][0]) && !string.startsWith(stringArrayArray[n][1])) {
            throw new ImportException(n, 3, Resource.getString("IMPORT_EMES_INVALID_PREFIX"));
        }
        if (!new StringChecker(string.trim()).isAscii()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        bl = !string.startsWith(stringArrayArray[n][0]);
        int n3 = string.indexOf(".");
        try {
            String string2 = null;
            String string3 = null;
            if (n3 < 0 || n2 <= n3 + 1) {
                string2 = string.substring(1);
                d = Double.parseDouble(string2);
            } else {
                string2 = string.substring(1, n3);
                string3 = n2 - (n3 + 1) > 6 ? string.substring(n3 + 1, n3 + 7) : string.substring(n3 + 1);
                d = Double.parseDouble(string2 + "." + string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (d < 0.0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (bl) {
            d *= -1.0;
        }
        if (n == 0 && (d < dArrayArray[n][0] || dArrayArray[n][1] < d) || n == 1 && (d < dArrayArray[n][0] || dArrayArray[n][1] <= d)) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustIdoKeido(String string, int n) {
        String[][] stringArrayArray = new String[][]{{"N", "S"}, {"E", "W"}};
        String string2 = null;
        String string3 = null;
        String string4 = string.trim();
        int n2 = string4.indexOf(".");
        int n3 = string4.length();
        if (n2 < 0 || n3 <= n2 + 1) {
            string2 = string4.substring(1);
            string3 = "000000";
        } else {
            string2 = string4.substring(1, n2);
            string3 = n3 - (n2 + 1) > 6 ? string4.substring(n2 + 1, n2 + 7) : string4.substring(n2 + 1);
        }
        for (int i = string3.length(); i < 6; ++i) {
            string3 = string3 + "0";
        }
        String string5 = (string4.startsWith(stringArrayArray[n][0]) ? stringArrayArray[n][0] : stringArrayArray[n][1]) + VerifySurveyData.zeroSuppress(string2) + "." + string3;
        return string5;
    }

    private static void verifyAltitude(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        long l = 0L;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 11) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isAscii()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            l = Long.parseLong(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (l < Integer.MIN_VALUE || Integer.MAX_VALUE < l) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustAltitude(String string, int n) {
        return VerifySurveyData.zeroSuppress(string);
    }

    private static void verifyLevel(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        int n3 = 0;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 1) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isHalfNumber()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            n3 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (n3 < 1 || 3 < n3) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustLevel(String string, int n) {
        return VerifySurveyData.zeroSuppress(string);
    }

    private static void verifyTime(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        long l = 0L;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 10) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isHalfNumber()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            l = Long.parseLong(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (l < 0L || Integer.MAX_VALUE < l) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustTime(String string, int n) {
        return VerifySurveyData.zeroSuppress(string);
    }

    private static void verifyDatum(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        int n3 = 0;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 1) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isHalfNumber()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            n3 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (n3 != 0) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustDatum(String string, int n) {
        return VerifySurveyData.zeroSuppress(string);
    }

    private static void verifyMethod(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        int n3 = 0;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 1) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isHalfNumber()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            n3 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (n3 != 0) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustMethod(String string, int n) {
        return VerifySurveyData.zeroSuppress(string);
    }

    private static String zeroSuppress(String string) {
        int n;
        boolean bl = false;
        String string2 = string.trim();
        char[] cArray = string2.toCharArray();
        for (n = 0; n < cArray.length - 1; ++n) {
            if (n == 0 && cArray[n] == '-') {
                bl = true;
                continue;
            }
            if (cArray[n] != '0') break;
        }
        return (bl ? "-" : "") + string2.substring(n, cArray.length);
    }
}

