/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.adfcheck;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.adfcheck.AdfCheckWindowActionListener;
import com.nttdocomo.dojaemu.ktoolbar.adfcheck.AdfCheckWindowWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class AdfCheckWindow
extends JFrame {
    private MainWindow parent = null;
    private static final String TITLE = Resource.getString("ADF_CHECK_WINDOW_TITLE");
    private JTextField urlField;
    private String urlString;
    private JTextArea adfTextArea;
    private JTextArea infoTextArea;
    private String infoMessage;
    private final int FILE_SIZE = 4096;
    private static File adfFile = null;
    private static final String ADF_NAME = File.separator + "checkADF.jam";
    private static final File DOWNLOAD_ADF_DIR = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "downloadadf" + File.separator);
    private static final String HTTP_SCHEME = "http://";

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        AdfCheckWindow adfCheckWindow = new AdfCheckWindow();
    }

    private AdfCheckWindow() {
        this.makeAdfCheckWindow();
        this.setVisible(true);
    }

    public AdfCheckWindow(MainWindow mainWindow) {
        this.parent = mainWindow;
        this.makeAdfCheckWindow();
    }

    private void makeAdfCheckWindow() {
        this.setTitle(TITLE);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("ADF_DOWNLOAD_URL"));
        this.urlField = new JTextField(20);
        this.adfTextArea = new JTextArea(16, 80);
        this.infoTextArea = new JTextArea(6, 80);
        this.adfTextArea.setFont(new Font("monospaced", 0, 15));
        this.infoTextArea.setFont(new Font("monospaced", 0, 15));
        this.adfTextArea.setEditable(false);
        this.infoTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.adfTextArea);
        JScrollPane jScrollPane2 = new JScrollPane(this.infoTextArea);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        JButton jButton = new JButton(Resource.getString("ADF_DOWNLOAD_BUTTON"));
        JButton jButton2 = new JButton(Resource.getString("ADF_CHECK_BUTTON"));
        JButton jButton3 = new JButton(Resource.getString("CLOSE"));
        this.addWindowListener(new AdfCheckWindowWindowAdapter(this));
        AdfCheckWindowActionListener adfCheckWindowActionListener = new AdfCheckWindowActionListener(this);
        this.urlField.setActionCommand("downLoad");
        jButton.setActionCommand("downLoad");
        jButton2.setActionCommand("adfCheck");
        jButton3.setActionCommand("exit");
        this.urlField.addActionListener(adfCheckWindowActionListener);
        jButton.addActionListener(adfCheckWindowActionListener);
        jButton2.addActionListener(adfCheckWindowActionListener);
        jButton3.addActionListener(adfCheckWindowActionListener);
        jButton3.setMnemonic(69);
        this.urlField.setText(HTTP_SCHEME);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(this.urlField);
        jPanel2.add(jSplitPane);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        container.add("North", jPanel);
        container.add("Center", jSplitPane);
        container.add("South", jPanel3);
        this.setIconImage(MainWindow.titlebarIconImage.getImage());
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downLoad() {
        String string = Resource.getString("COMPLETE_READING");
        byte[] byArray = new byte[4096];
        int n = 0;
        FilterInputStream filterInputStream = null;
        FileOutputStream fileOutputStream = null;
        this.adfTextArea.setText("");
        this.infoTextArea.setText("");
        this.infoMessage = null;
        adfFile = null;
        this.urlString = this.urlField.getText().trim();
        if (this.urlString.length() == 0) {
            return;
        }
        if (this.urlString.length() > 255) {
            try {
                Object[] objectArray = new String[]{Resource.getString("ADF_DOWNLOAD_URL"), "255"};
                this.infoMessage = Resource.format("OVER_VAL_WNG", objectArray);
                this.showInfoArea();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        if (!this.isASCIICharacters(this.urlString)) {
            this.infoMessage = Resource.format("WRNG_VAL_WNG", Resource.getString("ADF_DOWNLOAD_URL"));
            this.showInfoArea();
            return;
        }
        int n2 = this.urlString.lastIndexOf(".");
        if (n2 < 0) {
            this.infoMessage = Resource.getString("ADF_ERROR_IN_EXTENSION");
            System.err.println(this.infoMessage);
            this.showInfoArea();
            this.setTitle(TITLE + " - " + this.infoMessage);
            return;
        }
        String string2 = this.urlString.substring(n2);
        if (!".jam".equals(string2.toLowerCase())) {
            this.infoMessage = Resource.getString("ADF_ERROR_IN_EXTENSION");
            System.err.println(this.infoMessage);
            this.showInfoArea();
            this.setTitle(TITLE + " - " + this.infoMessage);
            return;
        }
        this.setTitle(TITLE + Resource.getString("READING"));
        try {
            URL uRL = new URL(this.urlString);
            if (!(uRL.getProtocol().equals("http") || uRL.getProtocol().equals("https") || uRL.getProtocol().equals("file"))) {
                throw new MalformedURLException();
            }
            filterInputStream = new DataInputStream(uRL.openStream());
            adfFile = new File(DOWNLOAD_ADF_DIR + ADF_NAME);
            fileOutputStream = new FileOutputStream(adfFile);
            n = ((DataInputStream)filterInputStream).read(byArray, 0, 4096);
            while (n >= 0) {
                fileOutputStream.write(byArray, 0, n);
                n = ((DataInputStream)filterInputStream).read(byArray, 0, 4096);
            }
            this.showAdfArea();
        }
        catch (MalformedURLException malformedURLException) {
            this.infoMessage = string = Resource.getString("PROTOCOL_ERR");
            System.err.println(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.infoMessage = string = Resource.format("NOT_FOUND_ERR2", this.urlString);
            System.err.println(string);
        }
        catch (IOException iOException) {
            this.infoMessage = string = Resource.getString("COM_ERR");
            System.err.println(string);
            System.err.println(iOException);
        }
        catch (Exception exception) {
            this.infoMessage = string = Resource.getString("ADF_CHECK_RESULT_UNKNOWN_ERROR");
            System.err.println(string);
            System.err.println(exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (this.infoMessage != null) {
                adfFile = null;
                this.showInfoArea();
            }
            this.setTitle(TITLE + " - " + string);
        }
    }

    private void showAdfArea() throws FileNotFoundException, IOException {
        BufferedReader bufferedReader = null;
        int n = 1;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(adfFile)));
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = "000".concat(String.valueOf(n));
                this.adfTextArea.append(string2.substring(string2.length() - 3) + " ");
                this.adfTextArea.append(string + "\n");
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.urlString = adfFile.toString();
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adfCheck() {
        if (adfFile == null) {
            return;
        }
        try {
            byte[] byArray = AdfCheckWindow.adfCheck0((adfFile.toString() + "\u0000").getBytes());
            if (byArray.length > 0) {
                this.infoMessage = new String(byArray);
            }
            if ("NONE".equals(this.infoMessage)) {
                this.infoMessage = Resource.getString("ADF_CHECK_RESULT_OK");
            }
        }
        catch (Exception exception) {
            this.infoMessage = Resource.getString("ADF_CHECK_RESULT_UNKNOWN_ERROR");
            System.err.println(this.infoMessage);
            System.err.println(exception);
        }
        finally {
            this.showInfoArea();
        }
    }

    private void showInfoArea() {
        this.infoTextArea.setText(this.infoMessage + "\n");
    }

    void exit() {
        adfFile = null;
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.parent.closeWindow(this);
        }
    }

    boolean isASCIICharacters(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] <= '~') continue;
            return false;
        }
        return true;
    }

    public static native byte[] adfCheck0(byte[] var0);
}

