/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.classFileStructure;

import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Code;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.InnerClass;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.JavaClass;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.LineNumberTable;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.LocalVariableTable;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.StackMapEntry;

public class Attribute {
    private static final int ATTR_UNKNOWN = 0;
    private static final int ATTR_CODE = 1;
    private static final int ATTR_CONSTANT_VALUE = 2;
    private static final int ATTR_EXCEPTIONS = 3;
    private static final int ATTR_INNERCLASSES = 4;
    private static final int ATTR_SYNTHETIC = 5;
    private static final int ATTR_SOURCE_FILE = 6;
    private static final int ATTR_LINENUMBER_TABLE = 7;
    private static final int ATTR_LOCAL_VARIABLE_TABLE = 8;
    private static final int ATTR_DEPRECATED = 9;
    private static final int ATTR_STACK_MAP = 10;
    private static final String[] ATTR_NAMES = new String[]{"Unknown", "Code", "ConstantValue", "Exceptions", "InnerClasses", "Synthetic", "SourceFile", "LineNumberTable", "LocalVariableTable", "Deprecated", "StackMap"};
    private int nameIndex = 0;
    private int length = 0;
    private int type = 0;
    private byte[] info = null;
    private Code codeAttribute = null;
    private int constantvalueIndex = 0;
    private int numberOfExceptions = 0;
    private int[] exceptionIndexTable = null;
    private int numberOfClasses = 0;
    private InnerClass[] innerClasses = null;
    private int sourcefileIndex = 0;
    private int lineNumberTableLength = 0;
    private LineNumberTable[] lineNumberTable = null;
    private int localVariableTableLength = 0;
    private LocalVariableTable[] localVariableTable = null;
    private int numberOfEntries = 0;
    private StackMapEntry[] stackMapEntrys = null;
    private JavaClass jc = null;

    private Attribute() {
    }

    Attribute(JavaClass javaClass) {
        this.jc = javaClass;
        this.nameIndex = this.jc.getInt(2);
        this.length = this.jc.getInt(4);
        String string = this.jc.getConstantPoolInfo(this.nameIndex);
        if (ATTR_NAMES[1].equals(string)) {
            this.type = 1;
            this.codeAttribute = new Code(this.jc);
        } else if (ATTR_NAMES[2].equals(string)) {
            this.type = 2;
            this.constantvalueIndex = this.jc.getInt(2);
        } else if (ATTR_NAMES[3].equals(string)) {
            this.type = 3;
            this.numberOfExceptions = this.jc.getInt(2);
            this.exceptionIndexTable = new int[this.numberOfExceptions];
            for (int i = 0; i < this.numberOfExceptions; ++i) {
                this.exceptionIndexTable[i] = this.jc.getInt(2);
            }
        } else if (ATTR_NAMES[4].equals(string)) {
            this.type = 4;
            this.numberOfClasses = this.jc.getInt(2);
            this.innerClasses = new InnerClass[this.numberOfClasses];
            for (int i = 0; i < this.numberOfClasses; ++i) {
                this.innerClasses[i] = new InnerClass(this.jc);
            }
        } else if (ATTR_NAMES[5].equals(string)) {
            this.type = 5;
        } else if (ATTR_NAMES[6].equals(string)) {
            this.type = 6;
            this.sourcefileIndex = this.jc.getInt(2);
        } else if (ATTR_NAMES[7].equals(string)) {
            this.type = 7;
            this.lineNumberTableLength = this.jc.getInt(2);
            this.lineNumberTable = new LineNumberTable[this.lineNumberTableLength];
            for (int i = 0; i < this.lineNumberTableLength; ++i) {
                this.lineNumberTable[i] = new LineNumberTable(this.jc);
            }
        } else if (ATTR_NAMES[8].equals(string)) {
            this.type = 8;
            this.localVariableTableLength = this.jc.getInt(2);
            this.localVariableTable = new LocalVariableTable[this.localVariableTableLength];
            for (int i = 0; i < this.localVariableTableLength; ++i) {
                this.localVariableTable[i] = new LocalVariableTable(this.jc);
            }
        } else if (ATTR_NAMES[9].equals(string)) {
            this.type = 9;
        } else if (ATTR_NAMES[10].equals(string)) {
            this.type = 10;
            this.numberOfEntries = this.jc.getInt(2);
            this.stackMapEntrys = new StackMapEntry[this.numberOfEntries];
            for (int i = 0; i < this.numberOfEntries; ++i) {
                this.stackMapEntrys[i] = new StackMapEntry(this.jc);
            }
        } else {
            this.info = this.jc.getBytes(this.length);
        }
    }

    public int getType() {
        return this.type;
    }

    public Code getCodeAttribute() {
        return this.codeAttribute;
    }

    public LocalVariableTable[] getLocalVariableTable() {
        return (LocalVariableTable[])this.localVariableTable.clone();
    }

    public int getLocalVariableTableLength() {
        return this.localVariableTableLength;
    }

    public boolean isCodeAttribute() {
        return this.checkType(1);
    }

    public boolean isSynthetic() {
        return this.checkType(5);
    }

    public boolean isLocalVariableTable() {
        return this.checkType(8);
    }

    private boolean checkType(int n) {
        return this.type == n;
    }
}

