/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.classFileStructure;

import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Attribute;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.ConstantPool;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Field;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Method;

public class JavaClass {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SUPER = 32;
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private byte[] data = null;
    private int dataPosition = 0;
    private byte[] magicNumber = new byte[4];
    private int minorVersion = 0;
    private int majorVersion = 0;
    private int constantPoolCount = 0;
    private ConstantPool[] constantPools = null;
    private int accessFlag = 0;
    private int thisClass = 0;
    private int superClass = 0;
    private int interfaceCount = 0;
    private int[] interfaces = null;
    private int fieldCount = 0;
    private Field[] fields = null;
    private int methodCount = 0;
    private Method[] methods = null;
    private int attributeCount = 0;
    private Attribute[] attributes = null;

    private JavaClass() {
    }

    public JavaClass(byte[] byArray) {
        int n;
        this.data = (byte[])byArray.clone();
        this.dataPosition = 0;
        int n2 = 0;
        while (this.dataPosition < this.magicNumber.length) {
            this.magicNumber[n2++] = byArray[this.dataPosition];
            ++this.dataPosition;
        }
        this.minorVersion = this.getInt(2);
        this.majorVersion = this.getInt(2);
        this.constantPoolCount = this.getInt(2);
        this.constantPools = new ConstantPool[this.constantPoolCount];
        for (n = 1; n < this.constantPoolCount; ++n) {
            this.constantPools[n] = new ConstantPool(this);
            if (5 != this.constantPools[n].getTag() && 6 != this.constantPools[n].getTag()) continue;
            ++n;
        }
        this.accessFlag = this.getInt(2);
        this.thisClass = this.getInt(2);
        this.superClass = this.getInt(2);
        this.interfaceCount = this.getInt(2);
        this.interfaces = new int[this.interfaceCount];
        for (n = 0; n < this.interfaceCount; ++n) {
            this.interfaces[n] = this.getInt(2);
        }
        this.fieldCount = this.getInt(2);
        this.fields = new Field[this.fieldCount];
        for (n = 0; n < this.fieldCount; ++n) {
            this.fields[n] = new Field(this);
        }
        this.methodCount = this.getInt(2);
        this.methods = new Method[this.methodCount];
        for (n = 0; n < this.methodCount; ++n) {
            this.methods[n] = new Method(this);
        }
        this.attributeCount = this.getInt(2);
        this.attributes = new Attribute[this.attributeCount];
        for (n = 0; n < this.attributeCount; ++n) {
            this.attributes[n] = new Attribute(this);
        }
    }

    short getShort(int n) {
        short s = (short)(this.data[this.dataPosition++] & 0xFF);
        for (int i = n; 1 < i; --i) {
            s = (short)(s << 8 | this.data[this.dataPosition++] & 0xFF);
        }
        return s;
    }

    int getInt(int n) {
        if (2 >= n) {
            return this.getShort(n);
        }
        int n2 = this.data[this.dataPosition++] & 0xFF;
        for (int i = n; 1 < i; --i) {
            n2 = n2 << 8 | this.data[this.dataPosition++] & 0xFF;
        }
        return n2;
    }

    float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    long getLong(int n) {
        long l = 0L;
        for (int i = n; 0 < i; --i) {
            l = l << 8 | (long)this.data[this.dataPosition++] & 0xFFL;
        }
        return l;
    }

    double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }

    String getString(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = n; 0 < i; --i) {
            byArray[n2++] = this.data[this.dataPosition++];
        }
        try {
            return new String(byArray, "UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.data[this.dataPosition++];
        }
        return byArray;
    }

    int getDataPosition() {
        return this.dataPosition;
    }

    String getConstantPoolInfo(int n) {
        return this.constantPools[n].getDetailString();
    }

    public boolean isInterface() {
        return (this.accessFlag & 0x200) == 512;
    }

    public Method[] getMethods() {
        return (Method[])this.methods.clone();
    }

    public int[] getInterfaceIndex() {
        return (int[])this.interfaces.clone();
    }

    public int getInterfaceCount() {
        return this.interfaceCount;
    }

    public ConstantPool getConstantPool(int n) {
        return this.constantPools[n];
    }

    public int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    public String getClassName() {
        return this.getConstantPoolInfo(this.thisClass);
    }

    public String getSuperClassName() {
        return this.getConstantPoolInfo(this.superClass);
    }

    String getDescriptorSourceCode(String string) {
        char[] cArray = new char[]{'Z', 'C', 'B', 'S', 'I', 'J', 'F', 'D', 'V'};
        String[] stringArray = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void"};
        char[] cArray2 = string.toCharArray();
        boolean bl = false;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block0: for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == '(' || cArray2[i] == ')') {
                stringBuffer.append(cArray2[i]);
                continue;
            }
            if (cArray2[i] == '[') {
                bl = true;
                ++n;
                continue;
            }
            if (cArray2[i] == 'L') {
                if (1 < stringBuffer.length() && stringBuffer.toString().lastIndexOf(")") != stringBuffer.length() - 1) {
                    stringBuffer.append(", ");
                }
                ++i;
                while (i < cArray2.length - 1 && cArray2[i] != ';') {
                    stringBuffer.append(cArray2[i]);
                    ++i;
                }
                if (bl) {
                    while (n > 0) {
                        stringBuffer.append("[]");
                        --n;
                    }
                    n = 0;
                }
                bl = false;
                continue;
            }
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray2[i] != cArray[j]) continue;
                if (1 < stringBuffer.length() && stringBuffer.toString().lastIndexOf(")") != stringBuffer.length() - 1) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[j]);
                if (bl) {
                    while (n > 0) {
                        stringBuffer.append("[]");
                        --n;
                    }
                    n = 0;
                }
                bl = false;
                continue block0;
            }
        }
        return stringBuffer.toString();
    }

    public boolean isSynthetic() {
        for (int i = 0; i < this.attributeCount; ++i) {
            if (!this.attributes[i].isSynthetic()) continue;
            return true;
        }
        return false;
    }

    public String[] getSuperInterfaceName() {
        int[] nArray = this.getInterfaceIndex();
        if (nArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.getConstantPoolInfo(nArray[i]);
        }
        return stringArray;
    }
}

