/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver10;

import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipIssue;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipManufacture;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipSystem;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipUnuse;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipUserData;
import java.util.Vector;

class FaverChipBlockManager {
    static final int BLOCK_SIZE = 16;
    static final int INFO_SIZE = 4;
    static final int TOTAL_BLOCK = 320;
    static final int BLOCK_TOTAL_SIZE = 5120;
    static final int INFO_TOTAL_SIZE = 1280;
    static final int TOTAL_SIZE = 6400;
    static final int COMMON_DATA_BLOCK = 286;
    static final int FREE_DATA_BLOCK = 34;
    static final int COMMON_AREA0000_POS = 3;
    static final int FREE_AREA0000_POS = 289;
    byte[][] faverData = new byte[320][16];
    byte[][] faverInfo = new byte[320][4];
    private int useBlockNum;
    private int useAreaNum;
    private int useServiceNum;
    private Vector vBlock = new Vector();
    private Vector vArea = new Vector();
    private Vector vService = new Vector();

    FaverChipBlockManager(byte[] byArray) {
        for (int i = 0; i < 320; ++i) {
            System.arraycopy(byArray, i * 16, this.faverData[i], 0, 16);
            System.arraycopy(byArray, 5120 + i * 4, this.faverInfo[i], 0, 4);
        }
    }

    Vector makeBlocks() {
        for (int i = 0; i < 320; ++i) {
            FaverChipBlock faverChipBlock;
            if (this.faverInfo[i][0] == 4) {
                faverChipBlock = new FaverChipArea(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                this.vArea.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 5) {
                faverChipBlock = new FaverChipService(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                this.vService.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 6) {
                faverChipBlock = new FaverChipUserData(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 1) {
                faverChipBlock = new FaverChipManufacture(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 2) {
                faverChipBlock = new FaverChipIssue(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 3) {
                faverChipBlock = new FaverChipSystem(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                continue;
            }
            faverChipBlock = new FaverChipUnuse(i, this.faverData[i], this.faverInfo[i]);
            this.vBlock.add(faverChipBlock);
        }
        this.useAreaNum = this.vArea.size();
        this.useServiceNum = this.vService.size();
        this.useBlockNum = this.vBlock.size();
        return this.vBlock;
    }

    Vector getAreaVector() {
        return this.vArea;
    }

    Vector getServiceVector() {
        return this.vService;
    }

    byte[] getFaverData() {
        byte[] byArray = new byte[6400];
        for (int i = 0; i < 320; ++i) {
            FaverChipBlock faverChipBlock = (FaverChipBlock)this.vBlock.get(i);
            byte[] byArray2 = faverChipBlock.getDataBytes();
            byte[] byArray3 = faverChipBlock.getInfoBytes();
            System.arraycopy(byArray2, 0, byArray, i * 16, 16);
            System.arraycopy(byArray3, 0, byArray, 5120 + i * 4, 4);
        }
        return byArray;
    }
}

