/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20;

import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipBlockContainerID;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipBlockContainerIssue;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipIssue;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipManufacture;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipSystem;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipUnuse;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipUserData;
import java.util.Vector;

class FaverChipBlockManager {
    static final int BLOCK_SIZE = 16;
    static final int INFO_SIZE = 6;
    static final int TOTAL_BLOCK = 1024;
    static final int BLOCK_TOTAL_SIZE = 16384;
    static final int INFO_TOTAL_SIZE = 6144;
    static final int TOTAL_SIZE = 22528;
    static final int COMMON_DATA_BLOCK = 976;
    static final int FREE_DATA_BLOCK = 48;
    static final int COMMON_AREA0000_POS = 5;
    static final int FREE_AREA0000_POS = 979;
    byte[][] faverData = new byte[1024][16];
    byte[][] faverInfo = new byte[1024][6];
    private int useBlockNum;
    private int useAreaNum;
    private int useServiceNum;
    private Vector vBlock = new Vector();
    private Vector vArea = new Vector();
    private Vector vService = new Vector();
    private Vector vSystem = new Vector();
    private Vector vIDm = new Vector();

    FaverChipBlockManager(byte[] byArray) {
        for (int i = 0; i < 1024; ++i) {
            System.arraycopy(byArray, i * 16, this.faverData[i], 0, 16);
            System.arraycopy(byArray, 16384 + i * 6, this.faverInfo[i], 0, 6);
        }
    }

    Vector makeBlocks() {
        for (int i = 0; i < 1024; ++i) {
            FaverChipBlock faverChipBlock;
            if (this.faverInfo[i][0] == 4) {
                faverChipBlock = new FaverChipArea(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                this.vArea.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 5) {
                faverChipBlock = new FaverChipService(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                this.vService.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 6) {
                faverChipBlock = new FaverChipUserData(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 1) {
                faverChipBlock = new FaverChipManufacture(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                this.vIDm.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 2) {
                faverChipBlock = new FaverChipIssue(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 3) {
                faverChipBlock = new FaverChipSystem(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                this.vSystem.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 7) {
                faverChipBlock = new FaverChipBlockContainerID(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                continue;
            }
            if (this.faverInfo[i][0] == 8) {
                faverChipBlock = new FaverChipBlockContainerIssue(i, this.faverData[i], this.faverInfo[i]);
                this.vBlock.add(faverChipBlock);
                continue;
            }
            faverChipBlock = new FaverChipUnuse(i, this.faverData[i], this.faverInfo[i]);
            this.vBlock.add(faverChipBlock);
        }
        this.useAreaNum = this.vArea.size();
        this.useServiceNum = this.vService.size();
        this.useBlockNum = this.vBlock.size();
        return this.vBlock;
    }

    Vector getAreaVector() {
        return this.vArea;
    }

    Vector getServiceVector() {
        return this.vService;
    }

    Vector getSystemVector() {
        return this.vSystem;
    }

    Vector getIDmVector() {
        return this.vIDm;
    }

    byte[] getFaverData() {
        byte[] byArray = new byte[22528];
        for (int i = 0; i < 1024; ++i) {
            FaverChipBlock faverChipBlock = (FaverChipBlock)this.vBlock.get(i);
            byte[] byArray2 = faverChipBlock.getDataBytes();
            byte[] byArray3 = faverChipBlock.getInfoBytes();
            System.arraycopy(byArray2, 0, byArray, i * 16, 16);
            System.arraycopy(byArray3, 0, byArray, 16384 + i * 6, 6);
        }
        return byArray;
    }
}

